/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.java6.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.internal.core.gef.policy.snapping.IAbsoluteLayoutCommands;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.swing.java6.model.GroupLayoutParserVisitor;
import org.eclipse.wb.internal.swing.java6.model.SpringInfo;
import org.eclipse.wb.internal.swing.java6.model.WidgetSpringInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;

public final class GroupLayoutInfo
extends LayoutInfo
implements IAbsoluteLayoutCommands {
    private static final String GROUP_LAYOUT_CLASS_NAME = "javax.swing.GroupLayout";
    static final String GROUP_LAYOUT_GROUP_CLASS_NAME = "javax.swing.GroupLayout.Group";
    static final String PROPERTY_NAME_GROUP = "group";
    public static final String IDENTIFIER_CREATE_PARALLEL_GROUP = "createParallelGroup";
    static final String IDENTIFIER_CREATE_SEQUENTIAL_GROUP = "createSequentialGroup";
    public static final String IDENTIFIER_CREATE_BASELINE_GROUP = "createBaselineGroup";
    static final String IDENTIFIER_ADD_CONTAINER_GAP = "addContainerGap";
    static final String IDENTIFIER_ADD_PREFERRED_GAP = "addPreferredGap";
    static final String IDENTIFIER_ADD_GAP = "addGap";
    static final String IDENTIFIER_ADD_COMPONENT = "addComponent";
    static final String IDENTIFIER_ADD_GROUP = "addGroup";
    private static final String SIGNATURE_SET_HORIZONTAL_GROUP = "setHorizontalGroup(javax.swing.GroupLayout.Group)";
    private static final String SIGNATURE_SET_VERTICAL_GROUP = "setVerticalGroup(javax.swing.GroupLayout.Group)";
    private final SpringInfo[] m_rootGroups = new SpringInfo[2];
    private final Map<IAbstractComponentInfo, WidgetSpringInfo>[] m_widgetMaps = new Map[2];

    public GroupLayoutInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
        this.m_widgetMaps[0] = new HashMap<IAbstractComponentInfo, WidgetSpringInfo>();
        this.m_widgetMaps[1] = new HashMap<IAbstractComponentInfo, WidgetSpringInfo>();
        this.addBroadcastListener(new JavaEventListener(){

            public void bindComponents(List<JavaInfo> components) throws Exception {
                GroupLayoutInfo.this.parse();
            }
        });
    }

    public void adjustAttachmentOffset(IAbstractComponentInfo widget, int side, int moveDelta) throws Exception {
    }

    public void attachAbsolute(IAbstractComponentInfo widget, int side, int distance) throws Exception {
        this.save();
    }

    public void attachWidgetParallelly(IAbstractComponentInfo widget, IAbstractComponentInfo attachToWidget, int side, int distance) throws Exception {
    }

    public void attachWidgetSequientially(IAbstractComponentInfo widget, IAbstractComponentInfo attachToWidget, int side, int distance) throws Exception {
    }

    public void detach(IAbstractComponentInfo widget, int side) throws Exception {
    }

    public IAbstractComponentInfo getAttachedToWidget(IAbstractComponentInfo widget, int side) throws Exception {
        return null;
    }

    public boolean isAttached(IAbstractComponentInfo widget, int side) throws Exception {
        return false;
    }

    public void performAction(int actionId) {
    }

    public void setExplicitSize(IAbstractComponentInfo widget, int side, int draggingSide, int resizeDelta) throws Exception {
    }

    public final void command_CREATE(ComponentInfo component, ComponentInfo nextComponent) throws Exception {
        this.add(component, null, nextComponent);
    }

    public final void command_MOVE(ComponentInfo component, ComponentInfo nextComponent) throws Exception {
        this.move(component, null, nextComponent);
    }

    private void save() throws Exception {
        this.saveGroup(SIGNATURE_SET_HORIZONTAL_GROUP, this.m_rootGroups[0]);
        this.saveGroup(SIGNATURE_SET_VERTICAL_GROUP, this.m_rootGroups[1]);
    }

    private void saveGroup(String methodName, SpringInfo rootGroup) throws Exception {
        MethodInvocation invocation = this.getMethodInvocation(methodName);
        String groupCode = rootGroup.getCode();
        this.getEditor().replaceInvocationArguments(invocation, List.of(groupCode));
    }

    protected void parse() {
        try {
            this.m_rootGroups[0] = this.parseGroup(SIGNATURE_SET_HORIZONTAL_GROUP, this.m_widgetMaps[0]);
            this.m_rootGroups[1] = this.parseGroup(SIGNATURE_SET_VERTICAL_GROUP, this.m_widgetMaps[1]);
        }
        catch (Throwable e) {
            throw new DesignerException(1100, e, new Object[0]);
        }
        if (this.m_rootGroups[0] == null || this.m_rootGroups[1] == null) {
            throw new DesignerException(1100, new Object[0]);
        }
    }

    protected SpringInfo parseGroup(String methodName, Map<IAbstractComponentInfo, WidgetSpringInfo> widgetMaps) {
        MethodInvocation invocation = this.getMethodInvocation(methodName);
        GroupLayoutParserVisitor parser = new GroupLayoutParserVisitor(widgetMaps, methodName, this.getContainer());
        invocation.accept((ASTVisitor)parser);
        return parser.getRootGroup();
    }

    public void attachWidgetBaseline(IAbstractComponentInfo widget, IAbstractComponentInfo attachedToWidget) throws Exception {
    }
}

