/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.forms.table;

import org.eclipse.jface.action.IAction;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.TableWrapLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.swt.palette.AbsoluteLayoutEntryInfo;
import org.eclipse.wb.tests.designer.rcp.RcpGefTest;
import org.junit.jupiter.api.Test;

public class TableWrapLayoutGefTest
extends RcpGefTest {
    private static final int M = 5;
    private static final int S = 5;
    private static final int VS = 25;
    private static final int VG = 5;

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_deleteChildAndAncestorResize() throws Exception {
        CompositeInfo shell = this.openComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new TableWrapLayout());", "      {", "        Label label = new Label(composite, SWT.NONE);", "        label.setText('Label');", "      }", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setText('Button');", "      }", "    }", "  }", "}");
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)composite.getChildrenControls().get(1);
        this.canvas.select(button);
        TableWrapLayoutGefTest.waitEventLoop(10);
        IAction deleteAction = this.getDeleteAction();
        TableWrapLayoutGefTest.assertTrue((boolean)deleteAction.isEnabled());
        deleteAction.run();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new TableWrapLayout());", "      {", "        Label label = new Label(composite, SWT.NONE);", "        label.setText('Label');", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_replaceGridLayout_withAbsolute() throws Exception {
        this.prepareComponent();
        CompositeInfo shell = this.openComposite("public class Test extends Shell {", "  public Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        this.canvas.select(shell);
        TableWrapLayoutGefTest.waitEventLoop(0);
        AbsoluteLayoutEntryInfo absoluteEntry = new AbsoluteLayoutEntryInfo();
        absoluteEntry.initialize((IEditPartViewer)this.m_viewerCanvas, (JavaInfo)shell);
        absoluteEntry.activate(false);
        this.canvas.target(shell).in(250, 50).move().click();
        TableWrapLayoutGefTest.waitEventLoop(0);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setBounds(5, 5, 100, 50);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setBounds(110, 60, 100, 50);", "    }", "  }", "}");
    }

    @Test
    public void test_change_numColumns() throws Exception {
        CompositeInfo shell = this.openComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    Button button_00 = new Button(this, SWT.NONE);", "    Button button_01 = new Button(this, SWT.NONE);", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        this.canvas.select(shell);
        TableWrapLayoutGefTest.assertEquals((int)1, (int)layout.getColumns().size());
        TableWrapLayoutGefTest.assertEquals((int)2, (int)layout.getRows().size());
        layout.getPropertyByTitle("numColumns").setValue((Object)2);
        this.assertNoLoggedExceptions();
        TableWrapLayoutGefTest.assertEquals((int)2, (int)layout.getColumns().size());
        TableWrapLayoutGefTest.assertEquals((int)1, (int)layout.getRows().size());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    Button button_00 = new Button(this, SWT.NONE);", "    Button button_01 = new Button(this, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_setSizeHint_height() throws Exception {
        CompositeInfo shell = this.openComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        this.canvas.toResizeHandle(button, "resize_size", 4).beginDrag();
        this.canvas.target(button).in(0, 50).drag();
        this.canvas.endDrag();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData twd_button = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 1, 1);", "        twd_button.heightHint = 50;", "        button.setLayoutData(twd_button);", "      }", "      button.setText('New Button');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_filled() throws Exception {
        CompositeInfo composite = this.openComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new TableWrapLayout());", "    {", "      Button existingButton = new Button(this, SWT.NONE);", "      existingButton.setText('Existing Button');", "    }", "  }", "}");
        this.loadButtonWithText();
        this.canvas.moveTo((Object)composite, 5, 5);
        this.canvas.assertCommandNull();
    }

    @Test
    public void test_CREATE_virtual_0x0() throws Exception {
        CompositeInfo composite = this.openComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new TableWrapLayout());", "  }", "}");
        this.loadButtonWithText();
        this.canvas.moveTo((Object)composite, 5, 5);
        this.canvas.click();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_virtual_0x1() throws Exception {
        CompositeInfo composite = this.openComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "  }", "}");
        this.loadButtonWithText();
        this.canvas.moveTo((Object)composite, 35, 5);
        this.canvas.click();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_appendToColumn_1x0() throws Exception {
        this.openComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new TableWrapLayout());", "    {", "      Button existingButton = new Button(this, SWT.NONE);", "      existingButton.setText('Existing Button');", "    }", "  }", "}");
        Object existingButton = TableWrapLayoutGefTest.getJavaInfoByName("existingButton");
        this.loadButtonWithText();
        this.canvas.target(existingButton).inX(0.5).outY(6).move();
        this.canvas.click();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new TableWrapLayout());", "    {", "      Button existingButton = new Button(this, SWT.NONE);", "      existingButton.setText('Existing Button');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_appendToRow_0x1() throws Exception {
        this.openComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Button existingButton = new Button(this, SWT.NONE);", "      existingButton.setText('Existing Button');", "    }", "  }", "}");
        Object existingButton = TableWrapLayoutGefTest.getJavaInfoByName("existingButton");
        this.loadButtonWithText();
        this.canvas.target(existingButton).inY(0.5).outX(6).move();
        this.canvas.click();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button existingButton = new Button(this, SWT.NONE);", "      existingButton.setText('Existing Button');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_beforeFirstRow() throws Exception {
        this.openComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new TableWrapLayout());", "    {", "      Button existingButton = new Button(this, SWT.NONE);", "      existingButton.setText('Existing Button');", "    }", "  }", "}");
        Object existingButton = TableWrapLayoutGefTest.getJavaInfoByName("existingButton");
        this.loadButtonWithText();
        this.canvas.target(existingButton).inX(0.5).outY(-2).move();
        this.canvas.click();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "    {", "      Button existingButton = new Button(this, SWT.NONE);", "      existingButton.setText('Existing Button');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_beforeFirstColumn() throws Exception {
        this.openComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Button existingButton = new Button(this, SWT.NONE);", "      existingButton.setText('Existing Button');", "    }", "  }", "}");
        Object existingButton = TableWrapLayoutGefTest.getJavaInfoByName("existingButton");
        this.loadButtonWithText();
        this.canvas.target(existingButton).inY(0.5).outX(-2).move();
        this.canvas.click();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "    {", "      Button existingButton = new Button(this, SWT.NONE);", "      existingButton.setText('Existing Button');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_insertColumn() throws Exception {
        this.openComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button 1');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button 2');", "    }", "  }", "}");
        Object button_1 = TableWrapLayoutGefTest.getJavaInfoByName("button_1");
        this.loadButtonWithText();
        this.canvas.target(button_1).inY(0.5).outX(2).move();
        this.canvas.click();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 3;", "      setLayout(layout);", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button 1');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button 2');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_insertRow() throws Exception {
        this.openComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new TableWrapLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button 1');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button 2');", "    }", "  }", "}");
        Object button_1 = TableWrapLayoutGefTest.getJavaInfoByName("button_1");
        this.loadButtonWithText();
        this.canvas.target(button_1).inX(0.5).outY(2).move();
        this.canvas.click();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new TableWrapLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button 1');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button 2');", "    }", "  }", "}");
    }

    @Test
    public void test_PASTE_virtual_1x0() throws Exception {
        this.openComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new TableWrapLayout());", "    {", "      Button existingButton = new Button(this, SWT.NONE);", "      existingButton.setText('My Button');", "    }", "  }", "}");
        Object existingButton = TableWrapLayoutGefTest.getJavaInfoByName("existingButton");
        this.doCopyPaste((JavaInfo)existingButton);
        this.canvas.target(existingButton).inX(0.5).outY(6).move();
        this.canvas.click();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new TableWrapLayout());", "    {", "      Button existingButton = new Button(this, SWT.NONE);", "      existingButton.setText('My Button');", "    }", "    {", "      Button existingButton = new Button(this, SWT.NONE);", "      existingButton.setText('My Button');", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_virtual_1x0() throws Exception {
        this.openComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('Existing Button');", "    }", "  }", "}");
        Object button = TableWrapLayoutGefTest.getJavaInfoByName("button");
        this.canvas.beginDrag(button);
        this.canvas.target(button).inX(0.5).outY(6).drag();
        this.canvas.endDrag();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new TableWrapLayout());", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('Existing Button');", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_virtual_0x0() throws Exception {
        this.openComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('Existing Button');", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new TableWrapLayout());", "    }", "  }", "}");
        Object button = TableWrapLayoutGefTest.getJavaInfoByName("button");
        Object composite = TableWrapLayoutGefTest.getJavaInfoByName("composite");
        this.canvas.beginDrag(button);
        this.canvas.dragTo(composite, 17, 17);
        this.canvas.endDrag();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new TableWrapLayout());", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setText('Existing Button');", "      }", "    }", "  }", "}");
    }
}

