/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.gbl;

import java.util.List;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.GridBagConstraintsInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.GridBagLayoutInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.gbl.AbstractGridBagLayoutTest;
import org.eclipse.wb.tests.designer.swing.model.util.SurroundSupportTest;
import org.junit.jupiter.api.Test;

public class GridBagLayoutSurroundSupportTest
extends AbstractGridBagLayoutTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_GridBagLayout_0() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout gridBagLayout = new GridBagLayout();\n\t\tsetLayout(gridBagLayout);\n\t\t{\n\t\t\tJButton button_00 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_00, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_10_BAD = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_10_BAD, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_11 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button_11, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        ComponentInfo button_00 = (ComponentInfo)GridBagLayoutSurroundSupportTest.getJavaInfoByName("button_00");
        ComponentInfo button_11 = (ComponentInfo)GridBagLayoutSurroundSupportTest.getJavaInfoByName("button_11");
        SurroundSupportTest.assertNoSurroundManager((ObjectInfo)panel, List.of(button_00, button_11));
    }

    @Test
    public void test_GridBagLayout_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout gridBagLayout = new GridBagLayout();\n\t\tsetLayout(gridBagLayout);\n\t\t{\n\t\t\tJTable table = new JTable();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(table, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        ComponentInfo table = (ComponentInfo)panel.getChildrenComponents().get(0);
        SurroundSupportTest.runSurround("javax.swing.JScrollPane", new ObjectInfo[]{table});
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout gridBagLayout = new GridBagLayout();\n\t\tsetLayout(gridBagLayout);\n\t\t{\n\t\t\tJScrollPane scrollPane = new JScrollPane();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.BOTH;\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(scrollPane, gbc);\n\t\t\t{\n\t\t\t\tJTable table = new JTable();\n\t\t\t\tscrollPane.setViewportView(table);\n\t\t\t}\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_GridBagLayout_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout gridBagLayout = new GridBagLayout();\n\t\tsetLayout(gridBagLayout);\n\t\t{\n\t\t\tJButton button_00 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_00, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_10 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_10, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        ComponentInfo button_00 = (ComponentInfo)GridBagLayoutSurroundSupportTest.getJavaInfoByName("button_00");
        ComponentInfo button_10 = (ComponentInfo)GridBagLayoutSurroundSupportTest.getJavaInfoByName("button_10");
        SurroundSupportTest.runSurround_JPanel(new ObjectInfo[]{button_00, button_10});
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout gridBagLayout = new GridBagLayout();\n\t\tsetLayout(gridBagLayout);\n\t\t{\n\t\t\tJPanel panel = new JPanel();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.BOTH;\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(panel, gbc);\n\t\t\tGridBagLayout gridBagLayout_1 = new GridBagLayout();\n\t\t\tgridBagLayout_1.columnWidths = new int[]{0, 0, 0};\n\t\t\tgridBagLayout_1.rowHeights = new int[]{0, 0};\n\t\t\tgridBagLayout_1.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};\n\t\t\tgridBagLayout_1.rowWeights = new double[]{0.0, Double.MIN_VALUE};\n\t\t\tpanel.setLayout(gridBagLayout_1);\n\t\t\t{\n\t\t\t\tJButton button_00 = new JButton();\n\t\t\t\tGridBagConstraints gbc_1 = new GridBagConstraints();\n\t\t\t\tgbc_1.insets = new Insets(0, 0, 0, 5);\n\t\t\t\tgbc_1.gridx = 0;\n\t\t\t\tgbc_1.gridy = 0;\n\t\t\t\tpanel.add(button_00, gbc_1);\n\t\t\t}\n\t\t\t{\n\t\t\t\tJButton button_10 = new JButton();\n\t\t\t\tGridBagConstraints gbc_1 = new GridBagConstraints();\n\t\t\t\tgbc_1.gridx = 1;\n\t\t\t\tgbc_1.gridy = 0;\n\t\t\t\tpanel.add(button_10, gbc_1);\n\t\t\t}\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_GridBagLayout_3() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout gridBagLayout = new GridBagLayout();\n\t\tsetLayout(gridBagLayout);\n\t\t{\n\t\t\tJButton button_00 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_00, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_10 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_10, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_20 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 2;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_20, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_01 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button_01, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_02 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 2;\n\t\t\tadd(button_02, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_11 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button_11, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_22 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 2;\n\t\t\tgbc.gridy = 2;\n\t\t\tadd(button_22, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        ComponentInfo button_11 = (ComponentInfo)GridBagLayoutSurroundSupportTest.getJavaInfoByName("button_11");
        ComponentInfo button_22 = (ComponentInfo)GridBagLayoutSurroundSupportTest.getJavaInfoByName("button_22");
        GridBagConstraintsInfo constraints = GridBagLayoutInfo.getConstraintsFor((ComponentInfo)button_11);
        GridBagLayoutSurroundSupportTest.assertEquals((int)1, (int)constraints.getX());
        GridBagLayoutSurroundSupportTest.assertEquals((int)1, (int)constraints.getY());
        constraints = GridBagLayoutInfo.getConstraintsFor((ComponentInfo)button_22);
        GridBagLayoutSurroundSupportTest.assertEquals((int)2, (int)constraints.getX());
        GridBagLayoutSurroundSupportTest.assertEquals((int)2, (int)constraints.getY());
        SurroundSupportTest.runSurround_JPanel(new ObjectInfo[]{button_11, button_22});
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout gridBagLayout = new GridBagLayout();\n\t\tsetLayout(gridBagLayout);\n\t\t{\n\t\t\tJButton button_00 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_00, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_10 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 5);\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_10, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_20 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 0);\n\t\t\tgbc.gridx = 2;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_20, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_01 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button_01, gbc);\n\t\t}\n\t\t{\n\t\t\tJPanel panel = new JPanel();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.BOTH;\n\t\t\tgbc.gridheight = 2;\n\t\t\tgbc.gridwidth = 2;\n\t\t\tgbc.insets = new Insets(0, 0, 5, 5);\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(panel, gbc);\n\t\t\tGridBagLayout gridBagLayout_1 = new GridBagLayout();\n\t\t\tgridBagLayout_1.columnWidths = new int[]{0, 0, 0};\n\t\t\tgridBagLayout_1.rowHeights = new int[]{0, 0, 0};\n\t\t\tgridBagLayout_1.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};\n\t\t\tgridBagLayout_1.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};\n\t\t\tpanel.setLayout(gridBagLayout_1);\n\t\t\t{\n\t\t\t\tJButton button_11 = new JButton();\n\t\t\t\tGridBagConstraints gbc_1 = new GridBagConstraints();\n\t\t\t\tgbc_1.insets = new Insets(0, 0, 5, 5);\n\t\t\t\tgbc_1.gridx = 0;\n\t\t\t\tgbc_1.gridy = 0;\n\t\t\t\tpanel.add(button_11, gbc_1);\n\t\t\t}\n\t\t\t{\n\t\t\t\tJButton button_22 = new JButton();\n\t\t\t\tGridBagConstraints gbc_1 = new GridBagConstraints();\n\t\t\t\tgbc_1.gridx = 1;\n\t\t\t\tgbc_1.gridy = 1;\n\t\t\t\tpanel.add(button_22, gbc_1);\n\t\t\t}\n\t\t}\n\t\t{\n\t\t\tJButton button_02 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 0, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 2;\n\t\t\tadd(button_02, gbc);\n\t\t}\n\t}\n}");
    }
}

