/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.model;

import javax.swing.BoxLayout;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.converter.IntegerConverter;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.BoxLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.BoxSupport;
import org.eclipse.wb.internal.swing.model.property.editor.alignment.AlignmentXPropertyEditor;
import org.eclipse.wb.internal.swing.model.property.editor.alignment.AlignmentYPropertyEditor;
import org.eclipse.wb.tests.designer.swing.model.layout.AbstractLayoutTest;
import org.junit.jupiter.api.Test;

public class BoxLayoutTest
extends AbstractLayoutTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_setLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        BoxLayoutTest.setLayout(panel, BoxLayout.class);
        this.assertEditor("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BoxLayout(this, BoxLayout.X_AXIS));\n\t}\n}");
        BoxLayoutTest.assertInstanceOf(BoxLayoutInfo.class, (Object)panel.getLayout());
    }

    @Test
    public void test_propertyAlignment() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BoxLayout(this, BoxLayout.X_AXIS));\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        BoxLayoutTest.assertInstanceOf(BoxLayoutInfo.class, (Object)panel.getLayout());
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property alignmentProperty = button.getPropertyByTitle("Alignment");
        BoxLayoutTest.assertTrue((boolean)alignmentProperty.getCategory().isSystem());
        Property[] subProperties = BoxLayoutTest.getSubProperties(alignmentProperty);
        BoxLayoutTest.assertEquals((int)2, (int)subProperties.length);
        BoxLayoutTest.assertEquals((Object)"alignmentX", (Object)subProperties[0].getTitle());
        BoxLayoutTest.assertEquals((Object)"alignmentY", (Object)subProperties[1].getTitle());
        BoxLayoutTest.assertFalse((boolean)subProperties[0].getCategory().isAdvanced());
        BoxLayoutTest.assertFalse((boolean)subProperties[1].getCategory().isAdvanced());
        BoxLayoutTest.assertInstanceOf(AlignmentXPropertyEditor.class, (Object)subProperties[0].getEditor());
        BoxLayoutTest.assertInstanceOf(AlignmentYPropertyEditor.class, (Object)subProperties[1].getEditor());
    }

    @Test
    public void test_noConstructor_targetProperty() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BoxLayout(this, BoxLayout.X_AXIS));\n\t}\n}");
        BoxLayoutInfo layout = (BoxLayoutInfo)panel.getLayout();
        BoxLayoutTest.assertNotNull((Object)PropertyUtils.getByPath((ObjectInfo)layout, (String)"Constructor/axis"));
        BoxLayoutTest.assertNull((Object)PropertyUtils.getByPath((ObjectInfo)layout, (String)"Constructor/target"));
    }

    @Test
    public void test_isHorizontal_X_AXIS() throws Exception {
        this.check_isHorizontal("BoxLayout.X_AXIS", true);
    }

    @Test
    public void test_isHorizontal_LINE_AXIS() throws Exception {
        this.check_isHorizontal("BoxLayout.LINE_AXIS", true);
    }

    @Test
    public void test_isHorizontal_Y_AXIS() throws Exception {
        this.check_isHorizontal("BoxLayout.Y_AXIS", false);
    }

    @Test
    public void test_isHorizontal_PAGE_AXIS() throws Exception {
        this.check_isHorizontal("BoxLayout.PAGE_AXIS", false);
    }

    private void check_isHorizontal(String axisSource, boolean expectedHorizontal) throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BoxLayout(this, %s));\n\t}\n}".formatted(axisSource));
        panel.refresh();
        BoxLayoutInfo layout = (BoxLayoutInfo)panel.getLayout();
        BoxLayoutTest.assertEquals((Object)expectedHorizontal, (Object)layout.isHorizontal());
    }

    @Test
    public void test_Box_createHorizontalBox() throws Exception {
        this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tJComponent box = Box.createHorizontalBox();\n\t\tadd(box);\n\t}\n}");
        this.refresh();
        ContainerInfo box = (ContainerInfo)BoxLayoutTest.getJavaInfoByName("box");
        BoxLayoutTest.assertTrue((boolean)box.hasLayout());
        BoxLayoutInfo boxLayout = (BoxLayoutInfo)box.getLayout();
        BoxLayoutTest.assertTrue((boolean)boxLayout.isHorizontal());
        BoxLayoutTest.assertFalse((boolean)box.canSetLayout());
    }

    @Test
    public void test_Box_createVerticalBox() throws Exception {
        this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tJComponent box = Box.createVerticalBox();\n\t\tadd(box);\n\t}\n}");
        this.refresh();
        ContainerInfo box = (ContainerInfo)BoxLayoutTest.getJavaInfoByName("box");
        BoxLayoutTest.assertTrue((boolean)box.hasLayout());
        BoxLayoutInfo boxLayout = (BoxLayoutInfo)box.getLayout();
        BoxLayoutTest.assertFalse((boolean)boxLayout.isHorizontal());
        BoxLayoutTest.assertFalse((boolean)box.canSetLayout());
    }

    @Test
    public void test_BoxSupport_setStrutSize() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tComponent strut = Box.createHorizontalStrut(10);\n\t\tadd(strut);\n\t}\n}");
        ComponentInfo strut = (ComponentInfo)panel.getChildrenComponents().get(0);
        BoxSupport.setStrutSize((ComponentInfo)strut, (String)IntegerConverter.INSTANCE.toJavaSource((JavaInfo)panel, (Object)20));
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tComponent strut = Box.createHorizontalStrut(20);\n\t\tadd(strut);\n\t}\n}");
    }
}

