/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.layouts;

import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.generation.GenerationSettings;
import org.eclipse.wb.internal.core.model.generation.statement.flat.FlatStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.rcp.RcpToolkitDescription;
import org.eclipse.wb.internal.swt.model.layout.RowDataInfo;
import org.eclipse.wb.internal.swt.model.layout.RowLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class LayoutDataTest
extends RcpModelTest {
    private final ToolkitDescription m_toolkit = RcpToolkitDescription.INSTANCE;

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_deleteLayoutData() throws Exception {
        CompositeInfo shellInfo = this.parseComposite("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    RowLayout layout = new RowLayout();", "    shell.setLayout(layout);", "    //", "    Button button = new Button(shell, SWT.NONE);", "    RowData data = new RowData();", "    data.width = 50;", "    data.height = 40;", "    button.setLayoutData(data);", "  }", "}");
        shellInfo.refresh();
        ControlInfo button = (ControlInfo)shellInfo.getChildrenControls().get(0);
        Property property = button.getPropertyByTitle("LayoutData");
        property.setValue(Property.UNKNOWN_VALUE);
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    RowLayout layout = new RowLayout();", "    shell.setLayout(layout);", "    //", "    Button button = new Button(shell, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_excludeProperties() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      RowData data = new RowData(100, 100);", "      button.setLayoutData(data);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        Property layoutDataProperty = button.getPropertyByTitle("LayoutData");
        Property[] subProperties = LayoutDataTest.getSubProperties(layoutDataProperty);
        LayoutDataTest.assertNull((Object)LayoutDataTest.getPropertyByTitle(subProperties, "Constructor"));
        LayoutDataTest.assertNull((Object)LayoutDataTest.getPropertyByTitle(subProperties, "Class"));
        LayoutDataTest.assertNotNull((Object)LayoutDataTest.getPropertyByTitle(subProperties, "height"));
    }

    @Test
    public void test_codeGeneration_Block() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        RowDataInfo layoutData = RowLayoutInfo.getRowData((ControlInfo)button);
        layoutData.getPropertyByTitle("width").setValue((Object)100);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new RowData(100, SWT.DEFAULT));", "    }", "  }", "}");
        layoutData.getPropertyByTitle("exclude").setValue((Object)true);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        RowData rowData = new RowData(100, SWT.DEFAULT);", "        rowData.exclude = true;", "        button.setLayoutData(rowData);", "      }", "    }", "  }", "}");
        layoutData.getPropertyByTitle("exclude").setValue((Object)false);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new RowData(100, SWT.DEFAULT));", "    }", "  }", "}");
    }

    @Test
    public void test_codeGeneration_Flat() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        RowDataInfo layoutData = RowLayoutInfo.getRowData((ControlInfo)button);
        GenerationSettings generationSettings = shell.getDescription().getToolkit().getGenerationSettings();
        generationSettings.setStatement(FlatStatementGeneratorDescription.INSTANCE);
        try {
            layoutData.getPropertyByTitle("width").setValue((Object)100);
            this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ", "    Button button = new Button(this, SWT.NONE);", "    button.setLayoutData(new RowData(100, SWT.DEFAULT));", "  }", "}");
            layoutData.getPropertyByTitle("exclude").setValue((Object)true);
            this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ", "    Button button = new Button(this, SWT.NONE);", "    RowData rowData = new RowData(100, SWT.DEFAULT);", "    rowData.exclude = true;", "    button.setLayoutData(rowData);", "  }", "}");
            layoutData.getPropertyByTitle("exclude").setValue((Object)false);
            this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ", "    Button button = new Button(this, SWT.NONE);", "    button.setLayoutData(new RowData(100, SWT.DEFAULT));", "  }", "}");
        }
        finally {
            generationSettings.setStatement(generationSettings.getDefaultStatement());
        }
    }

    @Test
    public void test_codeGeneration_ignoreIfDelete() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        RowData rowData = new RowData(100, SWT.DEFAULT);", "        rowData.exclude = false;", "        button.setLayoutData(rowData);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        button.delete();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "  }", "}");
    }

    @Test
    public void test_nameTemplate_useDefaultName() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)LayoutDataTest.getJavaInfoByName("button");
        this.m_toolkit.getPreferences().setValue("templateLayoutDataName", "${defaultName}");
        RowLayoutInfo.getRowData((ControlInfo)button).getPropertyByTitle("exclude").setValue((Object)true);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        RowData rowData = new RowData(SWT.DEFAULT, SWT.DEFAULT);", "        rowData.exclude = true;", "        button.setLayoutData(rowData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_nameTemplate_alternativeTemplate_1() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)LayoutDataTest.getJavaInfoByName("button");
        this.m_toolkit.getPreferences().setValue("templateLayoutDataName", "${dataAcronym}${controlName-cap}");
        RowLayoutInfo.getRowData((ControlInfo)button).getPropertyByTitle("exclude").setValue((Object)true);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        RowData rdButton = new RowData(SWT.DEFAULT, SWT.DEFAULT);", "        rdButton.exclude = true;", "        button.setLayoutData(rdButton);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_nameTemplate_alternativeTemplate_2() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)LayoutDataTest.getJavaInfoByName("button");
        this.m_toolkit.getPreferences().setValue("templateLayoutDataName", "${controlName}${dataClassName}");
        RowLayoutInfo.getRowData((ControlInfo)button).getPropertyByTitle("exclude").setValue((Object)true);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        RowData buttonRowData = new RowData(SWT.DEFAULT, SWT.DEFAULT);", "        buttonRowData.exclude = true;", "        button.setLayoutData(buttonRowData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_nameTemplate_renameWithControl() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        RowData rowData = new RowData(100, SWT.DEFAULT);", "        rowData.exclude = false;", "        button.setLayoutData(rowData);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        button.getVariableSupport().setName("myButton");
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button myButton = new Button(this, SWT.NONE);", "      {", "        RowData rowData = new RowData(100, SWT.DEFAULT);", "        rowData.exclude = false;", "        myButton.setLayoutData(rowData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_deleteIfDefault() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new RowData(SWT.DEFAULT, SWT.DEFAULT));", "    }", "  }", "}");
        shell.refresh();
        ExecutionUtils.refresh((ObjectInfo)shell);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_deleteIfDefault_negativeValue() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new RowData(-1, SWT.DEFAULT));", "    }", "  }", "}");
        shell.refresh();
        ExecutionUtils.refresh((ObjectInfo)shell);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_deleteIfDefault_notLiterals() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      int width = SWT.DEFAULT;", "      button.setLayoutData(new RowData(width, SWT.DEFAULT));", "    }", "  }", "}");
        shell.refresh();
        ExecutionUtils.refresh((ObjectInfo)shell);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      int width = SWT.DEFAULT;", "      button.setLayoutData(new RowData(width, SWT.DEFAULT));", "    }", "  }", "}");
    }

    @Test
    public void test_deleteIfDefault_hasVariable() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        RowData rowData = new RowData(SWT.DEFAULT, SWT.DEFAULT);", "        button.setLayoutData(rowData);", "      }", "    }", "  }", "}");
        shell.refresh();
        ExecutionUtils.refresh((ObjectInfo)shell);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_deleteIfDefault_hasMethodInvocation() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        RowData rowData = new RowData(SWT.DEFAULT, SWT.DEFAULT);", "        rowData.hashCode();", "        button.setLayoutData(rowData);", "      }", "    }", "  }", "}");
        shell.refresh();
        ExecutionUtils.refresh((ObjectInfo)shell);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        RowData rowData = new RowData(SWT.DEFAULT, SWT.DEFAULT);", "        rowData.hashCode();", "        button.setLayoutData(rowData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_deleteIfDefault_hasFieldAssignment() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        RowData rowData = new RowData(SWT.DEFAULT, SWT.DEFAULT);", "        rowData.exclude = true;", "        button.setLayoutData(rowData);", "      }", "    }", "  }", "}");
        shell.refresh();
        ExecutionUtils.refresh((ObjectInfo)shell);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        RowData rowData = new RowData(SWT.DEFAULT, SWT.DEFAULT);", "        rowData.exclude = true;", "        button.setLayoutData(rowData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_noParentControl() throws Exception {
        CompositeInfo composite = this.parseComposite("class Test extends Shell {", "  public Test() {", "    RowData dangling = new RowData();", "  }", "}");
        LayoutDataTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {}", "  {implicit-layout: absolute} {implicit-layout} {}");
        composite.refresh();
        LayoutDataTest.assertNoErrors((JavaInfo)composite);
    }

    @Test
    public void test_noParentComposite_noLayout() throws Exception {
        CompositeInfo composite = this.parseComposite("class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayoutData(new RowData());", "  }", "}");
        LayoutDataTest.assertHierarchy("{this: org.eclipse.swt.widgets.Composite} {this} {/setLayoutData(new RowData())/}", "  {implicit-layout: absolute} {implicit-layout} {}");
        composite.refresh();
        LayoutDataTest.assertNoErrors((JavaInfo)composite);
    }

    @Test
    public void test_hasParentLayout_notCompatible() throws Exception {
        CompositeInfo composite = this.parseComposite("class Test extends Shell {", "  public Test() {", "    Button button = new Button(this, SWT.NONE);", "    button.setLayoutData(new RowData());", "  }", "}");
        LayoutDataTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/new Button(this, SWT.NONE)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {new: org.eclipse.swt.widgets.Button} {local-unique: button} {/new Button(this, SWT.NONE)/ /button.setLayoutData(new RowData())/}");
        composite.refresh();
        LayoutDataTest.assertNoErrors((JavaInfo)composite);
    }

    @Test
    public void test_hasParentLayout_notCompatible_alreadyRemoved() throws Exception {
        CompositeInfo composite = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new RowData());", "      button.setLayoutData(new GridData());", "    }", "  }", "}");
        LayoutDataTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new GridLayout())/ /new Button(this, SWT.NONE)/}", "  {new: org.eclipse.swt.layout.GridLayout} {empty} {/setLayout(new GridLayout())/}", "  {new: org.eclipse.swt.widgets.Button} {local-unique: button} {/new Button(this, SWT.NONE)/ /button.setLayoutData(new RowData())/ /button.setLayoutData(new GridData())/}", "    {new: org.eclipse.swt.layout.GridData} {empty} {/button.setLayoutData(new GridData())/}");
        composite.refresh();
        LayoutDataTest.assertNoErrors((JavaInfo)composite);
    }

    @Test
    public void test_hasParentComposite_noLayout() throws Exception {
        LayoutDataTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new RowLayout());", "  }", "}"));
        LayoutDataTest.setFileContentSrc("test/MyComposite.wbp-component.xml", LayoutDataTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='layout.has'>false</parameter>", "  </parameters>", "</component>"));
        LayoutDataTest.waitForAutoBuild();
        CompositeInfo composite = this.parseComposite("public class Test extends MyComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    Button button = new Button(this, SWT.NONE);", "    button.setLayoutData(new RowData());", "  }", "}");
        LayoutDataTest.assertHierarchy("{this: test.MyComposite} {this} {/new Button(this, SWT.NONE)/}", "  {new: org.eclipse.swt.widgets.Button} {local-unique: button} {/new Button(this, SWT.NONE)/ /button.setLayoutData(new RowData())/}");
        composite.refresh();
        LayoutDataTest.assertNoErrors((JavaInfo)composite);
    }
}

