/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.view.Display;
import android.view.WindowManager;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.acra.ACRA;
import org.acra.collector.Compatibility;

final class DisplayManagerCollector {
    static final SparseArray<String> mFlagsNames = new SparseArray();
    static final SparseArray<String> mDensities = new SparseArray();

    DisplayManagerCollector() {
    }

    public static String collectDisplays(Context ctx) {
        Display[] displays = null;
        StringBuilder result = new StringBuilder();
        if (Compatibility.getAPILevel() < 17) {
            WindowManager windowManager = (WindowManager)ctx.getSystemService("window");
            displays = new Display[]{windowManager.getDefaultDisplay()};
        } else {
            try {
                Object displayManager = ctx.getSystemService((String)ctx.getClass().getField("DISPLAY_SERVICE").get(null));
                Method getDisplays = displayManager.getClass().getMethod("getDisplays", new Class[0]);
                displays = (Display[])getDisplays.invoke(displayManager, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                ACRA.log.w(ACRA.LOG_TAG, "Error while collecting DisplayManager data: ", e);
            }
            catch (SecurityException e) {
                ACRA.log.w(ACRA.LOG_TAG, "Error while collecting DisplayManager data: ", e);
            }
            catch (IllegalAccessException e) {
                ACRA.log.w(ACRA.LOG_TAG, "Error while collecting DisplayManager data: ", e);
            }
            catch (NoSuchFieldException e) {
                ACRA.log.w(ACRA.LOG_TAG, "Error while collecting DisplayManager data: ", e);
            }
            catch (NoSuchMethodException e) {
                ACRA.log.w(ACRA.LOG_TAG, "Error while collecting DisplayManager data: ", e);
            }
            catch (InvocationTargetException e) {
                ACRA.log.w(ACRA.LOG_TAG, "Error while collecting DisplayManager data: ", e);
            }
        }
        for (Display display : displays) {
            result.append(DisplayManagerCollector.collectDisplayData(display));
        }
        return result.toString();
    }

    private static Object collectDisplayData(Display display) {
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        StringBuilder result = new StringBuilder();
        result.append(DisplayManagerCollector.collectCurrentSizeRange(display));
        result.append(DisplayManagerCollector.collectFlags(display));
        result.append(display.getDisplayId()).append(".height=").append(display.getHeight()).append('\n');
        result.append(DisplayManagerCollector.collectMetrics(display, "getMetrics"));
        result.append(DisplayManagerCollector.collectName(display));
        result.append(display.getDisplayId()).append(".orientation=").append(display.getOrientation()).append('\n');
        result.append(display.getDisplayId()).append(".pixelFormat=").append(display.getPixelFormat()).append('\n');
        result.append(DisplayManagerCollector.collectMetrics(display, "getRealMetrics"));
        result.append(DisplayManagerCollector.collectSize(display, "getRealSize"));
        result.append(DisplayManagerCollector.collectRectSize(display));
        result.append(display.getDisplayId()).append(".refreshRate=").append(display.getRefreshRate()).append('\n');
        result.append(DisplayManagerCollector.collectRotation(display));
        result.append(DisplayManagerCollector.collectSize(display, "getSize"));
        result.append(display.getDisplayId()).append(".width=").append(display.getWidth()).append('\n');
        result.append(DisplayManagerCollector.collectIsValid(display));
        return result.toString();
    }

    private static Object collectIsValid(Display display) {
        StringBuilder result = new StringBuilder();
        try {
            Method isValid = display.getClass().getMethod("isValid", new Class[0]);
            Boolean value = (Boolean)isValid.invoke((Object)display, new Object[0]);
            result.append(display.getDisplayId()).append(".isValid=").append(value).append('\n');
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return result.toString();
    }

    private static Object collectRotation(Display display) {
        StringBuilder result = new StringBuilder();
        try {
            Method getRotation = display.getClass().getMethod("getRotation", new Class[0]);
            int rotation = (Integer)getRotation.invoke((Object)display, new Object[0]);
            result.append(display.getDisplayId()).append(".rotation=");
            switch (rotation) {
                case 0: {
                    result.append("ROTATION_0");
                    break;
                }
                case 1: {
                    result.append("ROTATION_90");
                    break;
                }
                case 2: {
                    result.append("ROTATION_180");
                    break;
                }
                case 3: {
                    result.append("ROTATION_270");
                    break;
                }
                default: {
                    result.append(rotation);
                }
            }
            result.append('\n');
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return result.toString();
    }

    private static Object collectRectSize(Display display) {
        StringBuilder result = new StringBuilder();
        try {
            Method getRectSize = display.getClass().getMethod("getRectSize", Rect.class);
            Rect size = new Rect();
            getRectSize.invoke((Object)display, size);
            result.append(display.getDisplayId()).append(".rectSize=[").append(size.top).append(',').append(size.left).append(',').append(size.width()).append(',').append(size.height()).append(']').append('\n');
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return result.toString();
    }

    private static Object collectSize(Display display, String methodName) {
        StringBuilder result = new StringBuilder();
        try {
            Method getRealSize = display.getClass().getMethod(methodName, Point.class);
            Point size = new Point();
            getRealSize.invoke((Object)display, size);
            result.append(display.getDisplayId()).append('.').append(methodName).append("=[").append(size.x).append(',').append(size.y).append(']').append('\n');
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return result.toString();
    }

    private static String collectCurrentSizeRange(Display display) {
        StringBuilder result = new StringBuilder();
        try {
            Method getCurrentSizeRange = display.getClass().getMethod("getCurrentSizeRange", Point.class, Point.class);
            Point smallest = new Point();
            Point largest = new Point();
            getCurrentSizeRange.invoke((Object)display, smallest, largest);
            result.append(display.getDisplayId()).append(".currentSizeRange.smallest=[").append(smallest.x).append(',').append(smallest.y).append(']').append('\n');
            result.append(display.getDisplayId()).append(".currentSizeRange.largest=[").append(largest.x).append(',').append(largest.y).append(']').append('\n');
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return result.toString();
    }

    private static String collectFlags(Display display) {
        StringBuilder result = new StringBuilder();
        try {
            Method getFlags = display.getClass().getMethod("getFlags", new Class[0]);
            int flags = (Integer)getFlags.invoke((Object)display, new Object[0]);
            for (Field field : display.getClass().getFields()) {
                if (!field.getName().startsWith("FLAG_")) continue;
                mFlagsNames.put(field.getInt(null), (Object)field.getName());
            }
            result.append(display.getDisplayId()).append(".flags=").append(DisplayManagerCollector.activeFlags(mFlagsNames, flags)).append('\n');
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return result.toString();
    }

    private static String collectName(Display display) {
        StringBuilder result = new StringBuilder();
        try {
            Method getName = display.getClass().getMethod("getName", new Class[0]);
            String name = (String)getName.invoke((Object)display, new Object[0]);
            result.append(display.getDisplayId()).append(".name=").append(name).append('\n');
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return result.toString();
    }

    private static Object collectMetrics(Display display, String methodName) {
        StringBuilder result = new StringBuilder();
        try {
            Method getMetrics = display.getClass().getMethod(methodName, new Class[0]);
            DisplayMetrics metrics = (DisplayMetrics)getMetrics.invoke((Object)display, new Object[0]);
            for (Field field : DisplayMetrics.class.getFields()) {
                if (!field.getType().equals(Integer.class) || !field.getName().startsWith("DENSITY_") || field.getName().equals("DENSITY_DEFAULT")) continue;
                mDensities.put(field.getInt(null), (Object)field.getName());
            }
            result.append(display.getDisplayId()).append('.').append(methodName).append(".density=").append(metrics.density).append('\n');
            result.append(display.getDisplayId()).append('.').append(methodName).append(".densityDpi=").append(metrics.getClass().getField("densityDpi")).append('\n');
            result.append(display.getDisplayId()).append('.').append(methodName).append("scaledDensity=x").append(metrics.scaledDensity).append('\n');
            result.append(display.getDisplayId()).append('.').append(methodName).append(".widthPixels=").append(metrics.widthPixels).append('\n');
            result.append(display.getDisplayId()).append('.').append(methodName).append(".heightPixels=").append(metrics.heightPixels).append('\n');
            result.append(display.getDisplayId()).append('.').append(methodName).append(".xdpi=").append(metrics.xdpi).append('\n');
            result.append(display.getDisplayId()).append('.').append(methodName).append(".ydpi=").append(metrics.ydpi).append('\n');
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return result.toString();
    }

    private static String activeFlags(SparseArray<String> valueNames, int bitfield) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < valueNames.size(); ++i) {
            int maskValue = valueNames.keyAt(i);
            int value = bitfield & maskValue;
            if (value <= 0) continue;
            if (result.length() > 0) {
                result.append('+');
            }
            result.append((String)valueNames.get(value));
        }
        return result.toString();
    }
}

