/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.acra.ACRA;
import org.acra.sender.HttpSender;
import org.acra.util.FakeSocketFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public final class HttpRequest {
    private String login;
    private String password;
    private int connectionTimeOut = 3000;
    private int socketTimeOut = 3000;
    private int maxNrRetries = 3;
    private Map<String, String> headers;

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setConnectionTimeOut(int connectionTimeOut) {
        this.connectionTimeOut = connectionTimeOut;
    }

    public void setSocketTimeOut(int socketTimeOut) {
        this.socketTimeOut = socketTimeOut;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setMaxNrRetries(int maxNrRetries) {
        this.maxNrRetries = maxNrRetries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(URL url, HttpSender.Method method, String content, HttpSender.Type type) throws IOException {
        HttpClient httpClient = this.getHttpClient();
        HttpEntityEnclosingRequestBase httpRequest = this.getHttpRequest(url, method, content, type);
        ACRA.log.d(ACRA.LOG_TAG, "Sending request to " + url);
        HttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpRequest, (HttpContext)new BasicHttpContext());
            if (response != null) {
                String statusCode;
                StatusLine statusLine = response.getStatusLine();
                if (statusLine != null && !(statusCode = Integer.toString(response.getStatusLine().getStatusCode())).equals("409") && !statusCode.equals("403") && (statusCode.startsWith("4") || statusCode.startsWith("5"))) {
                    throw new IOException("Host returned error code " + statusCode);
                }
                String respContent = EntityUtils.toString((HttpEntity)response.getEntity());
            }
        }
        finally {
            if (response != null) {
                response.getEntity().consumeContent();
            }
        }
    }

    private HttpClient getHttpClient() {
        BasicHttpParams httpParams = new BasicHttpParams();
        httpParams.setParameter("http.protocol.cookie-policy", (Object)"rfc2109");
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)this.connectionTimeOut);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)this.socketTimeOut);
        HttpConnectionParams.setSocketBufferSize((HttpParams)httpParams, (int)8192);
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", (SocketFactory)new PlainSocketFactory(), 80));
        if (ACRA.getConfig().disableSSLCertValidation()) {
            registry.register(new Scheme("https", (SocketFactory)new FakeSocketFactory(), 443));
        } else {
            registry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        }
        ThreadSafeClientConnManager clientConnectionManager = new ThreadSafeClientConnManager((HttpParams)httpParams, registry);
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)clientConnectionManager, (HttpParams)httpParams);
        SocketTimeOutRetryHandler retryHandler = new SocketTimeOutRetryHandler((HttpParams)httpParams, this.maxNrRetries);
        httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)retryHandler);
        return httpClient;
    }

    private UsernamePasswordCredentials getCredentials() {
        if (this.login != null || this.password != null) {
            return new UsernamePasswordCredentials(this.login, this.password);
        }
        return null;
    }

    private HttpEntityEnclosingRequestBase getHttpRequest(URL url, HttpSender.Method method, String content, HttpSender.Type type) throws UnsupportedEncodingException, UnsupportedOperationException {
        HttpPost httpRequest;
        switch (method) {
            case POST: {
                httpRequest = new HttpPost(url.toString());
                break;
            }
            case PUT: {
                httpRequest = new HttpPut(url.toString());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown method: " + method.name());
            }
        }
        UsernamePasswordCredentials creds = this.getCredentials();
        if (creds != null) {
            httpRequest.addHeader(BasicScheme.authenticate((Credentials)creds, (String)"UTF-8", (boolean)false));
        }
        httpRequest.setHeader("User-Agent", "Android");
        httpRequest.setHeader("Accept", "text/html,application/xml,application/json,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5");
        httpRequest.setHeader("Content-Type", type.getContentType());
        if (this.headers != null) {
            for (String header : this.headers.keySet()) {
                String value = this.headers.get(header);
                httpRequest.setHeader(header, value);
            }
        }
        httpRequest.setEntity((HttpEntity)new StringEntity(content, "UTF-8"));
        return httpRequest;
    }

    public static String getParamsAsFormString(Map<?, ?> parameters) throws UnsupportedEncodingException {
        StringBuilder dataBfr = new StringBuilder();
        for (Object key : parameters.keySet()) {
            Object preliminaryValue;
            if (dataBfr.length() != 0) {
                dataBfr.append('&');
            }
            String value = (preliminaryValue = parameters.get(key)) == null ? "" : preliminaryValue;
            dataBfr.append(URLEncoder.encode(key.toString(), "UTF-8"));
            dataBfr.append('=');
            dataBfr.append(URLEncoder.encode(value.toString(), "UTF-8"));
        }
        return dataBfr.toString();
    }

    private static class SocketTimeOutRetryHandler
    implements HttpRequestRetryHandler {
        private final HttpParams httpParams;
        private final int maxNrRetries;

        private SocketTimeOutRetryHandler(HttpParams httpParams, int maxNrRetries) {
            this.httpParams = httpParams;
            this.maxNrRetries = maxNrRetries;
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            if (exception instanceof SocketTimeoutException) {
                if (executionCount <= this.maxNrRetries) {
                    if (this.httpParams != null) {
                        int newSocketTimeOut = HttpConnectionParams.getSoTimeout((HttpParams)this.httpParams) * 2;
                        HttpConnectionParams.setSoTimeout((HttpParams)this.httpParams, (int)newSocketTimeOut);
                        ACRA.log.d(ACRA.LOG_TAG, "SocketTimeOut - increasing time out to " + newSocketTimeOut + " millis and trying again");
                    } else {
                        ACRA.log.d(ACRA.LOG_TAG, "SocketTimeOut - no HttpParams, cannot increase time out. Trying again with current settings");
                    }
                    return true;
                }
                ACRA.log.d(ACRA.LOG_TAG, "SocketTimeOut but exceeded max number of retries : " + this.maxNrRetries);
            }
            return false;
        }
    }
}

