/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.acra.ACRA;
import org.acra.collector.Compatibility;
import org.acra.util.BoundedLinkedList;

class LogCatCollector {
    private static final int DEFAULT_TAIL_COUNT = 100;

    LogCatCollector() {
    }

    public static String collectLogCat(String bufferName) {
        int tailCount;
        ArrayList<String> logcatArgumentsList;
        int tailIndex;
        int myPid = android.os.Process.myPid();
        String myPidStr = null;
        if (ACRA.getConfig().logcatFilterByPid() && myPid > 0) {
            myPidStr = Integer.toString(myPid) + "):";
        }
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add("logcat");
        if (bufferName != null) {
            commandLine.add("-b");
            commandLine.add(bufferName);
        }
        if ((tailIndex = (logcatArgumentsList = new ArrayList<String>(Arrays.asList(ACRA.getConfig().logcatArguments()))).indexOf("-t")) > -1 && tailIndex < logcatArgumentsList.size()) {
            tailCount = Integer.parseInt((String)logcatArgumentsList.get(tailIndex + 1));
            if (Compatibility.getAPILevel() < 8) {
                logcatArgumentsList.remove(tailIndex + 1);
                logcatArgumentsList.remove(tailIndex);
                logcatArgumentsList.add("-d");
            }
        } else {
            tailCount = -1;
        }
        BoundedLinkedList<String> logcatBuf = new BoundedLinkedList<String>(tailCount > 0 ? tailCount : 100);
        commandLine.addAll(logcatArgumentsList);
        try {
            String line;
            final Process process = Runtime.getRuntime().exec(commandLine.toArray(new String[commandLine.size()]));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 8192);
            Log.d((String)ACRA.LOG_TAG, (String)"Retrieving logcat output...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        InputStream stderr = process.getErrorStream();
                        byte[] dummy = new byte[8192];
                        while (stderr.read(dummy) >= 0) {
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }).start();
            while ((line = bufferedReader.readLine()) != null) {
                if (myPidStr != null && !line.contains(myPidStr)) continue;
                ((LinkedList)logcatBuf).add(line + "\n");
            }
        }
        catch (IOException e) {
            Log.e((String)ACRA.LOG_TAG, (String)"LogCatCollector.collectLogCat could not retrieve data.", (Throwable)e);
        }
        return ((AbstractCollection)logcatBuf).toString();
    }
}

