/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import net.fortuna.ical4j.model.AbstractContentFactory;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Categories;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Comment;
import net.fortuna.ical4j.model.property.Completed;
import net.fortuna.ical4j.model.property.Contact;
import net.fortuna.ical4j.model.property.Country;
import net.fortuna.ical4j.model.property.Created;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Due;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.ExDate;
import net.fortuna.ical4j.model.property.ExRule;
import net.fortuna.ical4j.model.property.ExtendedAddress;
import net.fortuna.ical4j.model.property.FreeBusy;
import net.fortuna.ical4j.model.property.Geo;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.Locality;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.LocationType;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.Name;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.PercentComplete;
import net.fortuna.ical4j.model.property.Postalcode;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.RDate;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.RecurrenceId;
import net.fortuna.ical4j.model.property.Region;
import net.fortuna.ical4j.model.property.RelatedTo;
import net.fortuna.ical4j.model.property.Repeat;
import net.fortuna.ical4j.model.property.RequestStatus;
import net.fortuna.ical4j.model.property.Resources;
import net.fortuna.ical4j.model.property.Sequence;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.StreetAddress;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Tel;
import net.fortuna.ical4j.model.property.Transp;
import net.fortuna.ical4j.model.property.Trigger;
import net.fortuna.ical4j.model.property.TzId;
import net.fortuna.ical4j.model.property.TzName;
import net.fortuna.ical4j.model.property.TzOffsetFrom;
import net.fortuna.ical4j.model.property.TzOffsetTo;
import net.fortuna.ical4j.model.property.TzUrl;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Url;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.model.property.XProperty;

public class PropertyFactoryImpl
extends AbstractContentFactory
implements PropertyFactory {
    private static final long serialVersionUID = -7174232004486979641L;
    private static PropertyFactoryImpl instance = new PropertyFactoryImpl();

    protected PropertyFactoryImpl() {
        this.registerDefaultFactory("ACTION", this.createActionFactory());
        this.registerDefaultFactory("ATTACH", this.createAttachFactory());
        this.registerDefaultFactory("ATTENDEE", this.createAttendeeFactory());
        this.registerDefaultFactory("CALSCALE", this.createCalScaleFactory());
        this.registerDefaultFactory("CATEGORIES", this.createCategoriesFactory());
        this.registerDefaultFactory("CLASS", this.createClazzFactory());
        this.registerDefaultFactory("COMMENT", this.createCommentFactory());
        this.registerDefaultFactory("COMPLETED", this.createCompletedFactory());
        this.registerDefaultFactory("CONTACT", this.createContactFactory());
        this.registerDefaultFactory("COUNTRY", this.createCountryFactory());
        this.registerDefaultFactory("CREATED", this.createCreatedFactory());
        this.registerDefaultFactory("DESCRIPTION", this.createDescriptionFactory());
        this.registerDefaultFactory("DTEND", this.createDtEndFactory());
        this.registerDefaultFactory("DTSTAMP", this.createDtStampFactory());
        this.registerDefaultFactory("DTSTART", this.createDtStartFactory());
        this.registerDefaultFactory("DUE", this.createDueFactory());
        this.registerDefaultFactory("DURATION", this.createDurationFactory());
        this.registerDefaultFactory("EXDATE", this.createExDateFactory());
        this.registerDefaultFactory("EXRULE", this.createExRuleFactory());
        this.registerDefaultFactory("EXTENDED-ADDRESS", this.createExtendedAddressFactory());
        this.registerDefaultFactory("FREEBUSY", this.createFreeBusyFactory());
        this.registerDefaultFactory("GEO", this.createGeoFactory());
        this.registerDefaultFactory("LAST-MODIFIED", this.createLastModifiedFactory());
        this.registerDefaultFactory("LOCALITY", this.createLocalityFactory());
        this.registerDefaultFactory("LOCATION", this.createLocationFactory());
        this.registerDefaultFactory("LOCATION-TYPE", this.createLocationTypeFactory());
        this.registerDefaultFactory("METHOD", this.createMethodFactory());
        this.registerDefaultFactory("NAME", this.createNameFactory());
        this.registerDefaultFactory("ORGANIZER", this.createOrganizerFactory());
        this.registerDefaultFactory("PERCENT-COMPLETE", this.createPercentCompleteFactory());
        this.registerDefaultFactory("POSTAL-CODE", this.createPostalcodeFactory());
        this.registerDefaultFactory("PRIORITY", this.createPriorityFactory());
        this.registerDefaultFactory("PRODID", this.createProdIdFactory());
        this.registerDefaultFactory("RDATE", this.createRDateFactory());
        this.registerDefaultFactory("RECURRENCE-ID", this.createRecurrenceIdFactory());
        this.registerDefaultFactory("REGION", this.createRegionFactory());
        this.registerDefaultFactory("RELATED-TO", this.createRelatedToFactory());
        this.registerDefaultFactory("REPEAT", this.createRepeatFactory());
        this.registerDefaultFactory("REQUEST-STATUS", this.createRequestStatusFactory());
        this.registerDefaultFactory("RESOURCES", this.createResourcesFactory());
        this.registerDefaultFactory("RRULE", this.createRRuleFactory());
        this.registerDefaultFactory("SEQUENCE", this.createSequenceFactory());
        this.registerDefaultFactory("STATUS", this.createStatusFactory());
        this.registerDefaultFactory("STREET-ADDRESS", this.createStreetAddressFactory());
        this.registerDefaultFactory("SUMMARY", this.createSummaryFactory());
        this.registerDefaultFactory("TEL", this.createTelFactory());
        this.registerDefaultFactory("TRANSP", this.createTranspFactory());
        this.registerDefaultFactory("TRIGGER", this.createTriggerFactory());
        this.registerDefaultFactory("TZID", this.createTzIdFactory());
        this.registerDefaultFactory("TZNAME", this.createTzNameFactory());
        this.registerDefaultFactory("TZOFFSETFROM", this.createTzOffsetFromFactory());
        this.registerDefaultFactory("TZOFFSETTO", this.createTzOffsetToFactory());
        this.registerDefaultFactory("TZURL", this.createTzUrlFactory());
        this.registerDefaultFactory("UID", this.createUidFactory());
        this.registerDefaultFactory("URL", this.createUrlFactory());
        this.registerDefaultFactory("VERSION", this.createVersionFactory());
    }

    private PropertyFactory createActionFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Action(parameters, value);
            }

            public Property createProperty(String name) {
                return new Action();
            }
        };
    }

    private PropertyFactory createAttachFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Attach(parameters, value);
            }

            public Property createProperty(String name) {
                return new Attach();
            }
        };
    }

    private PropertyFactory createAttendeeFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Attendee(parameters, value);
            }

            public Property createProperty(String name) {
                return new Attendee();
            }
        };
    }

    private PropertyFactory createCalScaleFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new CalScale(parameters, value);
            }

            public Property createProperty(String name) {
                return new CalScale();
            }
        };
    }

    private PropertyFactory createCategoriesFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Categories(parameters, value);
            }

            public Property createProperty(String name) {
                return new Categories();
            }
        };
    }

    private PropertyFactory createClazzFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Clazz(parameters, value);
            }

            public Property createProperty(String name) {
                return new Clazz();
            }
        };
    }

    private PropertyFactory createCommentFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Comment(parameters, value);
            }

            public Property createProperty(String name) {
                return new Comment();
            }
        };
    }

    private PropertyFactory createCompletedFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Completed(parameters, value);
            }

            public Property createProperty(String name) {
                return new Completed();
            }
        };
    }

    private PropertyFactory createContactFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Contact(parameters, value);
            }

            public Property createProperty(String name) {
                return new Contact();
            }
        };
    }

    private PropertyFactory createCountryFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Country(parameters, value);
            }

            public Property createProperty(String name) {
                return new Country();
            }
        };
    }

    private PropertyFactory createCreatedFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Created(parameters, value);
            }

            public Property createProperty(String name) {
                return new Created();
            }
        };
    }

    private PropertyFactory createDescriptionFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Description(parameters, value);
            }

            public Property createProperty(String name) {
                return new Description();
            }
        };
    }

    private PropertyFactory createDtEndFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new DtEnd(parameters, value);
            }

            public Property createProperty(String name) {
                return new DtEnd();
            }
        };
    }

    private PropertyFactory createDtStampFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new DtStamp(parameters, value);
            }

            public Property createProperty(String name) {
                return new DtStamp();
            }
        };
    }

    private PropertyFactory createDtStartFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new DtStart(parameters, value);
            }

            public Property createProperty(String name) {
                return new DtStart();
            }
        };
    }

    private PropertyFactory createDueFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Due(parameters, value);
            }

            public Property createProperty(String name) {
                return new Due();
            }
        };
    }

    private PropertyFactory createDurationFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Duration(parameters, value);
            }

            public Property createProperty(String name) {
                return new Duration();
            }
        };
    }

    private PropertyFactory createExDateFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new ExDate(parameters, value);
            }

            public Property createProperty(String name) {
                return new ExDate();
            }
        };
    }

    private PropertyFactory createExRuleFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new ExRule(parameters, value);
            }

            public Property createProperty(String name) {
                return new ExRule();
            }
        };
    }

    private PropertyFactory createExtendedAddressFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new ExtendedAddress(parameters, value);
            }

            public Property createProperty(String name) {
                return new ExtendedAddress();
            }
        };
    }

    private PropertyFactory createFreeBusyFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new FreeBusy(parameters, value);
            }

            public Property createProperty(String name) {
                return new FreeBusy();
            }
        };
    }

    private PropertyFactory createGeoFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Geo(parameters, value);
            }

            public Property createProperty(String name) {
                return new Geo();
            }
        };
    }

    private PropertyFactory createLastModifiedFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new LastModified(parameters, value);
            }

            public Property createProperty(String name) {
                return new LastModified();
            }
        };
    }

    private PropertyFactory createLocalityFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Locality(parameters, value);
            }

            public Property createProperty(String name) {
                return new Locality();
            }
        };
    }

    private PropertyFactory createLocationFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Location(parameters, value);
            }

            public Property createProperty(String name) {
                return new Location();
            }
        };
    }

    private PropertyFactory createLocationTypeFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new LocationType(parameters, value);
            }

            public Property createProperty(String name) {
                return new LocationType();
            }
        };
    }

    private PropertyFactory createMethodFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Method(parameters, value);
            }

            public Property createProperty(String name) {
                return new Method();
            }
        };
    }

    private PropertyFactory createNameFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Name(parameters, value);
            }

            public Property createProperty(String name) {
                return new Name();
            }
        };
    }

    private PropertyFactory createOrganizerFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Organizer(parameters, value);
            }

            public Property createProperty(String name) {
                return new Organizer();
            }
        };
    }

    private PropertyFactory createPercentCompleteFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new PercentComplete(parameters, value);
            }

            public Property createProperty(String name) {
                return new PercentComplete();
            }
        };
    }

    private PropertyFactory createPostalcodeFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Postalcode(parameters, value);
            }

            public Property createProperty(String name) {
                return new Postalcode();
            }
        };
    }

    private PropertyFactory createPriorityFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Priority(parameters, value);
            }

            public Property createProperty(String name) {
                return new Priority();
            }
        };
    }

    private PropertyFactory createProdIdFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new ProdId(parameters, value);
            }

            public Property createProperty(String name) {
                return new ProdId();
            }
        };
    }

    private PropertyFactory createRDateFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new RDate(parameters, value);
            }

            public Property createProperty(String name) {
                return new RDate();
            }
        };
    }

    private PropertyFactory createRecurrenceIdFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new RecurrenceId(parameters, value);
            }

            public Property createProperty(String name) {
                return new RecurrenceId();
            }
        };
    }

    private PropertyFactory createRegionFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Region(parameters, value);
            }

            public Property createProperty(String name) {
                return new Region();
            }
        };
    }

    private PropertyFactory createRelatedToFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new RelatedTo(parameters, value);
            }

            public Property createProperty(String name) {
                return new RelatedTo();
            }
        };
    }

    private PropertyFactory createRepeatFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Repeat(parameters, value);
            }

            public Property createProperty(String name) {
                return new Repeat();
            }
        };
    }

    private PropertyFactory createRequestStatusFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new RequestStatus(parameters, value);
            }

            public Property createProperty(String name) {
                return new RequestStatus();
            }
        };
    }

    private PropertyFactory createResourcesFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Resources(parameters, value);
            }

            public Property createProperty(String name) {
                return new Resources();
            }
        };
    }

    private PropertyFactory createRRuleFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new RRule(parameters, value);
            }

            public Property createProperty(String name) {
                return new RRule();
            }
        };
    }

    private PropertyFactory createSequenceFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Sequence(parameters, value);
            }

            public Property createProperty(String name) {
                return new Sequence();
            }
        };
    }

    private PropertyFactory createStatusFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Status(parameters, value);
            }

            public Property createProperty(String name) {
                return new Status();
            }
        };
    }

    private PropertyFactory createStreetAddressFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new StreetAddress(parameters, value);
            }

            public Property createProperty(String name) {
                return new StreetAddress();
            }
        };
    }

    private PropertyFactory createSummaryFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Summary(parameters, value);
            }

            public Property createProperty(String name) {
                return new Summary();
            }
        };
    }

    private PropertyFactory createTelFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Tel(parameters, value);
            }

            public Property createProperty(String name) {
                return new Tel();
            }
        };
    }

    private PropertyFactory createTranspFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Transp(parameters, value);
            }

            public Property createProperty(String name) {
                return new Transp();
            }
        };
    }

    private PropertyFactory createTriggerFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Trigger(parameters, value);
            }

            public Property createProperty(String name) {
                return new Trigger();
            }
        };
    }

    private PropertyFactory createTzIdFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new TzId(parameters, value);
            }

            public Property createProperty(String name) {
                return new TzId();
            }
        };
    }

    private PropertyFactory createTzNameFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new TzName(parameters, value);
            }

            public Property createProperty(String name) {
                return new TzName();
            }
        };
    }

    private PropertyFactory createTzOffsetFromFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new TzOffsetFrom(parameters, value);
            }

            public Property createProperty(String name) {
                return new TzOffsetFrom();
            }
        };
    }

    private PropertyFactory createTzOffsetToFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new TzOffsetTo(parameters, value);
            }

            public Property createProperty(String name) {
                return new TzOffsetTo();
            }
        };
    }

    private PropertyFactory createTzUrlFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new TzUrl(parameters, value);
            }

            public Property createProperty(String name) {
                return new TzUrl();
            }
        };
    }

    private PropertyFactory createUidFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Uid(parameters, value);
            }

            public Property createProperty(String name) {
                return new Uid();
            }
        };
    }

    private PropertyFactory createUrlFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Url(parameters, value);
            }

            public Property createProperty(String name) {
                return new Url();
            }
        };
    }

    private PropertyFactory createVersionFactory() {
        return new PropertyFactory(){

            public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
                return new Version(parameters, value);
            }

            public Property createProperty(String name) {
                return new Version();
            }
        };
    }

    public static PropertyFactoryImpl getInstance() {
        return instance;
    }

    public Property createProperty(String name) {
        PropertyFactory factory = (PropertyFactory)this.getFactory(name);
        if (factory != null) {
            return factory.createProperty(name);
        }
        if (this.isExperimentalName(name)) {
            return new XProperty(name);
        }
        if (this.allowIllegalNames()) {
            return new XProperty(name);
        }
        throw new IllegalArgumentException("Illegal property [" + name + "]");
    }

    public Property createProperty(String name, ParameterList parameters, String value) throws IOException, URISyntaxException, ParseException {
        PropertyFactory factory = (PropertyFactory)this.getFactory(name);
        if (factory != null) {
            return factory.createProperty(name, parameters, value);
        }
        if (this.isExperimentalName(name)) {
            return new XProperty(name, parameters, value);
        }
        if (this.allowIllegalNames()) {
            return new XProperty(name, parameters, value);
        }
        throw new IllegalArgumentException("Illegal property [" + name + "]");
    }

    private boolean isExperimentalName(String name) {
        return name.startsWith("X-") && name.length() > "X-".length();
    }
}

