/*
 *  Copyright (C) 2018 Team Gateship-One
 *  (Hendrik Borghorst & Frederik Luetkes)
 *
 *  The AUTHORS.md file contains a detailed contributors list:
 *  <https://gitlab.com/matthias-weiss/musicala/blob/master/AUTHORS.md>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package at.weiss.matthias.musicala.application.fragments;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.support.v4.app.Fragment;
import android.support.v7.preference.Preference;
import android.support.v7.preference.PreferenceFragmentCompat;

import at.weiss.matthias.musicala.R;
import at.weiss.matthias.musicala.application.callbacks.FABFragmentCallback;
import at.weiss.matthias.musicala.application.views.VolumeStepPreferenceDialog;

public class SettingsFragment extends PreferenceFragmentCompat
        implements SharedPreferences.OnSharedPreferenceChangeListener {
    public static final String TAG = SettingsFragment.class.getSimpleName();

    private FABFragmentCallback mFABCallback = null;
    private OnSettingsFragmentRequestedCallback mSettingsFragmentCallback;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        Preference openArtwork = findPreference(getString(R.string.pref_artwork_settings_key));
        openArtwork.setOnPreferenceClickListener(preference -> {
            mSettingsFragmentCallback.openSettingsFragment("ArtworkSettingsFragment", new ArtworkSettingsFragment());
            return true;
        });

        Preference openProfiles = findPreference(getString(R.string.pref_profiles_settings_key));
        openProfiles.setOnPreferenceClickListener(preference -> {
            mSettingsFragmentCallback.openSettingsFragment("ProfilesSettingsFragment", new ProfilesFragment());
            return true;
        });

        Preference openAbout = findPreference(getString(R.string.pref_about_settings_key));
        openAbout.setOnPreferenceClickListener(preference -> {
            mSettingsFragmentCallback.openSettingsFragment("AboutSettingsFragment", new AboutFragment());
            return true;
        });


        Preference openVolumeStepDialog = findPreference(getString(R.string.pref_volume_steps_dialog_key));
        openVolumeStepDialog.setOnPreferenceClickListener(preference -> {
            VolumeStepPreferenceDialog dialog = new VolumeStepPreferenceDialog();
            dialog.show(getFragmentManager(), "Volume steps");
            return true;
        });
    }

    /**
     * Called when the fragment is first attached to its context.
     */
    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

        // This makes sure that the container activity has implemented
        // the callback interface. If not, it throws an exception
        try {
            mFABCallback = (FABFragmentCallback) context;
        } catch (ClassCastException e) {
            mFABCallback = null;
        }

        // This makes sure that the container activity has implemented
        // the callback interface. If not, it throws an exception
        try {
            mSettingsFragmentCallback = (OnSettingsFragmentRequestedCallback) context;
        } catch (ClassCastException e) {
            throw new ClassCastException(context.toString() + " must implement OnArtworkSettingsRequestedCallback");
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        getPreferenceScreen().getSharedPreferences()
                .registerOnSharedPreferenceChangeListener(this);

        if (null != mFABCallback) {
            mFABCallback.setupFAB(false, null);
            mFABCallback.setupToolbar(getString(R.string.menu_settings), false, true, false);
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        getPreferenceScreen().getSharedPreferences()
                .unregisterOnSharedPreferenceChangeListener(this);
    }

    @Override
    public void onCreatePreferences(Bundle bundle, String s) {
        // Load the preferences from an XML resource
        addPreferencesFromResource(R.xml.main_settings);
        PreferenceManager.setDefaultValues(getActivity(), R.xml.main_settings, false);
    }

    @Override
    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        if (key.equals(getString(R.string.pref_theme_key))) {
            Intent intent = getActivity().getIntent();
            getActivity().finish();
            startActivity(intent);
        }
    }

    public interface OnSettingsFragmentRequestedCallback {
        void openSettingsFragment(String title, Fragment fragment);
    }
}
