/*
 *  Copyright (C) 2018 Team Gateship-One
 *  (Hendrik Borghorst & Frederik Luetkes)
 *
 *  The AUTHORS.md file contains a detailed contributors list:
 *  <https://gitlab.com/matthias-weiss/musicala/blob/master/AUTHORS.md>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package at.weiss.matthias.musicala.mpdservice.handlers.responsehandler;


import android.os.Bundle;
import android.os.Message;

import java.util.List;

import at.weiss.matthias.musicala.mpdservice.mpdprotocol.mpdobjects.MPDAlbum;

/**
 * Response class for album lists.
 */
public abstract class MPDResponseAlbumList extends MPDResponseHandler {

    public static final String EXTRA_LIBRARY_LIST_POSITION = "libraryListPosition";

    public MPDResponseAlbumList() {
    }

    /**
     * Handle function for the album list. This only calls the abstract method
     * which needs to get implemented by the user of this class.
     * @param msg Message object containing a list of MPDAlbum items.
     */
    @Override
    public void handleMessage(Message msg) {
        super.handleMessage(msg);

        /* Call album response handler */
        List<MPDAlbum> albumList = (List<MPDAlbum>) msg.obj;
        int position = msg.getData().getInt(EXTRA_LIBRARY_LIST_POSITION);

        handleAlbums(albumList, position);
    }

    /**
     * Sends a message to the receiving end of the receiver
     * @param albumList List to send
     */
    public void sendAlbums(List<MPDAlbum> albumList, int position) {
        Message message = obtainMessage();
        message.obj = albumList;

        Bundle data = new Bundle();
        data.putInt(EXTRA_LIBRARY_LIST_POSITION, position);
        message.setData(data);

        sendMessage(message);
    }

    /**
     * Abstract method to be implemented by the user of the MPD implementation.
     * This should be a callback for the UI thread and run in the UI thread.
     * This can be used for updating lists of adapters and views.
     * @param albumList List of MPDAlbum objects containing a list of mpds album response.
     */
    abstract public void handleAlbums(List<MPDAlbum> albumList, int position);
}
