package atm.starun.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.viewport.StretchViewport;
import com.badlogic.gdx.utils.viewport.Viewport;

public class CreditsScreen implements Screen {

	final Starun game;
	OrthographicCamera camera;
	Viewport viewport;
	Stage stage;
	Button backToMenuButton;

	public CreditsScreen(final Starun game) {
		this.game = game;

		camera = new OrthographicCamera();
		viewport = new StretchViewport(Starun.SCREEN_WIDTH, Starun.SCREEN_HEIGHT, camera);
		stage = new Stage(viewport, game.batch);
		backToMenuButton = new TextButton("Main menu", Starun.skin);

		backToMenuButton.addListener(new ChangeListener() {

			@Override
			public void changed(ChangeEvent event, Actor actor) {
				Starun.mainMenuSound.play();
				game.setScreen(new MainMenuScreen(game));
				dispose();
			}
		});

		Table table = new Table();
		table.center();
		table.setFillParent(true);

		Label creditsLabel = new Label("Developed by Antonio Torres Moríñigo."
				+ "\nStar and asteroid design by Paula Alba." + "\nLicensed under GPLv3."
				+ "\nPowered by libGDX framework (Apache 2.0)." + "\n\nAssets:" + "\nBackground by Westbeam under CC-0."
				+ "\nSound effects by Lokif under CC-0." + "\nButtons by @CamTatz under CC-0."
				+ "\nFont: Architect's Daughter under SIL-OFL." + "\nGame music by Gichco under CC-0."
				+ "\nMenu music by bart under GPLv3." + "\nOpenGameArt.org", Starun.creditFontStyle);
		Label thankYouLabel = new Label("Thank you for playing!", Starun.recordFontStyle);
		creditsLabel.setAlignment(0);
		table.add(creditsLabel);
		table.row();
		table.add(thankYouLabel);
		table.row();
		table.add(backToMenuButton).padTop(30f);

		stage.addActor(table);

		Gdx.input.setInputProcessor(stage);
	}

	@Override
	public void show() {
	}

	@Override
	public void render(float delta) {
		Gdx.gl.glClearColor(0, 0, 0, 1);
		Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT);

		camera.update();
		game.batch.begin();
		Starun.backgroundSprite.draw(game.batch);
		game.batch.end();
		stage.draw();
		Starun.backgroundSprite.scroll(0, Gdx.graphics.getDeltaTime() / -5f);
	}

	@Override
	public void resize(int width, int height) {
	}

	@Override
	public void pause() {
	}

	@Override
	public void resume() {
	}

	@Override
	public void hide() {
	}

	@Override
	public void dispose() {
		stage.dispose();
	}

}
