package atm.starun.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.viewport.StretchViewport;
import com.badlogic.gdx.utils.viewport.Viewport;

public class GameOverScreen implements Screen {
	private Viewport viewport;
	private Stage stage;
	private TextButton playAgainButton, mainMenuButton;

	final Starun game;

	public GameOverScreen(final Starun game) {
		this.game = game;
		viewport = new StretchViewport(Starun.SCREEN_WIDTH, Starun.SCREEN_HEIGHT, new OrthographicCamera());
		stage = new Stage(viewport, game.batch);

		playAgainButton = new TextButton("Retry", Starun.skin);
		mainMenuButton = new TextButton("Main menu", Starun.skin);

		mainMenuButton.addListener(new ChangeListener() {

			@Override
			public void changed(ChangeEvent event, Actor actor) {
				Starun.menuMusic.play();
				Starun.mainMenuSound.play();
				game.setScreen(new MainMenuScreen(game));
				dispose();
			}
		});

		playAgainButton.addListener(new ChangeListener() {

			@Override
			public void changed(ChangeEvent event, Actor actor) {
				Starun.menuMusic.stop();
				Starun.gameMusic.play();
				Starun.playAgainSound.play();
				game.setScreen(new GameScreen(game));
				dispose();
			}
		});

		Table table = new Table();
		table.center();
		table.setFillParent(true);

		Label gameOverLabel = new Label("GAME OVER", Starun.titleFontStyle);
		Label scoreLabel = new Label("Score: " + GameScreen.score, Starun.textFontStyle);
		Label highScoreLabel = new Label("High score: " + Starun.getHighScore(), Starun.textFontStyle);
		Label newRecordLabel = new Label("New record!", Starun.recordFontStyle);

		table.add(gameOverLabel).expandX();
		table.row();
		table.add(playAgainButton).padTop(10f);
		table.row();
		table.add(mainMenuButton).padTop(20f);
		table.row();
		table.add(scoreLabel).padTop(30f);
		table.row();
		table.add(highScoreLabel);
		if (GameScreen.score == Starun.getHighScore() && Starun.getHighScore() != 0) {
			table.row();
			table.add(newRecordLabel).padTop(35f);
			Starun.newRecordSound.play();
		}

		stage.addActor(table);
		Gdx.input.setInputProcessor(stage);

	}

	@Override
	public void show() {
	}

	@Override
	public void render(float delta) {

		Gdx.gl.glClearColor(0, 0, 0, 1);
		Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT);
		game.batch.begin();
		Starun.backgroundSprite.draw(game.batch);
		game.batch.end();
		stage.draw();
		Starun.backgroundSprite.scroll(0, Gdx.graphics.getDeltaTime() / -5f);
	}

	@Override
	public void resize(int width, int height) {
	}

	@Override
	public void pause() {
	}

	@Override
	public void resume() {
	}

	@Override
	public void hide() {
	}

	@Override
	public void dispose() {
		stage.dispose();
	}

}
