package atm.starun.game;

import java.util.Iterator;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.input.GestureDetector;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.TimeUtils;

public class GameScreen implements Screen {
	final Starun game;

	private Texture asteroidImage, starImage;
	public static Sprite starSprite;
	private SpriteBatch batch;
	public static OrthographicCamera camera;
	private Array<Rectangle> asteroids;
	private long lastAsteroidTime, startTime, elapsedSecondsSinceStart;
	public static Vector3 touchPos;
	private Vector2 backgroundVel;
	public static int score;
	private int rotDegree;
	private int collisions;
	public Rectangle starRect;
	public static float acceleration, asteroidVel;
	public static Rectangle touchArea;
	private int[] asteroidPos = { 5, 96, 192, 288, 379 };
	Iterator<Rectangle> iter;

	public GameScreen(final Starun game) {
		this.game = game;

		camera = new OrthographicCamera();
		camera.setToOrtho(false, Starun.SCREEN_WIDTH, Starun.SCREEN_HEIGHT);
		batch = new SpriteBatch();

		touchPos = new Vector3();
		backgroundVel = new Vector2(0, 0);
		score = 0;
		rotDegree = 0;
		acceleration = 0;
		asteroidVel = 0;
		collisions = 0;
		startTime = TimeUtils.millis();

		Gdx.input.setInputProcessor(new GestureDetector(new ProjectGestureListener()));

		// Initialize textures
		asteroidImage = new Texture(Gdx.files.internal("asteroidito.png"));
		starImage = new Texture(Gdx.files.internal("estrellitazul.png"));

		// Initialize sprites
		starSprite = new Sprite(starImage);
		starSprite.setPosition(480 / 2, 100);

		// Initialize rectangles
		starRect = new Rectangle(starSprite.getX(), starSprite.getY(), starSprite.getWidth() - 25,
				starSprite.getHeight() - 25);
		asteroids = new Array<Rectangle>();
		touchArea = new Rectangle(starSprite.getX(), starSprite.getY() - 100, starSprite.getWidth() + 50,
				starSprite.getHeight() + Starun.SCREEN_HEIGHT);
	}

	private void spawnAsteroid() {
		Rectangle asteroid = new Rectangle();
		asteroid.x = asteroidPos[MathUtils.random(4)];
		asteroid.y = 800;
		asteroid.width = 50;
		asteroid.height = 50;
		asteroids.add(asteroid);
		lastAsteroidTime = TimeUtils.nanoTime();
	}

	@Override
	public void show() {
	}

	@Override
	public void render(float delta) {
		// Update camera and clear screen buffer
		camera.update();
		Gdx.gl.glClearColor(0, 0, 0, 0);
		Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT);
		elapsedSecondsSinceStart = (TimeUtils.timeSinceMillis(startTime) / 1000);
		// Handle star rotation
		starSprite.setRotation(rotDegree);
		rotDegree += 3;
		updateRectangle();
		// Initialize batch
		batch.setProjectionMatrix(camera.combined);
		batch.begin();
		drawBackground();
		Starun.titleFont.draw(batch, "" + score, 390, 795);
		Starun.titleFont.draw(batch, 3 - collisions + "/3", 5, 795);
		starSprite.draw(batch);
		for (Rectangle asteroid : asteroids) {
			batch.draw(asteroidImage, asteroid.x, asteroid.y);
		}
		// End batch
		batch.end();
		// Handles key input (see ProjectGestureListener class)
		if (Gdx.input.isKeyPressed(Input.Keys.LEFT)) {
			starSprite.setX(starSprite.getX() - 500 * Gdx.graphics.getDeltaTime());
		}
		if (Gdx.input.isKeyPressed(Input.Keys.RIGHT)) {
			starSprite.setX(starSprite.getX() + 500 * Gdx.graphics.getDeltaTime());
		}
		if (TimeUtils.nanoTime() - lastAsteroidTime > 450000000 && elapsedSecondsSinceStart > 2) {
			spawnAsteroid();
		}
		if (starSprite.getX() < 0) {
			starSprite.setX(0);
		}
		if (starSprite.getX() > 480 - 90) {
			starSprite.setX(480 - 90);
		}
		// Iteration of asteroid spawning and acceleration
		Iterator<Rectangle> iter = asteroids.iterator();
		while (iter.hasNext()) {
			Rectangle asteroid = iter.next();
			asteroidVel = (600 * Gdx.graphics.getDeltaTime()) + acceleration;
			asteroid.setY(asteroid.getY() - asteroidVel);
			if (acceleration < 15.0) {
				acceleration += 0.0017;
			} else {
				acceleration = 15;
			}
			if (asteroid.y + 100 < 0) {
				iter.remove();
				score++;
			}
			if (asteroid.overlaps(starRect)) {
				Starun.hitSound.play();
				collisions++;
				iter.remove();
			}
		}
		if (collisions >= 3) {
			if (score > Starun.getHighScore()) {
				Starun.setHighScore(score);
			}
			Starun.gameMusic.stop();
			Starun.menuMusic.play();
			game.setScreen(new GameOverScreen(game));
			dispose();
		}
	}

	private void drawBackground() {
		batch.disableBlending();
		backgroundVel.add(0, -0.01f);
		Starun.backgroundSprite.setV(backgroundVel.y);
		Starun.backgroundSprite.setV2(backgroundVel.y + 1);

		Starun.backgroundSprite.draw(batch);
		batch.enableBlending();
	}

	private void updateRectangle() {
		starRect.setX(starSprite.getX());
		starRect.setY(starSprite.getY());
		touchArea.setX(starSprite.getX());
		touchArea.setY(starSprite.getY() - 100);
	}

	@Override
	public void resize(int width, int height) {
	}

	@Override
	public void pause() {
	}

	@Override
	public void resume() {
	}

	@Override
	public void hide() {
	}

	@Override
	public void dispose() {
		starImage.dispose();
		asteroidImage.dispose();
		batch.dispose();

	}

}
