package atm.starun.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.viewport.StretchViewport;
import com.badlogic.gdx.utils.viewport.Viewport;

public class MainMenuScreen implements Screen {

	final Starun game;
	OrthographicCamera camera;
	Viewport viewport;
	Stage stage;
	Button button, creditsButton;

	public MainMenuScreen(final Starun game) {
		this.game = game;

		camera = new OrthographicCamera();
		viewport = new StretchViewport(Starun.SCREEN_WIDTH, Starun.SCREEN_HEIGHT, camera);
		stage = new Stage(viewport, game.batch);
		button = new TextButton("Play", Starun.skin);
		creditsButton = new TextButton("Credits", Starun.skin);

		button.addListener(new ChangeListener() {

			@Override
			public void changed(ChangeEvent event, Actor actor) {
				Starun.playAgainSound.play();
				Starun.menuMusic.stop();
				Starun.gameMusic.play();
				game.setScreen(new GameScreen(game));
				dispose();
			}
		});

		creditsButton.addListener(new ChangeListener() {

			@Override
			public void changed(ChangeEvent event, Actor actor) {
				Starun.mainMenuSound.play();
				game.setScreen(new CreditsScreen(game));
				dispose();
			}
		});

		Table table = new Table();
		table.center();
		table.setFillParent(true);

		Label titleLabel = new Label("Starun", Starun.titleFontStyle);
		Label highScoreLabel = new Label("High score: " + Starun.getHighScore(), Starun.textFontStyle);
		table.add(titleLabel);
		table.row();
		table.add(button).padTop(10f);
		table.row();
		table.add(creditsButton).padTop(20f);
		table.row();
		table.add(highScoreLabel).padTop(30f);
		stage.addActor(table);

		Starun.menuMusic.play();

		Gdx.input.setInputProcessor(stage);

	}

	@Override
	public void show() {
	}

	@Override
	public void render(float delta) {
		Gdx.gl.glClearColor(0, 0, 0, 1);
		Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT);

		camera.update();
		game.batch.begin();
		Starun.backgroundSprite.draw(game.batch);
		game.batch.end();
		stage.draw();
		Starun.backgroundSprite.scroll(0, Gdx.graphics.getDeltaTime() / -5f);

	}

	@Override
	public void resize(int width, int height) {
	}

	@Override
	public void pause() {
	}

	@Override
	public void resume() {
	}

	@Override
	public void hide() {
	}

	@Override
	public void dispose() {
		stage.dispose();

	}

}
