package atm.starun.game;

import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator.FreeTypeFontParameter;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Label.LabelStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;

public class Starun extends Game {
	public static final int SCREEN_WIDTH = 480;
	public static final int SCREEN_HEIGHT = 800;

	public SpriteBatch batch;
	public static Skin skin;
	public static Texture backgroundImage;
	public static Sprite backgroundSprite;
	public static FreeTypeFontGenerator generator;
	public static FreeTypeFontParameter textParameter, titleParameter, recordParameter,
			creditsParameter;
	public static BitmapFont titleFont, textFont, recordFont, creditFont;
	public static Label.LabelStyle titleFontStyle, textFontStyle, recordFontStyle, creditFontStyle;
	public static Preferences prefs;
	public static Sound newRecordSound, playAgainSound, mainMenuSound, hitSound;
	public static Music menuMusic, gameMusic;

	@Override
	public void create() {
		batch = new SpriteBatch();
		skin = new Skin(Gdx.files.internal("style.json"));

		backgroundImage = new Texture(Gdx.files.internal("background.png"));
		backgroundImage.setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.Repeat);
		backgroundSprite = new Sprite(backgroundImage);

		newRecordSound = Gdx.audio.newSound(Gdx.files.internal("record.wav"));
		playAgainSound = Gdx.audio.newSound(Gdx.files.internal("playagain.wav"));
		mainMenuSound = Gdx.audio.newSound(Gdx.files.internal("mainmenu.wav"));
		hitSound = Gdx.audio.newSound(Gdx.files.internal("hit.wav"));

		menuMusic = Gdx.audio.newMusic(Gdx.files.internal("menumusic.ogg"));
		gameMusic = Gdx.audio.newMusic(Gdx.files.internal("gamemusic.ogg"));

		menuMusic.setLooping(true);
		gameMusic.setLooping(true);

		loadFonts();
		loadPreferences();

		this.setScreen(new MainMenuScreen(this));
	}

	public void render() {
		super.render();
	}

	public void dispose() {
	}

	public void loadFonts() {
		generator = new FreeTypeFontGenerator(Gdx.files.internal("ArchitectsDaughter.ttf"));
		titleParameter = new FreeTypeFontParameter();
		textParameter = new FreeTypeFontParameter();
		recordParameter = new FreeTypeFontParameter();
		creditsParameter = new FreeTypeFontParameter();

		titleParameter.size = 48;
		titleParameter.color = Color.WHITE;
		titleParameter.borderColor = Color.BLUE;
		titleParameter.borderWidth = 2;

		textParameter.size = 24;
		textParameter.color = Color.WHITE;
		textParameter.borderColor = Color.BLUE;
		textParameter.borderWidth = 2;

		recordParameter.size = 32;
		recordParameter.color = Color.WHITE;
		recordParameter.borderColor = Color.RED;
		recordParameter.borderWidth = 2;

		creditsParameter.size = 16;
		creditsParameter.color = Color.WHITE;

		titleFont = generator.generateFont(titleParameter);
		textFont = generator.generateFont(textParameter);
		recordFont = generator.generateFont(recordParameter);
		creditFont = generator.generateFont(creditsParameter);
		generator.dispose();

		titleFontStyle = new LabelStyle(titleFont, titleFont.getColor());
		textFontStyle = new LabelStyle(textFont, textFont.getColor());
		recordFontStyle = new LabelStyle(recordFont, recordFont.getColor());
		creditFontStyle = new LabelStyle(creditFont, creditFont.getColor());

	}

	public void loadPreferences() {
		prefs = Gdx.app.getPreferences("Starun");
		if (!prefs.contains("highScore")) {
			prefs.putInteger("highScore", 0);
		}
	}

	public static void setHighScore(int val) {
		prefs.putInteger("highScore", val);
		prefs.flush();
	}

	public static int getHighScore() {
		return prefs.getInteger("highScore");
	}

	public static int getWidth() {
		return SCREEN_WIDTH;
	}

	public static int getHeight() {
		return SCREEN_HEIGHT;
	}

}
