angular.module('khlm', ['ionic', 'ionic.utils', 'khlm.controllers.app', 'khlm.controllers.feed', 'khlm.controllers.calendar', 'khlm.controllers.settings', 'khlm.controllers.startscreen', 'khlm.controllers.bus', 'khlm.conf', 'ngSanitize', 'ngCookies', 'pascalprecht.translate'])

.run(function($ionicPlatform, $translate, appconfig, appvars) {
  // Set language based on settings or device language
  var lang = 'en';
  var langSet = false;
  var translationKeys = appconfig.get().translations.map(function(e) {return e.key});
  var storage = $translate.storage();
  if (storage) {
    var storageLang = storage.get($translate.storageKey());
    if (storageLang && translationKeys.indexOf(storageLang) >= 0) {
      lang = storageLang;
      langSet = true;
    }
  }
  if (!langSet) {
    var deviceLang = lang;
    if (navigator.languages && navigator.languages[0])
      deviceLang = navigator.languages[0];
    else
      deviceLang = navigator.language || navigator.browserLanguage || navigator.systemLanguage || navigator.userLanguage;
    if (translationKeys.indexOf(deviceLang) >= 0) {
      lang = deviceLang;
    } else { // Check a little bit harder (nl_BE -> nl for example)
      if (deviceLang.indexOf('_') >= 0) {
        deviceLangArr = deviceLang.split('_');
        deviceLang = deviceLangArr[0];
        if (translationKeys.indexOf(deviceLang) >= 0) {
          lang = deviceLang;
        }
      }
    }
    $translate.use(lang);
  }
  moment.locale(lang);
  appvars.currLang = lang;
  
  $ionicPlatform.ready(function() {
    // Hide the accessory bar by default (remove this to show the accessory bar above the keyboard
    // for form inputs)
    if (window.cordova && window.cordova.plugins.Keyboard) {
      cordova.plugins.Keyboard.hideKeyboardAccessoryBar(true);
    }
    if (window.StatusBar) {
      // org.apache.cordova.statusbar required
      StatusBar.styleDefault();
    }
  });
})

.filter('sysbrowser', function ($sce, $sanitize) {
  return function (txt) {
    var re = /href="([\S]+)"/g;
    var newString = $sanitize(txt).replace(re, "href=\"#\" onClick=\"window.open('$1', '_system', 'location=yes'); return false;\"");
    return $sce.trustAsHtml(newString);
  }
})

.filter('delijnRealtimeUrl', function ($sce) {
  return function(lines) {
    console.log("delijn url for", lines);
    return $sce.trustAsResourceUrl('https://www.delijn.be/realtime/' + lines + '/50');
  }
})

.config(function($stateProvider, $urlRouterProvider, $ionicConfigProvider, $translateProvider) {
  $stateProvider

  .state('app', {
    url: "/app",
    abstract: true,
    templateUrl: "templates/menu.html"
  })
  
  .state('app.feed', {
    url: "/feed/:feedId",
    views: {
      'menuContent': {
        templateUrl: "templates/feed.html"
      }
    }
  })
  
  .state('app.calendar', {
    url: "/calendar/:icalId",
    views: {
      'menuContent': {
        templateUrl: "templates/calendar.html"
      }
    }
  })
  
  .state('app.bustimes', {
    url: "/bustimes",
    views: {
      'menuContent': {
        templateUrl: "templates/bustimes.html"
      }
    }
  })
  
  .state('app.settings', {
    url: "/settings",
    views: {
      'menuContent': {
        templateUrl: "templates/settings.html"
      }
    }
  })
  
  .state('app.about', {
    url: "/about",
    views: {
      'menuContent': {
        templateUrl: "templates/about.html"
      }
    }
  })
  
  .state('app.startscreen', {
    url: "/startscreen",
    views: {
      'menuContent': {
        templateUrl: "templates/startscreen.html"
      }
    }
  })
  
  // if none of the above states are matched, use this as the fallback
  $urlRouterProvider.otherwise('/app/startscreen');
  
  // Bottom tabs (bus times)
  $ionicConfigProvider.tabs.position('bottom');
  
  // Configure translations
  $translateProvider.useStaticFilesLoader({
    prefix: 'i18n/locale-',
    suffix: '.json'
  });
  $translateProvider
    .preferredLanguage('en')
    .fallbackLanguage('en')
    .useLocalStorage();
  moment.locale('en');
});

//window.onLoginFrameLoad = function() {}