angular.module('khlm.controllers.app', ['khlm.conf', 'khlm.services', 'ionic.utils', 'ngCookies'])

.controller('AppController', function($scope, $rootScope, $ionicModal, $ionicPopup, $ionicLoading, $http, $localstorage, $ionicHistory, $window, $filter, $location, $translate, appconfig, appvars, feedmanager, $sce) {
  // Form data for the syncUrls modal
  $scope.loginData = {};
  
  // Register updated URL callbacks
  feedmanager.onUpdatedUrls(function() {
    $scope.customFeeds = feedmanager.getFeeds().custom;
    $scope.customIcals = feedmanager.getIcals().custom;
  });

  // Create the syncUrls modal that we will use later
  $ionicModal.fromTemplateUrl('templates/syncform.html', {
    scope: $scope
  }).then(function(modal) {
    $scope.modal = modal;
  });

  // Triggered in the syncUrls modal to close it
  $scope.closeLogin = function() {
    $scope.modal.hide();
  };

  // Open the syncUrls modal
  $scope.syncUrls = function() {
    $scope.modal.show();
  };
  
  $translate("never").then(function(tr_never) {
    $scope.lastsync = $localstorage.get("urls_updated", tr_never);
  });

  // Perform the syncUrls action when the user submits the form
  $scope.doSyncUrls = function() {
    $translate([
      "OK",
      "Connecting to UCLL portal...",
      "Could not login to UCLL portal.",
      "Could not retrieve all data",
      "Could not find your notices RSS feed.",
      "Could not find the project work Atom feed.",
      "Could not find the international news RSS feed.",
      "Could not find your personal course calendar iCal feed.",
      "Success",
      "All feed URLs have been updated successfully."
    ]).then(function(tr) {
      $ionicLoading.show({
        template: tr['Connecting to UCLL portal...']
      });
      //$scope.tryLogin();
      
      $http.get(appconfig.get().url_shibproxy + "/", {
        params: {
          "l": $scope.loginData.login,
          "p": $scope.loginData.password
        }
      }).success(function(data) {
        $ionicLoading.hide();
        var errors = [];
        var updatedCount = 0;
        if (!data.loggedIn) {
          errors.push(tr["Could not login to UCLL portal."]);
        } else {
          if (data.feeds && data.feeds.notices) {
            $localstorage.set('url_notices', data.feeds.notices);
            ++updatedCount;
          } else {
            errors.push(tr["Could not find your notices RSS feed."]);
          }
          if (data.feeds && data.feeds.projectwork) {
            $localstorage.set('url_projectwork', data.feeds.projectwork);
            ++updatedCount;
          } else {
            errors.push(tr["Could not find the project work Atom feed."]);
          }
          if (data.feeds && data.feeds.internat) {
            $localstorage.set('url_internat', data.feeds.internat);
            ++updatedCount;
          } else {
            errors.push(tr["Could not find the international news RSS feed."]);
          }
          if (data.icals.coursecal && data.icals.coursecal) {
            $localstorage.set('url_coursecal', data.icals.coursecal);
            ++updatedCount;
          } else {
            errors.push(tr["Could not find your personal course calendar iCal feed."])
          }
        }
        if (updatedCount > 0) {
          var date = new Date;
          var date_f = $filter('date')(date, "dd/MM/yyyy HH:mm");
          $localstorage.set('urls_updated', date_f);
          feedmanager.updateUrls();
          $scope.lastsync = date_f;
        }
        if (errors.length) {
          var lis = errors.join('</li><li class="item item-text-wrap item-err">');
          $ionicPopup.alert({
            title: tr['Could not retrieve all data'],
            template: '<ul class="list"><li class="item item-text-wrap item-err">'+lis+'</li></ul>',
            okText: tr['OK']
          });
        } else {
          $ionicPopup.alert({
            title: tr['Success'],
            template: '<div class="card"><div class="item item-text-wrap item-ok">'+tr['All feed URLs have been updated successfully.']+'</div></div>',
            okText: tr['OK']
          });
        }
        if (data.loggedIn) {
          $scope.loginData = {};
          $scope.closeLogin();
          if ($rootScope.refresher) {
            $rootScope.refresher(true);
          }
        }
      }).error(function(data) {
        $ionicLoading.hide();
        console.log("ERROR: " + data);
      });
    });
  }
  
  $scope.updateLanguage = function() {
    appvars.currLang = $scope.settings.language.key;
    $translate.use(appvars.currLang).then(function(data) {
      moment.locale(appvars.currLang);
      feedmanager.updateTranslations(function() {
        if ($rootScope.refresher) {
          $rootScope.refresher(true);
        }
      });
    });
  }
  
  $scope.gotoSyncUrls = function() {
    $localstorage.set("first_time", "no");
    $scope.welcome.hide();
    $scope.syncUrls();
  }
  
  $scope.gotoSettings = function() {
    $localstorage.set("first_time", "no");
    $scope.welcome.hide();
    $ionicHistory.nextViewOptions({disableBack: true});
    $location.path('/app/settings');
  }
  
  /*$scope.afterTryLogin = function() {
    $translate([
      "OK",
      "Could not login to UCLL portal.",
      "Could not retrieve all data",
      "Could not find your notices RSS feed.",
      "Could not find the project work Atom feed.",
      "Could not find the international news RSS feed.",
      "Could not find your personal course calendar iCal feed.",
      "Success",
      "All feed URLs have been updated successfully."
    ]).then(function(tr) {
      $ionicLoading.hide();
      var errors = [];
      var updatedCount = 0;
      if (!$scope.loggedIn) {
        errors.push(tr["Could not login to UCLL portal."]);
      } else {
        if ($scope.notices) {
          $localstorage.set('url_notices', $scope.notices);
          ++updatedCount;
        } else {
          errors.push(tr["Could not find your notices RSS feed."]);
        }
        if ($scope.projectwork) {
          $localstorage.set('url_projectwork', $scope.projectwork);
          ++updatedCount;
        } else {
          errors.push(tr["Could not find the project work Atom feed."]);
        }
        if ($scope.internat) {
          $localstorage.set('url_internat', $scope.internat);
          ++updatedCount;
        } else {
          errors.push(tr["Could not find the international news RSS feed."]);
        }
        if ($scope.coursecal) {
          $localstorage.set('url_coursecal', $scope.coursecal);
          ++updatedCount;
        } else {
          errors.push(tr["Could not find your personal course calendar iCal feed."])
        }
      }
      if (updatedCount > 0) {
        var date = new Date;
        var date_f = $filter('date')(date, "dd/MM/yyyy HH:mm");
        $localstorage.set('urls_updated', date_f);
        feedmanager.updateUrls();
        $scope.lastsync = date_f;
      }
      if (errors.length) {
        var lis = errors.join('</li><li class="item item-text-wrap item-err">');
        $ionicPopup.alert({
          title: tr['Could not retrieve all data'],
          template: '<ul class="list"><li class="item item-text-wrap item-err">'+lis+'</li></ul>',
          okText: tr['OK']
        });
      } else {
        $ionicPopup.alert({
          title: tr['Success'],
          template: '<div class="card"><div class="item item-text-wrap item-ok">'+tr['All feed URLs have been updated successfully.']+'</div></div>',
          okText: tr['OK']
        });
      }
      if ($scope.loggedIn) {
        $scope.loginData = {};
        $scope.closeLogin();
        if ($rootScope.refresher) {
          $rootScope.refresher(true);
        }
      }
    });
  }*/
  
  /*$scope.tryLogin = function() {
    $scope.loginProxy = {};
    $scope.loginProxy.prefix = "https://portaal.khleuven.be/";
    $scope.loginProxy.page_coursecal = "index.php?page=209";
    //var page_notices = "index.php?page=1";
    var url = $sce.trustAsResourceUrl($scope.loginProxy.prefix + 'Shibboleth.sso/WAYF/khleuven?target=' + encodeURI($scope.loginProxy.prefix + $scope.loginProxy.page_coursecal));
    
    $scope.loggedIn = false;
    $scope.notices = false;
    $scope.coursecal = false;
    $scope.internat = "https://internat.khleuven.be/?q=rss.xml";
    $scope.projectwork = "https://projectwerk.khleuven.be/news.atom";
    $scope.possiblyLoggedIn = false;
    $scope.step = 1;
    
    console.log("set frame url: " + url);
    //$scope.frameUrl = url;
    document.getElementById('loginFrame').src = url;
  }*/
    
  $scope.init = function() {
    /*window.onLoginFrameLoad = function() {
      console.log("window.onLoginFrameLoad ? " + $scope.step);
      var iframe = document.getElementById('loginFrame');
      var framedoc = iframe.contentDocument;
      if ($scope.step == 1) {
        var pattern = /href="\/Shibboleth\.sso\/Logout\?/;
        console.log(framedoc.getElementsByTagName('html')[0].innerHTML);
        var matches = framedoc.getElementsByTagName('html')[0].innerHTML.match(pattern);
        $scope.loggedIn = matches && matches.length > 0;
        
        if ($scope.loggedIn) {
          $scope.step = 3;
          window.onLoginFrameLoad();
        } else {
          $scope.step = 2;
          framedoc.getElementById('username').value = $scope.loginData.login;
          framedoc.getElementById('password').value = $scope.loginData.password;
          framedoc.getElementById('login').submit();
        }
      } else if ($scope.step == 2) {
        var pattern = /id="username\.errors"/;
        console.log(framedoc.getElementsByTagName('html')[0].innerHTML);
        var matches = framedoc.getElementsByTagName('html')[0].innerHTML.match(pattern);
        $scope.possiblyLoggedIn = matches ? false : true;
        $scope.step = 3;
        window.onLoginFrameLoad();
      } else if ($scope.step == 3) {
        if ($scope.loggedIn || $scope.possiblyLoggedIn) {
          var pattern = /href="\/Shibboleth\.sso\/Logout\?/;
          var matches = framedoc.getElementsByTagName('html')[0].innerHTML.match(pattern);
          $scope.loggedIn = matches && matches.length > 0;
          
          pattern = /href="(export\.php\?what=uurrooster_studenten_persoonlijk[^"]*)"/;
          matches = framedoc.getElementsByTagName('html')[0].innerHTML.match(pattern);
          $scope.coursecal = matches && matches.length > 1 ? $scope.loginProxy.prefix + matches[1] : false;
          
          pattern = /href="(.*\/rss\.php\?[^"]*)"/;
          matches = framedoc.getElementsByTagName('html')[0].innerHTML.match(pattern);
          $scope.notices = matches && matches.length > 1 ? matches[1] : false;
          
          console.log("everything completed...");
          console.log($scope.loggedIn, $scope.notices, $scope.coursecal);
          
          //$scope.step = 4;
          //$scope.frameUrl = $scope.loginProxy.prefix + $scope.loginProxy.page_notices;
          //console.log("set frame url: " + $scope.loginProxy.prefix + page_notices);
          //iframe.src = $sce.trustAsResourceUrl($scope.loginProxy.prefix + $scope.loginProxy.page_notices);
        }
        $scope.afterTryLogin();
      }
    };*/
    
    $scope.settings = {};
    feedmanager.updateUrls();
    feedmanager.updateTranslations(function() {
      // Create the welcome modal that we will use later
      var firstTime = $localstorage.get("first_time", "yes");
      if (firstTime == 'yes') {
        $ionicModal.fromTemplateUrl('templates/welcomeform.html', {
          scope: $scope,
          backdropClickToClose: false,
          hardwareBackButtonClose: false
        }).then(function(modal) {
          $scope.settings.languages = appconfig.get().translations;
          var translationKeys = appconfig.get().translations.map(function(e) {return e.key});
          $scope.settings.language = $scope.settings.languages[0];
          if (appvars.currLang) {
            $scope.settings.language = $scope.settings.languages[translationKeys.indexOf(appvars.currLang)];
          }
          $scope.welcome = modal;
          $scope.welcome.show();
        });
      }
    });
  };
})
