angular.module('khlm.controllers.calendar', ['khlm.conf', 'khlm.services', 'ionic.utils'])

.controller("CalendarController", function($http, $scope, $rootScope, $stateParams, $location, $ionicScrollDelegate, $ionicHistory, $translate, appconfig, feedmanager) {
  $scope.$on('$ionicView.afterEnter', function() {
    $scope.doRefresh(true);
    $rootScope.refresher = $scope.doRefresh;
  });
  
  $scope.doRefresh = function(showLoader) {
    $scope.loading = showLoader;
    $ionicScrollDelegate.scrollTop(true);
    
    var icalId = $stateParams.icalId;
    var icals = feedmanager.getIcals();
    var icalConf = icals[icalId];
    if (!icalConf) {
      icalConf = icals.custom[icalId];
      if (!icalConf) {
        $ionicHistory.nextViewOptions({disableBack: true});
        $location.path('/app/calendar/coursecal');
      }
    }
    $scope.title = icalConf.title;
    $http.get(appconfig.get().url_ical_parser + "/", {
      params: {
        url: icalConf.feed
      } 
    }).success(function(data) {
      if (!data || !data.cal || !data.cal.VEVENT) {
        $translate([
          "Could not load",
          "Could not load iCal feed.",
          "Course calendar not available",
          "COURSECAL_NOT_AVAILABLE_INFO"
        ]).then(function(tr) {
          $scope.rssTitle = tr['Could not load'];
          $scope.rssUrl = '';
          $scope.rssSiteUrl = '';
          $scope.entries = [];
          $scope.loading = false;
          $scope.$broadcast('scroll.refreshComplete');
          
          if (icalId == 'coursecal' && icalConf.feed.length == 0) {
            $scope.entries.push({
              title: tr['Course calendar not available'],
              hourStart: '',
              hourEnd: '',
              location: tr['COURSECAL_NOT_AVAILABLE_INFO'],
              content: tr['COURSECAL_NOT_AVAILABLE_INFO']
            });
          } else {
            $scope.entries.push({
              title: tr['Could not load'],
              hourStart: '',
              hourEnd: '',
              location: tr['Could not load iCal feed.'],
              content: tr['Could not load iCal feed.']
            });
          }
        });
      } else {
        var entries = [];
        var prevstart = false;
        var prevfuture = false;
        var groupWithPrevious = false;
        var id = 1;
        var scrollToId = false;
        
        // Sort it
        data.cal.VEVENT.sort(function(a, b) {
          var astart = moment(a.DTSTART, "YYYYMMDDTHHmmssZ");
          var bstart = moment(b.DTSTART, "YYYYMMDDTHHmmssZ");
          return astart.isBefore(bstart) ? -1 : 1;
        });
        
        for (var i in data.cal.VEVENT) {
          var e = data.cal.VEVENT[i];
          var start = moment(e.DTSTART, "YYYYMMDDTHHmmssZ");
          var fstart = start.format("HH:mm");
          var fday = start.format("dddd DD MMMM YYYY");
          var end = moment(e.DTEND, "YYYYMMDDTHHmmssZ");
          var fend = end.format("HH:mm");
          var hourStart = fstart;
          var hourEnd = fend;
          var location = e.LOCATION;
          var title = e.SUMMARY || e.DESCRIPTION;
          var onlySummaryOrDescription = !(e.SUMMARY && e.DESCRIPTION);
          var description = onlySummaryOrDescription ? '' : (e.DESCRIPTION || e.SUMMARY);
          var future = end.isAfter(moment());
          if (future && !prevfuture) {
            scrollToId = id;
          }
          prevfuture = future;
          if (prevstart) {
            groupWithPrevious = start.isSame(prevstart, 'day');
          }
          prevstart = start;
          if (!groupWithPrevious) {
            entries.push({title: fday, title: fday, extracls: 'item-divider'});
          }
          entries.push({id: id, start: start, title: title, description: description, location: location, hourStart: hourStart, hourEnd: hourEnd, extracls: future ? 'future' : 'past'});
          ++id;
        }
        
        $scope.entries = entries;
        if (scrollToId) {
          $scope.loading = false;
          $location.hash("cal-entry-" + scrollToId);
          setTimeout(function() {
            $ionicScrollDelegate.anchorScroll(true);
          }, 0);
        }
      }
    }).error(function(data) {
      console.log("ERROR: " + data);
      $translate([
        "Could not load",
        "Could not load iCal feed."
      ]).then(function(tr) {
        $scope.rssTitle = tr['Could not load'];
        $scope.rssUrl = '';
        $scope.rssSiteUrl = '';
        $scope.entries = [{
          title: tr['Could not load'],
          hourStart: '',
          hourEnd: '',
          location: tr['Could not load iCal feed.'],
          content: tr['Could not load iCal feed.']
        }];
      });
      $scope.loading = false;
      $scope.$broadcast('scroll.refreshComplete');
    });
  }
})
