angular.module('khlm.controllers.feed', ['khlm.conf', 'khlm.services', 'ionic.utils'])

.controller("FeedController", function($http, $scope, $rootScope, $stateParams, $location, $ionicScrollDelegate, $ionicHistory, $translate, appconfig, feedmanager) {
  $scope.$on('$ionicView.afterEnter', function() {
    $scope.doRefresh(true);
    $rootScope.refresher = $scope.doRefresh;
  });
  
  $scope.doRefresh = function(showLoader) {
    $scope.loading = showLoader;
    $ionicScrollDelegate.scrollTop(true);
    
    var feedId = $stateParams.feedId;
    var feeds = feedmanager.getFeeds();
    var feedConf = feeds[feedId];
    if (!feedConf) {
      feedConf = feeds.custom[feedId];
      if (!feedConf) {
        $ionicHistory.nextViewOptions({disableBack: true});
        $location.path('/app/feed/notices');
      }
    }
    $scope.title = feedConf.title;
    $http.get(appconfig.get().url_feed_parser + "/", {
      params: {
        url: feedConf.feed
      }
    }).success(function(data) {
      if (data.responseData && data.valid) {
        $scope.rssTitle = data.responseData.feed.title;
        $scope.rssUrl = data.responseData.feed.feedUrl;
        $scope.rssSiteUrl = data.responseData.feed.link;
        $scope.entries = data.responseData.feed.entries;
        $scope.loading = false;
        $scope.$broadcast('scroll.refreshComplete');
      } else {
        $translate([
          "Could not load",
          "Could not load RSS feed."
        ]).then(function(tr) {
          $scope.rssTitle = tr['Could not load'];
          $scope.rssUrl = '';
          $scope.rssSiteUrl = '';
          $scope.entries = [{
            title: tr['Could not load'],
            contentSnippet: tr['Could not load RSS feed.'],
            content: tr['Could not load RSS feed.']
          }];
          $scope.loading = false;
          $scope.$broadcast('scroll.refreshComplete');
        });
      }
    }).error(function(data) {
      console.log("ERROR: " + data);
      $translate([
        "Could not load",
        "Could not load RSS feed."
      ]).then(function(tr) {
        $scope.rssTitle = tr['Could not load'];
        $scope.rssUrl = '';
        $scope.rssSiteUrl = '';
        $scope.entries = [{
          title: tr['Could not load'],
          contentSnippet: tr['Could not load RSS feed.'],
          content: tr['Could not load RSS feed.']
        }];
      });
      $scope.loading = false;
      $scope.$broadcast('scroll.refreshComplete');
    });
  };
  
  $scope.expandhtml = function(entry, targetType) {
    if (targetType == 'a')
      return;
    if (entry.expanded) {
      entry.contentSnippet = entry.origContentSnippet;
      entry.expanded = false;
    } else {
      entry.origContentSnippet = entry.contentSnippet;
      entry.contentSnippet = entry.content;
      entry.expanded = true;
    }
    $ionicScrollDelegate.resize();
  }
})
