angular.module('khlm.controllers.settings', ['khlm.conf', 'khlm.services', 'ionic.utils'])

.controller("SettingsController", function($http, $scope, $localstorage, $location, $ionicHistory, $ionicModal, $ionicPopup, $translate, $window, feedmanager, appconfig, appvars) {
  $scope.closeUrlForm = function() {
    $scope.modal.hide();
  };

  $scope.showUrlForm = function() {
    $translate([
      "Custom URL",
      "Custom feed URL",
      "Custom iCalendar URL"
    ]).then(function(tr) {
      var title = tr['Custom URL'];
      if ($scope.customUrlType == 'feed')
        title = tr['Custom feed URL'];
      if ($scope.customUrlType == 'ical')
        title = tr['Custom iCalendar URL'];
      $scope.modal.title = title;
      $scope.modal.show();
    });
  };
  
  $scope.addUrl = function(type) {
    $scope.customUrlId = 0;
    $scope.customUrlNew = true;
    $scope.customUrlType = type;
    $scope.urlData = {
      title: '',
      url: ''
    };
    $scope.showUrlForm();
  };
  
  $scope.editUrl = function(item, index, targetType) {
    console.log(targetType);
    if (targetType != 'div')
      return;
    
    $scope.customUrlIndex = index;
    $scope.customUrlNew = false;
    $scope.customUrlType = item.type;
    $scope.urlData = {
      title: item.title,
      feed: item.feed
    };
    $scope.showUrlForm();
  };
  
  $scope.doSaveUrl = function() {
    if (!$scope.urlData || !$scope.urlData.title || !$scope.urlData.feed) {
      $translate([
        "OK",
        "Fill in all fields",
        "You have to fill in both the URL and a descriptive title."
      ]).then(function(tr) {
        $ionicPopup.alert({
          title: tr['Fill in all fields'],
          template: tr['You have to fill in both the URL and a descriptive title.'],
          okText: tr['OK']
        });
      });
      return;
    }
    
    var list = false;
    if ($scope.customUrlType == 'feed')
      list = $scope.customFeeds;
    else if ($scope.customUrlType == 'ical')
      list = $scope.customCals;
    if (list) {
      var item = {
        title: $scope.urlData.title,
        feed: $scope.urlData.feed,
        type: $scope.customUrlType
      };
      if ($scope.customUrlNew) {
        list.push(item);
      } else {
        list[$scope.customUrlIndex] = item;
      }
    }
    $scope.closeUrlForm();
  };
    
  $scope.init = function() {
    $scope.settings = {};
    $scope.customFeeds = [];
    $scope.customCals = [];
    
    // Form data for the custom feed/calendar modal
    $scope.urlData = {};

    // Create the syncUrls modal that we will use later
    $ionicModal.fromTemplateUrl('templates/urlform.html', {
      scope: $scope
    }).then(function(modal) {
      $scope.modal = modal;
    });
  };
  
  $scope.save = function() {
    $localstorage.set('url_notices', $scope.settings.url_notices);
    $localstorage.set('url_projectwork', $scope.settings.url_projectwork);
    $localstorage.set('url_internat', $scope.settings.url_internat);
    $localstorage.set('url_coursecal', $scope.settings.url_coursecal);
    $localstorage.set('url_backend', $scope.settings.url_backend);
    
    // Custom URLs
    $localstorage.setObject('custom_feeds', $scope.customFeeds);
    $localstorage.setObject('custom_cals', $scope.customCals);
    feedmanager.updateUrls();
    
    // Start screen
    $localstorage.set('startscreen', $scope.settings.startscreen.key);
    
    // Campus
    $localstorage.set('campus', $scope.settings.campus.key);

    // Language
    appvars.currLang = $scope.settings.language.key;
    $translate.use(appvars.currLang).then(function(data) {
      moment.locale(appvars.currLang);
      feedmanager.updateTranslations(function() {
        // Go to start screen after saving and updating translations
        $ionicHistory.nextViewOptions({disableBack: true});
        var startscreen = $localstorage.get('startscreen', 'calendar/coursecal');
        $location.path('/app/' + startscreen);
      });
    });
  }
  
  $scope.reorderItem = function(item, fromIndex, toIndex) {
    var list = false;
    if (item.type == 'feed')
      list = $scope.customFeeds;
    else if (item.type == 'ical')
      list = $scope.customCals;
    if (list) {
      list.splice(fromIndex, 1);
      list.splice(toIndex, 0, item);
    }
  }
  
  $scope.deleteItem = function(item) {
    $translate([
      "Cancel",
      "Delete",
      "Delete custom URL?",
      "Are you sure you want to delete this custom URL?"
    ]).then(function(tr) {
      var confirmPopup = $ionicPopup.confirm({
        title: tr['Delete custom URL?'],
        template: tr['Are you sure you want to delete this custom URL?'],
        cancelText: tr['Cancel'],
        okText: tr['Delete']
      });
      confirmPopup.then(function(res) {
        if(res) {
          var list = false;
          if (item.type == 'feed')
            list = $scope.customFeeds;
          else if (item.type == 'ical')
            list = $scope.customCals;
          if (list) {
            list.splice(list.indexOf(item), 1);
          }
        }
      });
    });
  }
  
  $scope.$on('$ionicView.afterEnter', function() {
    $scope.showDelete = true;
    $scope.showReorder = true;
    $scope.settings.url_notices = feedmanager.getFeeds().notices.feed;
    $scope.settings.url_projectwork = feedmanager.getFeeds().projectwork.feed;
    $scope.settings.url_internat = feedmanager.getFeeds().internat.feed;
    $scope.settings.url_coursecal = feedmanager.getIcals().coursecal.feed;
    $scope.settings.url_backend = appvars.url_backend;
    $scope.customFeeds = feedmanager.getFeeds().custom;
    $scope.customCals = feedmanager.getIcals().custom;
    
    $translate([
      "Course calendar",
      "Notices",
      "Project work news",
      "International news",
      "Bus times"
    ]).then(function(tr) {
      $scope.settings.startscreenopts = [
        {key: 'calendar/coursecal', name: tr['Course calendar']},
        {key: 'feed/notices', name: tr['Notices']},
        {key: 'feed/projectwork', name: tr['Project work news']},
        {key: 'feed/internat', name: tr['International news']},
        {key: 'bustimes', name: tr['Bus times']}
      ];
      var startscreen = $localstorage.get('startscreen', 'calendar/coursecal');
      var screenoptKeys = $scope.settings.startscreenopts.map(function(e) {return e.key});
      $scope.settings.startscreen = $scope.settings.startscreenopts[screenoptKeys.indexOf(startscreen)];
    });
    
    $scope.settings.languages = appconfig.get().translations;
    var translationKeys = appconfig.get().translations.map(function(e) {return e.key});
    $scope.settings.language = $scope.settings.languages[0];
    if (appvars.currLang) {
      $scope.settings.language = $scope.settings.languages[translationKeys.indexOf(appvars.currLang)];
    }
    $scope.settings.campuses = [
      {key: 'leuven-comenius', name: 'Leuven: Comenius'},
      {key: 'leuven-gasthuisberg', name: 'Leuven: Gasthuisberg'},
      {key: 'leuven-hertogstraat', name: 'Leuven: Hertogstraat'},
      {key: 'leuven-proximus', name: 'Leuven: Proximus'},
      {key: 'leuven-socialeschool', name: 'Leuven: Sociale School'},
      {key: 'diest-clenardus', name: 'Diest: Clenardus'},
      {key: 'hasselt-hemelrijk', name: 'Hasselt: Hemelrijk'},
      {key: 'hasselt-oudeluikerbaan', name: 'Hasselt: Oude Luikerbaan'},
      {key: 'diepenbeek', name: 'Diepenbeek'},
      {key: 'genk-liza', name: 'Genk: LiZa'},
    ];
    var campus = $localstorage.get('campus', 'leuven-proximus');
    var campusesKeys = $scope.settings.campuses.map(function(e) {return e.key});
    $scope.settings.campus = $scope.settings.campuses[campusesKeys.indexOf(campus)];
  });
})
