angular.module('khlm.services', ['khlm.conf'])

.factory('feedmanager', function($localstorage, $translate, appvars) {
  var feeds = {
    notices: {
      title: 'Notices',
      feed: 'https://portaal.khleuven.be/rss.php'
    },
    internat: {
      title: 'International news',
      feed: 'https://internat.khleuven.be/?q=rss.xml'
    },
    projectwork: {
      title: 'Project work news',
      feed: 'https://projectwerk.khleuven.be/news.atom'
    },
    custom: []
  };
  
  var icals = {
    coursecal: {
      title: 'Course calendar',
      feed: ''
    },
    custom: []
  };
  
  var buses = {
    "leuven-gasthuisberg": {
      title: 'Gasthuisberg',
      buses: [
        {
          icon: 'ion-university',
          text: 'Campus',
          lines: '308654+308882'
        }, {
          icon: 'ion-ios-pulse-strong',
          text: 'Hospital',
          lines: '303032+302978+302987+302988+308674'
        }
      ]
    },
    "leuven-proximus": {
      title: 'Proximus',
      buses: [
        {
          icon: 'ion-android-bus',
          text: 'Interleuvenlaan',
          lines: '303052+303053'
        }
      ]
    },
    "leuven-comenius": {
      title: 'Comenius',
      buses: [
        {
          icon: 'ion-android-train',
          text: 'Station',
          lines: '303124+303126+303128+303129+303130+303131+303132+303134+303135+303136+306086+308757'
        }, {
          icon: 'ion-flag',
          text: 'Provinciehuis',
          lines: '308438+308439'
        }
      ]
    },
    "leuven-hertogstraat": {
      title: 'Hertogstraat',
      buses: [
        {
          icon: 'ion-university',
          text: 'Kazerne (H. Hart)',
          lines: '302895+306096'
        }
      ]
    },
    "leuven-socialeschool": {
      title: 'Sociale School',
      buses: [
        {
          icon: 'ion-university',
          text: 'Soc. Hoge School',
          lines: '302883+302884'
        }
      ]
    },
    "diest-clenardus": {
      title: 'Clenardus',
      buses: [
        {
          icon: 'ion-university',
          text: 'Atheneum',
          lines: '301231+301232'
        }, {
          icon: 'ion-android-train',
          text: 'Station',
          lines: '401651+401652+401653+401654+307092+301246+308670+308671'
        }
      ]
    },
    "hasselt-hemelrijk": {
      title: 'Hemelrijk',
      buses: [
        {
          icon: 'ion-leaf',
          text: 'Dusartplein',
          lines: '403040+403041'
        }
      ]
    },
    "hasselt-oudeluikerbaan": {
      title: 'Oude Luikerbaan',
      buses: [
        {
          icon: 'ion-university',
          text: 'KHLIM Oude Luikerbaan',
          lines: '403578+403579'
        }
      ]
    },
    "diepenbeek": {
      title: 'Diepenbeek',
      buses: [
        {
          icon: 'ion-flag',
          text: 'KHLIM Campus',
          lines: '401464+401465'
        }, {
          icon: 'ion-university',
          text: 'Universiteit',
          lines: '401474+401475'
        }
      ]
    },
    "genk-liza": {
      title: 'LiZa',
      buses: [
        {
          icon: 'ion-ios-pulse-strong',
          text: 'Hospital',
          lines: '402398'
        }
      ]
    }
  };
  
  // Updated callback functions
  var updatedCBFuncs = [];
  
  return {
    getFeeds: function getFeeds() {return feeds;},
    getIcals: function getIcals() {return icals;},
    getBuses: function getBuses() {return buses;},
    updateUrls: function updateUrls() {
      // Set feed data from saved local storage
      var url_notices = $localstorage.get('url_notices', false);
      var url_internat = $localstorage.get('url_internat', false);
      var url_projectwork = $localstorage.get('url_projectwork', false);
      var url_coursecal = $localstorage.get('url_coursecal', false);
      var url_backend = $localstorage.get('url_backend', false);
      if (url_notices !== false)
        feeds.notices.feed = url_notices;
      if (url_internat !== false)
        feeds.internat.feed = url_internat;
      if (url_projectwork !== false)
        feeds.projectwork.feed = url_projectwork
      if (url_coursecal !== false)
        icals.coursecal.feed = url_coursecal;
      if (url_backend !== false)
        appvars.url_backend = url_backend;
            
      // Set custom URLs from saved local storage
      var customFeeds = $localstorage.getObject('custom_feeds');
      if (customFeeds.length)
        feeds.custom = customFeeds;
      var customCals = $localstorage.getObject('custom_cals');
      if (customCals.length)
        icals.custom = customCals;
      
      // Callbacks
      for (var i in updatedCBFuncs) {
        updatedCBFuncs[i]();
      }
    },
    onUpdatedUrls: function onUpdatedUrls(fn) {
      if (typeof fn === 'function')
        updatedCBFuncs.push(fn);
    },
    updateTranslations: function(fn) {
      $translate([
        "Notices",
        "International news",
        "Project work news",
        "Course calendar"
      ]).then(function(tr) {
        feeds.notices.title = tr['Notices'];
        feeds.internat.title = tr['International news'];
        feeds.projectwork.title = tr['Project work news'];
        icals.coursecal.title = tr['Course calendar'];
        if (typeof fn === 'function')
          fn();
      });
    }
  };
})

;