# Spartathlon

Mobile app built with [Flutter](https://flutter.io/) for the Greek ultra marathon race [Spartathlon](www.spartathlon.gr/en).

It is built with three audiences in mind: Spartathletes, support crews, and volunteers. It aims to
help them before, during and after the race in the getting information they need in a clean, modern
and mobile-friendly way.

## Get the app

<p align="center"><a href="https://f-droid.org/app/ch.thgoebel.spartathlonapp"><img src="https://f-droid.org/badge/get-it-on.png" height="75"></a></p> 

Releases for Google Play and the Apple's App Store will follow later.

## Features

* Read race reports
* View checkpoints, get directions and filter by "supporters allowed" or "live results available"
* Search through the list of the athletes who compete(d) in the current year.
* Display your favourite athletes directly on the dashboard
* Dark theme (easier on the eyes if you're waiting for your athlete in Nestani)

See the changelog [here](https://gitlab.com/thgoebel/spartathlon/blob/master/CHANGELOG.md).

This covers what is already in the [old app](https://play.google.com/store/apps/details?id=gr.netfocus.spartathlon).
We aim to increase the functionality and make more features from the website available in the app
(such as viewing results for past years).
However, this requires server-side changes, and with Spartathlon being fully run
by volunteers you might need to be patient :)

## Screenshots

[<img src="https://gitlab.com/thgoebel/spartathlon/raw/master/screenshots/screenshot_dashboard.png" width=200>](https://gitlab.com/thgoebel/spartathlon/raw/master/screenshots/screenshot_dashboard.png)
[<img src="https://gitlab.com/thgoebel/spartathlon/raw/master/screenshots/screenshot_course.png" width=200>](https://gitlab.com/thgoebel/spartathlon/raw/master/screenshots/screenshot_course.png)
[<img src="https://gitlab.com/thgoebel/spartathlon/raw/master/screenshots/screenshot_athlete_list.png" width=200>](https://gitlab.com/thgoebel/spartathlon/raw/master/screenshots/screenshot_athlete_list.png)
[<img src="https://gitlab.com/thgoebel/spartathlon/raw/master/screenshots/screenshot_athlete_details.png" width=200>](https://gitlab.com/thgoebel/spartathlon/raw/master/screenshots/screenshot_athlete_details.png)

## Contributing

Here are some ways you can help to improve this app:
* Give feedback on what you like and what could be improved. Is there anything that could make your
  life as an athlete, supporter or volunteer easier? Tell us!
* Report bugs and errors
* Open merge requests with bug fixes, improvements or new features
* Translate the app into your local language

Note: to run the app in your dev environment, use `flutter run --flavor=play`

## About

Author: Thore Goebel

License: GNU General Public License v3 or later ([copy](https://gitlab.com/thgoebel/spartathlon/blob/master/LICENSE))