import 'dart:async';

import 'package:flutter/material.dart';
import 'package:intl/date_symbol_data_local.dart';
import 'package:intl/intl.dart';
import 'package:spartathlon_app/l10n/messages_all.dart';

class SpartaLocalizations {
  static Future<SpartaLocalizations> load(Locale locale) async {
    // Differentiate between "en_US" and just "en"
    final String name = locale.countryCode == null || locale.countryCode.isEmpty
        ? locale.languageCode
        : locale.toString();
    // Ensure right format, e.g. convert "en-US" to "en_US"
    final String localeName = Intl.canonicalizedLocale(name);

    await initializeMessages(localeName);
    await initializeDateFormatting(localeName);
    Intl.defaultLocale = localeName;
    return SpartaLocalizations();
  }

  static SpartaLocalizations of(BuildContext context) {
    return Localizations.of<SpartaLocalizations>(context, SpartaLocalizations);
  }

  //
  // All translatable strings below
  //

  // Main page

  String get sectionDashboard => Intl.message(
        'Dashboard',
        name: 'sectionDashboard',
        desc: 'Bottom navigation bar item',
      );

  String get sectionCourse => Intl.message(
        'Course',
        name: 'sectionCourse',
        desc: 'Bottom navigation bar item',
      );

  String get sectionResults => Intl.message(
        'Results',
        name: 'sectionResults',
        desc: 'Bottom navigation bar item',
      );

  String get sectionAthletes => Intl.message(
        'Athletes',
        name: 'sectionAthletes',
        desc: 'Bottom navigation bar item',
      );

  String get tooltipSettings => Intl.message(
        'Settings',
        name: 'tooltipSettings',
        desc: 'Tooltip for the IconButton that opens the settings page',
      );

  String get titleInfoBarNoNetworkConnection => Intl.message(
        'No network connection',
        name: 'titleInfoBarNoNetworkConnection',
        desc: 'Title for the yellow info bar that warns the user when no '
            'network connection is available. Must be short!',
      );

  String get labelButtonInfoBarNoNetworkConnection => Intl.message(
        'Refresh',
        name: 'labelButtonInfoBarNoNetworkConnection',
        desc: 'Label for the button in the no-network info bar allowing a '
            'user to refresh the app\'s state',
      );

  // Dashboard view

  String get errorDashboardNotLoaded => Intl.message(
        'Error loading dashboard:\nAre you connected to the Internet?',
        name: 'errorDashboardNotLoaded',
        desc: 'Shown when the dashboard could not be loaded',
      );

  // Blog full view

  String get menuActionOpenInBrowser => Intl.message(
        'Open in browser',
        name: 'menuActionOpenInBrowser',
        desc:
            'Item in the overflow menu allowing the user to open the blog post in a browser',
      );

  // Course view

  String get titleCheckpoints => Intl.message(
        'Checkpoints',
        name: 'titleCheckpoints',
        desc: 'Title displayed above the list of checkpoints',
      );

  String get labelButtonFilterCheckpoints => Intl.message(
        'Filter CPs',
        name: 'labelButtonFilterCheckpoints',
        desc: 'Label of the button that allows the user to filter the list of '
            'checkpoints by different criteria',
      );

  String get caseCpFilterAll => Intl.message(
        'All',
        name: 'caseCpFilterAll',
        desc: 'Filter option to display all checkpoints',
      );

  String get caseCpFilterSupporters => Intl.message(
        'Supporters',
        name: 'caseCpFilterSupporters',
        desc:
            'Filter option to display only checkpoints where supporters are allowed',
      );

  String get caseCpFilterLiveTiming => Intl.message(
        'Live timing',
        name: 'caseCpFilterLiveTiming',
        desc: 'Filter option to display only checkpoints that have live timing',
      );

  String get labelButtonRoute => Intl.message(
        'Route',
        name: 'labelButtonRoute',
        desc:
            'Label of the button that opens a maps application with the CP centered',
      );

  // Results view

  // Don't translate these strings yet, since they will - hopefully - be gone before a major public release anyway

  // Athletes view

  String get hintSearchBar => Intl.message(
        'Name, country, bib number',
        name: 'hintSearchBar',
        desc:
            'Hint in the search bar to tell the user that he can search by name, country or bib number',
      );

  String get tooltipClearSearch => Intl.message(
        'Clear search',
        name: 'tooltipClearSearch',
        desc: 'Tooltip for the IconButton that clears the current search',
      );

  String get errorAthletesNotLoaded => Intl.message(
        'Error loading athletes:\nAre you connected to the Internet?',
        name: 'errorAthletesNotLoaded',
        desc: 'Shown when the list of athletes could not be loaded',
      );

  String get errorNoAthleteSearchResult => Intl.message(
        'No athletes found',
        name: 'errorNoAthleteSearchResult',
        desc: 'Shown when the athlete search returned no result',
      );

  // Athlete details view

  String get errorAthleteDetailsNotLoaded => Intl.message(
        'Error loading athlete details:\nAre you connected to the Internet?',
        name: 'errorAthleteDetailsNotLoaded',
        desc: 'Shown when the details of an athlete could not be loaded',
      );

  String get titleCountry => Intl.message(
        'Country',
        name: 'titleCountry',
        desc: 'Title over the country where an athlete is from',
      );

  String get titleDateOfBirth => Intl.message(
        'Date of birth',
        name: 'titleDateOfBirth',
        desc: 'Title over the date of birth of an athlete',
      );

  String get titleLiveTiming => Intl.message(
        'Live timing',
        name: 'titleLiveTiming',
        desc: 'Title over the live timing result of an athlete',
      );

  String get titleBiography => Intl.message(
        'Biography',
        name: 'titleBiography',
        desc: 'Title over the biography section of an athlete',
      );

  String get titleFinishes => Intl.message(
        'Finishes',
        name: 'titleFinishes',
        desc: 'Title over the list of the finishes of an athlete',
      );

  String get headerFinishesListYear => Intl.message(
        'Year',
        name: 'headerFinishesListYear',
        desc:
            'Part of the header of the list of finishes in the athlete details',
      );

  String get headerFinishesListTime => Intl.message(
        'Time',
        name: 'headerFinishesListTime',
        desc:
            'Part of the header of the list of finishes in the athlete details',
      );

  String get headerFinishesListBibNr => Intl.message(
        'Bib Nr.',
        name: 'headerFinishesListBibNr',
        desc:
            'Part of the header of the list of finishes in the athlete details',
      );

  // Settings view

  String get appBarTitleSettings => Intl.message(
        'Settings',
        name: 'appBarTitleSettings',
        desc: 'Title of the settings page shown in the top app bar',
      );

  String get labelSettingDarkTheme => Intl.message(
        'Dark theme',
        name: 'labelSettingDarkTheme',
        desc: 'Label for the theme setting',
      );

  String get labelSettingDistanceUnit => Intl.message(
        'Distance unit',
        name: 'labelSettingDistanceUnit',
        desc: 'Label for the distance unit setting',
      );

  String get titlePopupDistanceUnitChooser => Intl.message(
        'Choose distance unit',
        name: 'titlePopupDistanceUnitChooser',
        desc:
            'Title of the popup that allows the user to choose the distance unit',
      );

  String get labelSettingClearCache => Intl.message(
        'Clear local cache',
        name: 'labelSettingClearCache',
        desc:
            'Title of the settings option that allows the user to clear the app\'s local cache',
      );

  String get hintSettingClearCache => Intl.message(
        'Useful if you are seeing outdated data',
        name: 'hintSettingClearCache',
        desc: 'Hint shown below the setting to clear the cache, telling the '
            'user that this might be useful if he sees outdated data',
      );

  String get snackbarTextCacheCleared => Intl.message(
        'Cache cleared',
        name: 'snackbarTextCacheCleared',
        desc:
            'Text of the snackbar informing the user that the cache has been cleared',
      );

  // About view

  String get appBarTitleAbout => Intl.message(
        'About',
        name: 'appBarTitleAbout',
        desc: 'Title of the about page shown in the top app bar',
      );

  String get titleAboutTheRace => Intl.message(
        'About the race',
        name: 'titleAboutTheRace',
        desc:
            'Title of the material card holding the information about the Spartathlon race',
      );

  String get titleAboutThisApp => Intl.message(
        'About this app',
        name: 'titleAboutThisApp',
        desc: 'Title of the material card holding information about this app',
      );

  String get textRaceDescription => Intl.message(
        'Described as the world\'s most grueling race, the Spartathlon runs over '
        'rough tracks and muddy paths (often it rains during the race), crosses '
        'vineyards and olive groves, climbs steep hillsides and, most '
        'challenging of all, takes the runners on the 1,200 meter ascent and '
        'descent of Mount Parthenio in the dead of night. This is the mountain, '
        'covered with rocks and bushes, on which it is said Pheidippides met '
        'the god Pan.\n\n'
        'Spartathlon is the event that brings this deed to attention today by '
        'drawing a legend out of the depths of history. The idea for its '
        'creation is belongs to John Foden, a British RAF Wing Commander. '
        'As a lover of Greece and student of ancient Greek history, Foden '
        'stopped his reading of Herodotus\' narration regarding Pheidippides, '
        'puzzled and wondering if a modern man could cover the distance from '
        'Athens to Sparta, i.e. 250 kms, within 36 hours. Spartathlon was born.',
        name: 'textRaceDescription',
        desc: 'Longer text describing the gist of the history of Spartathlon',
      );

  String get labelAboutWebsite => Intl.message(
        'Website',
        name: 'labelAboutWebsite',
        desc: 'Opens the Spartathlon website',
      );

  String get labelAboutVersion => Intl.message(
        'Version',
        name: 'labelAboutVersion',
        desc: 'Shows the current app version',
      );

  String get labelAboutAuthor => Intl.message(
        'Author',
        name: 'labelAboutAuthor',
        desc: 'Shows the app author',
      );

  String get labelAboutLicenses => Intl.message(
        'Licenses',
        name: 'labelAboutLicenses',
        desc: 'Shows the licenses for the app',
      );

  String get labelAboutPrivacyPolicy => Intl.message(
        'Privacy Policy',
        name: 'labelAboutPrivacyPolicy',
        desc: 'Opens the privacy policy',
      );

  String get labelAboutSourceCode => Intl.message(
        'Source code',
        name: 'labelAboutSourceCode',
        desc: 'Opens the GitLab page with the source of the app',
      );

  String get labelAboutChangelog => Intl.message(
        'Changelog',
        name: 'labelAboutChangelog',
        desc: 'Opens the changelog',
      );

  // Error view

  String get labelButtonRetry => Intl.message(
        'Retry',
        name: 'labelButtonRetry',
        desc:
            'Label of the button in the error view allowing the user to retry the failed operation',
      );

  // Distances

  String get distanceUnitKm => Intl.message(
        'km',
        name: 'distanceUnitKm',
        desc: 'Shorthand of the distance unit kilometers',
      );

  String get distanceUnitMiles => Intl.message(
        'miles',
        name: 'distanceUnitMiles',
        desc: 'Shorthand of the distance unit miles',
      );
}
