import 'package:flutter/material.dart';
import 'package:spartathlon_app/SpartaLocalizations.dart';

class SpartaLocalizationsDelegate
    extends LocalizationsDelegate<SpartaLocalizations> {
  const SpartaLocalizationsDelegate();

  @override
  bool isSupported(Locale locale) {
    return [
      'en',
      'de',
    ].contains(locale.languageCode);
  }

  @override
  Future<SpartaLocalizations> load(Locale locale) {
    return SpartaLocalizations.load(locale);
  }

  @override
  bool shouldReload(LocalizationsDelegate<SpartaLocalizations> old) => false;
}
