import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/rendering.dart';
import 'package:flutter_localizations/flutter_localizations.dart';
import 'package:spartathlon_app/AppStateContainer.dart';
import 'package:spartathlon_app/SpartaLocalizationsDelegate.dart';
import 'package:spartathlon_app/util/Themes.dart';
import 'package:spartathlon_app/views/MainPage.dart';

/// Main framework for Spartathlon app
void main() {
  debugPaintSizeEnabled = false;
  // AppStateContainer needs to be above the MaterialApp in order to be
  // available across routes. See:
  // https://stackoverflow.com/questions/49968817/flutter-inherited-widget-and-routes
  runApp(
    AppStateContainer(child: Main()),
  );
}

class Main extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return FutureBuilder<ThemeData>(
      future: AppStateContainer.of(context).loadTheme(),
      builder: (BuildContext context, AsyncSnapshot<ThemeData> snapshot) {
        if (snapshot.hasData) {
          print('(Re)building Material app...');

          return MaterialApp(
            title: 'Spartathlon',
            theme: snapshot.data,
            home: MainPage(),
            localizationsDelegates: [
              const SpartaLocalizationsDelegate(),
              GlobalMaterialLocalizations.delegate,
              GlobalWidgetsLocalizations.delegate,
            ],
            supportedLocales: [
              const Locale('en'),
              const Locale('de'),
            ],
          );
        } else {
          return Container(color: spartaBlue);
        }
      },
    );
  }
}
