import 'package:spartathlon_app/models/Athlete.dart';
import 'package:spartathlon_app/models/BlogEntry.dart';
import 'package:spartathlon_app/util/DistanceUnit.dart';

/// Hold state of the app, i.e. list of all athletes, all favorite athletes and
/// all blog entries.
class AppData {
  bool isLoading = true;
  bool hasError = false;
  bool hasConnection = true;
  DistanceUnit distanceUnit;

  List<BlogEntry> blogEntries = [];
  List<Athlete> athletes = [];
  List<Athlete> favoriteAthletes = [];

  AppData({this.blogEntries, this.athletes, this.favoriteAthletes});

  @override
  String toString() {
    return '### vvvvvvvv\nisLoading: ' +
        isLoading.toString() +
        '\nhasError: ' +
        hasError.toString() +
        '\nblogEntries: ' +
        blogEntries.toString() +
        '\nomitting athletes and favorite athletes' +
        '\n### ^^^^^^^^^\n';
  }
}
