import 'package:spartathlon_app/providers/AthleteProvider.dart';

/// Athlete Model
class Athlete extends Comparable<Athlete> {
  final String id;
  final String name;
  String nation;
  String dateOfBirth;
  final String imageUrl;
  String biography;
  List<Finish> finishes;
  int bibNumber;
  String lastSeenTime;
  int lastSeenCp;

  Athlete(
      {this.id,
      this.name,
      this.nation,
      this.dateOfBirth,
      this.imageUrl,
      this.biography,
      this.finishes,
      this.bibNumber,
      this.lastSeenTime,
      this.lastSeenCp});

  factory Athlete.fromJSON(Map<String, dynamic> json) {
    List<Finish> finishes = List<Finish>();

    /// When created in [getAthletes] the following fields will be null:
    /// dateOfBirth, biography, finishes
    /// since the API only returns them on a more detailed call.
    ///
    /// For efficiency reasons, we only do so in [getFullAthleteDetails] when
    /// the user explicitly opens the details for an athlete.
    return Athlete(
      id: json['atid'].toString(),
      name: (json['firstname'] + ' ' + json['surname'])
          .trim(), // Remove whitespaces
      nation: json['country'],
      dateOfBirth: json['birthdate'],
      imageUrl:
          'https://spartathlon.gr/en/races/races.html?task=athlete.getImage&id=' +
              json['atid'],
      biography: json['minicv'],
      finishes: finishes,
      bibNumber: int.parse(json['number']),
      lastSeenTime: json['datetime'],
      // API starts at 1 leading to Sparta being CP 76. We do 0-indexing.
      lastSeenCp: (json['cpid'] != null) ? (int.parse(json['cpid']) - 1) : 0,
    );
  }

  @override
  int compareTo(Athlete other) {
    return name.toLowerCase().compareTo(other.name.toLowerCase());
  }

  Future<bool> isFavorite() async {
    List<String> favIds = await AthleteProvider.getFavoriteAthleteIds();
    return favIds.contains(id);
  }
}

class Finish {
  final String year;
  final String bib;
  final String time;
  // TODO Maybe add a field for a place/position

  Finish({this.year, this.bib, this.time});
}
