/// Checkpoint (aka CP) Model
class Cp {
  final int id;
  final String name;
  final double fromStart; // in km
  final double toNext; // in km
  final double toFinish; // in km
  final String openingTime;
  final String closingTime;
  final bool liveTiming;
  final bool supporterAllowed;
  final bool firstAid;
  final double long;
  final double lat;
  final String supplies;
  final String description;

  /// Creates a new CP.
  ///
  /// Distances [fromStart], [toNext] and [toFinish] must be given in kilometer
  Cp({
    this.id,
    this.name,
    this.fromStart,
    this.toFinish,
    this.toNext,
    this.openingTime,
    this.closingTime,
    this.liveTiming,
    this.supporterAllowed,
    this.firstAid,
    this.long,
    this.lat,
    this.supplies,
    this.description,
  });
}
