/// Checkpoint Data in JSON Format.
/// Last updated: 2019-02-10
///
/// To convert CSV to JSON see:
/// http://blog.secaserver.com/2013/12/convert-csv-json-bash/
/// https://csvjson.com/csv2json

var checkpoints = [
  {
    "id": 0,
    "name": "Athens, Foot Of Acropolis",
    "fromStart": 0,
    "toNext": 3.9,
    "toFinish": 246.8,
    "openingTime": "06:00:00",
    "closingTime": "07:00:00",
    "liveTiming": "yes",
    "supporterAllowed": "yes",
    "firstAid": "no",
    "lat": 37.9704931158919,
    "long": 23.7230284064273,
    "alt": 15.2,
    "supplies": "None",
    "description": "Starting line"
  },
  {
    "id": 1,
    "name": "Iera Odos 94",
    "fromStart": 3.9,
    "toNext": 5.4,
    "toFinish": 242.9,
    "openingTime": "06:55:00",
    "closingTime": "07:30:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.987222,
    "long": 23.695631,
    "alt": 0,
    "supplies": "Water",
    "description": "Station on the right, Traffic Lights"
  },
  {
    "id": 2,
    "name": "Dafni",
    "fromStart": 9.3,
    "toNext": 4.5,
    "toFinish": 237.5,
    "openingTime": "07:15:00",
    "closingTime": "08:05:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 38.010673,
    "long": 23.644258,
    "alt": 0,
    "supplies": "Water",
    "description":
        "Small park on the right, before right turn to the main road."
  },
  {
    "id": 3,
    "name": "Skaramangas",
    "fromStart": 13.8,
    "toNext": 5.7,
    "toFinish": 233,
    "openingTime": "07:30:00",
    "closingTime": "08:35:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 38.018829,
    "long": 23.599159,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts)",
    "description": "Small metal shrines. Military camp exit"
  },
  {
    "id": 4,
    "name": "Aspropyrgos",
    "fromStart": 19.5,
    "toNext": 3.2,
    "toFinish": 227.3,
    "openingTime": "07:45:00",
    "closingTime": "09:10:00",
    "liveTiming": "yes",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 38.047505,
    "long": 23.551384,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts)",
    "description": "Right. Junction towards the old National Road"
  },
  {
    "id": 5,
    "name": "Elefsina",
    "fromStart": 22.7,
    "toNext": 2.3,
    "toFinish": 224.1,
    "openingTime": "08:10:00",
    "closingTime": "09:30:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 38.049829,
    "long": 23.526108,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts)",
    "description": "Town exit, left on square. AEGEAN gas station on the right"
  },
  {
    "id": 6,
    "name": "Ellinika Petrele",
    "fromStart": 25,
    "toNext": 4.2,
    "toFinish": 221.8,
    "openingTime": "08:25:00",
    "closingTime": "09:45:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 38.039997,
    "long": 23.50334,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts)",
    "description": "Left at the tree near the entrance."
  },
  {
    "id": 7,
    "name": "Loutropyrgos",
    "fromStart": 29.2,
    "toNext": 3,
    "toFinish": 217.6,
    "openingTime": "08:35:00",
    "closingTime": "10:15:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 38.026046,
    "long": 23.470401,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts)",
    "description": "Hotel ‘AKTI’"
  },
  {
    "id": 8,
    "name": "Nea Peramos",
    "fromStart": 32.2,
    "toNext": 3.1,
    "toFinish": 214.6,
    "openingTime": "08:50:00",
    "closingTime": "10:35:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 38.0163081379129,
    "long": 23.4427026829063,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Isotonic",
    "description": "Building No. 686. Opposite JETOIL gas station."
  },
  {
    "id": 9,
    "name": "Nea Peramos",
    "fromStart": 35.3,
    "toNext": 3.5,
    "toFinish": 211.5,
    "openingTime": "09:10:00",
    "closingTime": "10:55:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.999919,
    "long": 23.414917,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts)",
    "description": "School on the left. Opposite Barbounis’ EKO gas station"
  },
  {
    "id": 10,
    "name": "Megara",
    "fromStart": 38.8,
    "toNext": 3.4,
    "toFinish": 208,
    "openingTime": "09:25:00",
    "closingTime": "11:20:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.999485,
    "long": 23.376236,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts)",
    "description":
        "Big eucalyptus tree on the left. 300 m. approx. after the railway lines"
  },
  {
    "id": 11,
    "name": "Megara",
    "fromStart": 42.2,
    "toNext": 3.5,
    "toFinish": 204.6,
    "openingTime": "09:40:00",
    "closingTime": "11:45:00",
    "liveTiming": "yes",
    "supporterAllowed": "yes",
    "firstAid": "no",
    "lat": 37.98805,
    "long": 23.346919,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Isotonic",
    "description": "Left before the Weight bridge. Across BP gas station"
  },
  {
    "id": 12,
    "name": "Prokat",
    "fromStart": 45.7,
    "toNext": 3.1,
    "toFinish": 201.1,
    "openingTime": "09:50:00",
    "closingTime": "12:10:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.9765357014756,
    "long": 23.3169360670046,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts)",
    "description":
        "Concrete space on the right across PROKAT 200m after the railway lines"
  },
  {
    "id": 13,
    "name": "Hotel Kokkinis",
    "fromStart": 48.8,
    "toNext": 2.4,
    "toFinish": 198,
    "openingTime": "10:00:00",
    "closingTime": "12:30:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.975673,
    "long": 23.284982,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts)",
    "description": "Entrance on the left of road"
  },
  {
    "id": 14,
    "name": "Next To Shrine",
    "fromStart": 51.2,
    "toNext": 3.5,
    "toFinish": 195.6,
    "openingTime": "10:15:00",
    "closingTime": "12:45:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.9774230715486,
    "long": 23.2645985266436,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Isotonic",
    "description": "Left small opening with a pine tree and shrine"
  },
  {
    "id": 15,
    "name": "Kinetta, Zorbas Tavern",
    "fromStart": 54.7,
    "toNext": 3,
    "toFinish": 192.1,
    "openingTime": "10:25:00",
    "closingTime": "13:10:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.971874,
    "long": 23.222751,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts)",
    "description": "Tavern on the left. Opposite the sign of 55 km."
  },
  {
    "id": 16,
    "name": "Kinetta",
    "fromStart": 57.7,
    "toNext": 3.2,
    "toFinish": 189.1,
    "openingTime": "10:35:00",
    "closingTime": "13:30:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.959049,
    "long": 23.197174,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) +  Yogurt",
    "description":
        "Stone bench on the left, Bus stop. Junction with Saronikos street"
  },
  {
    "id": 17,
    "name": "Hotel Siagas",
    "fromStart": 60.9,
    "toNext": 4.2,
    "toFinish": 185.9,
    "openingTime": "10:55:00",
    "closingTime": "13:55:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.946746,
    "long": 23.161574,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Isotonic",
    "description": "entrance on the left."
  },
  {
    "id": 18,
    "name": "Agioi Theodori",
    "fromStart": 65.1,
    "toNext": 4.7,
    "toFinish": 181.7,
    "openingTime": "11:15:00",
    "closingTime": "14:25:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.925572,
    "long": 23.134524,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts)",
    "description": "Open space on the left. 200m. before the bus stop"
  },
  {
    "id": 19,
    "name": "Motor Oil Refinery",
    "fromStart": 69.8,
    "toNext": 4.2,
    "toFinish": 177,
    "openingTime": "11:20:00",
    "closingTime": "15:00:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.919469,
    "long": 23.076554,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Isotonic + Yogurt",
    "description": "MOTOR OIL Refinery"
  },
  {
    "id": 20,
    "name": "Kerafina Factory",
    "fromStart": 74,
    "toNext": 3.5,
    "toFinish": 172.8,
    "openingTime": "11:30:00",
    "closingTime": "15:35:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.92074706887,
    "long": 23.0298926877205,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts)",
    "description": "″KERAFINA ″ Factory"
  },
  {
    "id": 21,
    "name": "Corinth Canal",
    "fromStart": 77.5,
    "toNext": 2.5,
    "toFinish": 169.3,
    "openingTime": "11:40:00",
    "closingTime": "16:10:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.9266686209964,
    "long": 22.9966456201358,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts)",
    "description":
        "Left, before the footbridge. Open space in front of the BP Gas station"
  },
  {
    "id": 22,
    "name": "Hellas Can Factory",
    "fromStart": 80,
    "toNext": 3.4,
    "toFinish": 166.8,
    "openingTime": "11:45:00",
    "closingTime": "16:30:00",
    "liveTiming": "yes",
    "supporterAllowed": "yes",
    "firstAid": "yes",
    "lat": 37.9256008893813,
    "long": 22.9744357049109,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Isotonic + Yogurt + Light Meal",
    "description":
        "Major Control and Reporting Point, Supplies / Communication & Medical Attendance"
  },
  {
    "id": 23,
    "name": "Papafili Mills Factory",
    "fromStart": 83.4,
    "toNext": 4.3,
    "toFinish": 163.4,
    "openingTime": "12:30:00",
    "closingTime": "17:00:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.9083972176692,
    "long": 22.9714833024033,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts)",
    "description": "Left, in front of ″PAPAFILI MILLS″ factory"
  },
  {
    "id": 24,
    "name": "Examilia",
    "fromStart": 87.7,
    "toNext": 3.3,
    "toFinish": 159.1,
    "openingTime": "12:45:00",
    "closingTime": "17:35:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.8971683453253,
    "long": 22.9324642658948,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Yogurt",
    "description": "Coffee-shop on the left"
  },
  {
    "id": 25,
    "name": "Road Junction",
    "fromStart": 91,
    "toNext": 2,
    "toFinish": 155.8,
    "openingTime": "13:05:00",
    "closingTime": "18:05:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.8964697917073,
    "long": 22.8980312045558,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Isotonic",
    "description":
        "Junction with National Rd. CORINTH TRIPOLIS. On the right after the traffic lights"
  },
  {
    "id": 26,
    "name": "Ancient Corinth",
    "fromStart": 93,
    "toNext": 4.1,
    "toFinish": 153.8,
    "openingTime": "13:15:00",
    "closingTime": "18:25:00",
    "liveTiming": "no",
    "supporterAllowed": "yes",
    "firstAid": "no",
    "lat": 37.90696979841,
    "long": 22.8825025471,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Yogurt",
    "description": "Main square."
  },
  {
    "id": 27,
    "name": "Mrs Screech’s Villa",
    "fromStart": 97.1,
    "toNext": 3,
    "toFinish": 149.7,
    "openingTime": "13:30:00",
    "closingTime": "19:00:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.9202367224435,
    "long": 22.8457472848941,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts)",
    "description": "Mrs SCREECH’S VILLA (The serpents’ villa)"
  },
  {
    "id": 28,
    "name": "Assos",
    "fromStart": 100.1,
    "toNext": 2,
    "toFinish": 146.7,
    "openingTime": "13:50:00",
    "closingTime": "19:25:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.937468612076,
    "long": 22.8210534363016,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Isotonic + Yogurt",
    "description": "ASSOS. Coffee Shop on the right"
  },
  {
    "id": 29,
    "name": "Zevgolatio (Corinth Area)",
    "fromStart": 102.1,
    "toNext": 3.8,
    "toFinish": 144.7,
    "openingTime": "14:00:00",
    "closingTime": "19:45:00",
    "liveTiming": "no",
    "supporterAllowed": "yes",
    "firstAid": "no",
    "lat": 37.9400518031338,
    "long": 22.8027633284321,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description": "At the square corner, Church."
  },
  {
    "id": 30,
    "name": "Small Church",
    "fromStart": 105.9,
    "toNext": 3.9,
    "toFinish": 140.9,
    "openingTime": "14:05:00",
    "closingTime": "20:20:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.9236310387127,
    "long": 22.7706174752265,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description": "Church on the right. Water-spring"
  },
  {
    "id": 31,
    "name": "Soulinari",
    "fromStart": 109.8,
    "toNext": 3.1,
    "toFinish": 137,
    "openingTime": "14:30:00",
    "closingTime": "20:55:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.895215863232,
    "long": 22.7450157816969,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup + Yogurt",
    "description": "Coffee Shop on the left, at a right turn"
  },
  {
    "id": 32,
    "name": "Halkion",
    "fromStart": 112.9,
    "toNext": 3.9,
    "toFinish": 133.9,
    "openingTime": "14:45:00",
    "closingTime": "21:25:00",
    "liveTiming": "no",
    "supporterAllowed": "yes",
    "firstAid": "no",
    "lat": 37.8817067486656,
    "long": 22.7269498223667,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description": "BP Gas Station on the right"
  },
  {
    "id": 33,
    "name": "Farm Houses",
    "fromStart": 116.8,
    "toNext": 3.4,
    "toFinish": 130,
    "openingTime": "15:05:00",
    "closingTime": "22:00:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.8708183569954,
    "long": 22.7098622595378,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description": "Big tree on the right. 2 farm houses left & right."
  },
  {
    "id": 34,
    "name": "Roadside",
    "fromStart": 120.2,
    "toNext": 3.1,
    "toFinish": 126.6,
    "openingTime": "15:20:00",
    "closingTime": "22:35:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.858457398691,
    "long": 22.7059087595043,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description": "Small shrine on the left"
  },
  {
    "id": 35,
    "name": "Ancient Nemea",
    "fromStart": 123.3,
    "toNext": 4.1,
    "toFinish": 123.5,
    "openingTime": "15:30:00",
    "closingTime": "23:00:00",
    "liveTiming": "yes",
    "supporterAllowed": "yes",
    "firstAid": "yes",
    "lat": 37.8077842942904,
    "long": 22.7067095712146,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Isotonic + Yogurt + Light Meal",
    "description":
        "Square of St. Andrew’s Church. Major Control and Reporting Point, Supplies / Communication & Medical Attendance"
  },
  {
    "id": 36,
    "name": "Oasis Restaurant",
    "fromStart": 127.4,
    "toNext": 2,
    "toFinish": 119.4,
    "openingTime": "16:30:00",
    "closingTime": "23:40:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.8104899968972,
    "long": 22.6741955195919,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description": "Parking of OASIS RESTAURANT on the left."
  },
  {
    "id": 37,
    "name": "Church on the right",
    "fromStart": 129.4,
    "toNext": 3.2,
    "toFinish": 117.4,
    "openingTime": "16:50:00",
    "closingTime": "00:00:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.7941018089694,
    "long": 22.6704319995458,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description":
        "Church on the right. Beginning of V junction. Runners to the right"
  },
  {
    "id": 38,
    "name": "Road Junction",
    "fromStart": 132.6,
    "toNext": 3,
    "toFinish": 114.2,
    "openingTime": "16:50:00",
    "closingTime": "00:35:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.76710784907,
    "long": 22.6544178223468,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Isotonic + Tea + Soup",
    "description":
        "Road junction, before the underground Crossing of the National road."
  },
  {
    "id": 39,
    "name": "Roadside",
    "fromStart": 135.6,
    "toNext": 4.2,
    "toFinish": 111.2,
    "openingTime": "17:10:00",
    "closingTime": "01:10:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.7505049063957,
    "long": 22.6481004984697,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description": "Small shrine on the right. Road sign towards MALANDRENI"
  },
  {
    "id": 40,
    "name": "Malandreni",
    "fromStart": 139.8,
    "toNext": 3.3,
    "toFinish": 107,
    "openingTime": "17:30:00",
    "closingTime": "01:50:00",
    "liveTiming": "no",
    "supporterAllowed": "yes",
    "firstAid": "no",
    "lat": 37.7269036519978,
    "long": 22.6417067080399,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Isotonic + Tea + Soup",
    "description": "MALANDRENI VILLAGE Mr.DEDES’ Tavern. Main Square"
  },
  {
    "id": 41,
    "name": "Roadside (Τ Junction)",
    "fromStart": 143.1,
    "toNext": 2.7,
    "toFinish": 103.7,
    "openingTime": "17:45:00",
    "closingTime": "02:20:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.7198657029261,
    "long": 22.6104951944632,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description": "Τ JUNCTION WITH MAIN ROAD TO LYRKIA. CAUTION: Right Turn."
  },
  {
    "id": 42,
    "name": "Roadside",
    "fromStart": 145.8,
    "toNext": 2.5,
    "toFinish": 101,
    "openingTime": "18:00:00",
    "closingTime": "02:45:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.7184714345037,
    "long": 22.5904800359282,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description": "Road Sign : ″TO LYRKIA″"
  },
  {
    "id": 43,
    "name": "Lyrkia",
    "fromStart": 148.3,
    "toNext": 3,
    "toFinish": 98.5,
    "openingTime": "18:05:00",
    "closingTime": "03:10:00",
    "liveTiming": "yes",
    "supporterAllowed": "yes",
    "firstAid": "yes",
    "lat": 37.6862663842963,
    "long": 22.5426650360862,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Isotonic + Tea + Light Meal",
    "description":
        "Right at Mr. Perivolari’s Coffee-Shop, Major Control and Reporting Point, Supplies / Communication & Medical Attendance"
  },
  {
    "id": 44,
    "name": "Roadside",
    "fromStart": 151.3,
    "toNext": 2.6,
    "toFinish": 95.5,
    "openingTime": "18:45:00",
    "closingTime": "03:40:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.6862663842963,
    "long": 22.5426650360862,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description": "On the left small opening space, next to a water stream"
  },
  {
    "id": 45,
    "name": "Kapareli",
    "fromStart": 153.9,
    "toNext": 3.5,
    "toFinish": 92.9,
    "openingTime": "19:15:00",
    "closingTime": "04:10:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.6768548550542,
    "long": 22.5094610081085,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Isotonic + Tea + Soup",
    "description": "Shop in the center of the village"
  },
  {
    "id": 46,
    "name": "Roadside (U-Turn)",
    "fromStart": 157.4,
    "toNext": 2.1,
    "toFinish": 89.4,
    "openingTime": "19:35:00",
    "closingTime": "04:45:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.6814082670004,
    "long": 22.4930776789617,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description":
        "Open space on the right at a U - turn of the road after a small water stream"
  },
  {
    "id": 47,
    "name": "Mountain Base",
    "fromStart": 159.5,
    "toNext": 2.3,
    "toFinish": 87.3,
    "openingTime": "19:40:00",
    "closingTime": "05:10:00",
    "liveTiming": "yes",
    "supporterAllowed": "yes",
    "firstAid": "no",
    "lat": 37.6728971559958,
    "long": 22.4845276223643,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Isotonic + Tea + Soup + Light Meal",
    "description": "Check point at the parking on the left. Wood Gazebo."
  },
  {
    "id": 48,
    "name": "Mountain Top",
    "fromStart": 161.8,
    "toNext": 2.7,
    "toFinish": 85,
    "openingTime": "19:50:00",
    "closingTime": "05:50:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.6698617858093,
    "long": 22.4752229170488,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description": "MOUNTAIN TOP"
  },
  {
    "id": 49,
    "name": "Sangas (Village)",
    "fromStart": 164.5,
    "toNext": 2.5,
    "toFinish": 82.3,
    "openingTime": "20:00:00",
    "closingTime": "06:25:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.6706553334646,
    "long": 22.4594785665647,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Isotonic +Tea + Soup",
    "description": "in the village center"
  },
  {
    "id": 50,
    "name": "Roadside",
    "fromStart": 167,
    "toNext": 2.8,
    "toFinish": 79.8,
    "openingTime": "20:20:00",
    "closingTime": "06:50:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.6488047468339,
    "long": 22.4645309671653,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description": "Gas depot on the left"
  },
  {
    "id": 51,
    "name": "Roadside",
    "fromStart": 169.8,
    "toNext": 1.7,
    "toFinish": 77,
    "openingTime": "20:45:00",
    "closingTime": "07:15:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.626367240761,
    "long": 22.4683898696191,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description": "BRIDGE over the National road, Turn left Wood Gazebo"
  },
  {
    "id": 52,
    "name": "Nestani",
    "fromStart": 171.5,
    "toNext": 4,
    "toFinish": 75.3,
    "openingTime": "20:50:00",
    "closingTime": "07:30:00",
    "liveTiming": "yes",
    "supporterAllowed": "yes",
    "firstAid": "yes",
    "lat": 37.613756654889,
    "long": 22.4660824106294,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Isotonic + Tea + Soup + Light Meal",
    "description":
        "Main Village Square. Major Control and Reporting Point, Supplies / Communication & Medical Attendance"
  },
  {
    "id": 53,
    "name": "Roadside (crossroads)",
    "fromStart": 175.5,
    "toNext": 2,
    "toFinish": 71.3,
    "openingTime": "21:30:00",
    "closingTime": "08:05:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.5937535502532,
    "long": 22.4295223343272,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description":
        "X-ROADS Vitina-National Road Tripolis and Nestani-Sagas. C/P on the right"
  },
  {
    "id": 54,
    "name": "Ghiosa Tavern",
    "fromStart": 177.5,
    "toNext": 1.3,
    "toFinish": 69.3,
    "openingTime": "22:00:00",
    "closingTime": "08:25:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.5805156545913,
    "long": 22.418291378249,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description":
        "At the road-junction Tripolis- Louka. C/P on the right of left turn"
  },
  {
    "id": 55,
    "name": "Roadside (underpass)",
    "fromStart": 178.8,
    "toNext": 4.7,
    "toFinish": 68,
    "openingTime": "22:20:00",
    "closingTime": "08:40:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.5779487088084,
    "long": 22.4313254564662,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Isotonic +Tea + Soup",
    "description":
        "UNDERGROUNG PASSAGE to Loukas village. Caution : right turn."
  },
  {
    "id": 56,
    "name": "Roadside",
    "fromStart": 183.5,
    "toNext": 2.6,
    "toFinish": 63.3,
    "openingTime": "22:50:00",
    "closingTime": "09:20:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.5386157236175,
    "long": 22.4335942928612,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description":
        "Kiosk, shrine on the left. On the right there is a road sign: PELAGOS-PARORI"
  },
  {
    "id": 57,
    "name": "Zevgolatio (Arcadia Area)",
    "fromStart": 186.1,
    "toNext": 3.2,
    "toFinish": 60.7,
    "openingTime": "23:00:00",
    "closingTime": "09:45:00",
    "liveTiming": "no",
    "supporterAllowed": "yes",
    "firstAid": "no",
    "lat": 37.5186253529252,
    "long": 22.4411326807928,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Isotonic + Tea + Soup",
    "description": "Main square."
  },
  {
    "id": 58,
    "name": "Roadside (T Junction)",
    "fromStart": 189.3,
    "toNext": 2.5,
    "toFinish": 57.5,
    "openingTime": "23:20:00",
    "closingTime": "10:15:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.496436933668,
    "long": 22.4525691801399,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description":
        "T JUNCTION with the main road from ARGOS to TRIPOLIS. Caution: RIGHT TURN TOWARDS TRIPOLIS and then LEFT TURN at 200 m. LEFT"
  },
  {
    "id": 59,
    "name": "Small farmhouse",
    "fromStart": 191.8,
    "toNext": 3.5,
    "toFinish": 55,
    "openingTime": "23:30:00",
    "closingTime": "11:10:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.4846980711613,
    "long": 22.4401248756662,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description": "Small farmhouse and big tree (right)"
  },
  {
    "id": 60,
    "name": "Alea Tegea",
    "fromStart": 195.3,
    "toNext": 3.3,
    "toFinish": 51.5,
    "openingTime": "23:40:00",
    "closingTime": "11:10:00",
    "liveTiming": "yes",
    "supporterAllowed": "yes",
    "firstAid": "yes",
    "lat": 37.4539442510298,
    "long": 22.4207622307094,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Isotonic + Tea + Soup + Light Meal",
    "description": "ALEA – TEGEA Main Square."
  },
  {
    "id": 61,
    "name": "BP Gas Station",
    "fromStart": 198.6,
    "toNext": 3.7,
    "toFinish": 48.2,
    "openingTime": "00:15:00",
    "closingTime": "11:40:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.4281682466598,
    "long": 22.4099772585235,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description": "BP Gas station on the left of the National road to SPARTA"
  },
  {
    "id": 62,
    "name": "Manthyrea",
    "fromStart": 202.3,
    "toNext": 4.1,
    "toFinish": 44.5,
    "openingTime": "00:45:00",
    "closingTime": "12:15:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.4037342893139,
    "long": 22.4017893816078,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description": "Open space on the left, after the village Wood Gazebo"
  },
  {
    "id": 63,
    "name": "Papandonis Restaurant",
    "fromStart": 206.4,
    "toNext": 3.5,
    "toFinish": 40.4,
    "openingTime": "01:15:00",
    "closingTime": "12:55:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.3671732589203,
    "long": 22.4004042168273,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Isotonic + Tea + Soup + Yogurt",
    "description": "PAPANDONIS restaurant AVIN gas station on the left"
  },
  {
    "id": 64,
    "name": "St Nicolaos Church",
    "fromStart": 209.9,
    "toNext": 2.4,
    "toFinish": 36.9,
    "openingTime": "01:35:00",
    "closingTime": "13:25:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.3448347861606,
    "long": 22.4141500581586,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description":
        "St Nicolaos Church on the left, Shop with traditional local products"
  },
  {
    "id": 65,
    "name": "Ardamis Restaurant",
    "fromStart": 212.3,
    "toNext": 3.4,
    "toFinish": 34.5,
    "openingTime": "01:50:00",
    "closingTime": "13:45:00",
    "liveTiming": "no",
    "supporterAllowed": "yes",
    "firstAid": "no",
    "lat": 37.3268951698001,
    "long": 22.4258284928476,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description": "ARDAMIS restaurant, parking space on the left. Wood Gazebo"
  },
  {
    "id": 66,
    "name": "Roadside",
    "fromStart": 215.7,
    "toNext": 6.5,
    "toFinish": 31.1,
    "openingTime": "02:15:00",
    "closingTime": "14:15:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.2977801130256,
    "long": 22.4182709148956,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description":
        "Open space on the left of the National road. Small shrine opposite."
  },
  {
    "id": 67,
    "name": "Roadside (bus stop)",
    "fromStart": 222.2,
    "toNext": 1.2,
    "toFinish": 24.6,
    "openingTime": "02:40:00",
    "closingTime": "14:55:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.2613966418217,
    "long": 22.4380451884721,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description": "BUS STOP on the left. Junction to Karyes/Varvitsa/Vamvakou"
  },
  {
    "id": 68,
    "name": "Roadside",
    "fromStart": 223.4,
    "toNext": 3.3,
    "toFinish": 23.4,
    "openingTime": "03:05:00",
    "closingTime": "15:25:00",
    "liveTiming": "no",
    "supporterAllowed": "yes",
    "firstAid": "yes",
    "lat": 37.2383624948214,
    "long": 22.4358698099629,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Isotonic+ Yogurt + Sandwich",
    "description": "C/P on the right in the parking area. Wood Gazebo."
  },
  {
    "id": 69,
    "name": "Roadside",
    "fromStart": 226.7,
    "toNext": 4.7,
    "toFinish": 20.1,
    "openingTime": "03:30:00",
    "closingTime": "16:00:00",
    "liveTiming": "yes",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.2195476383414,
    "long": 22.4241453316826,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description": "Modern house with arches, on the right Wood Gazebo"
  },
  {
    "id": 70,
    "name": "Road side",
    "fromStart": 231.4,
    "toNext": 2.1,
    "toFinish": 15.4,
    "openingTime": "04:00:00",
    "closingTime": "16:40:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.1818608107893,
    "long": 22.4297922197552,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description":
        "Open space on the left with a stone made faucet. Wood Gazebo Road sign To Skopeftirio"
  },
  {
    "id": 71,
    "name": "Mustard Colored House",
    "fromStart": 233.5,
    "toNext": 3.1,
    "toFinish": 13.3,
    "openingTime": "04:20:00",
    "closingTime": "17:00:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.1648479786954,
    "long": 22.4293471842471,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Isotonic +Tea + Soup",
    "description": "Two store mustard color house, on the left."
  },
  {
    "id": 72,
    "name": "Voutianoi, Shell Gas Station",
    "fromStart": 236.6,
    "toNext": 4.7,
    "toFinish": 10.2,
    "openingTime": "04:45:00",
    "closingTime": "17:25:00",
    "liveTiming": "no",
    "supporterAllowed": "yes",
    "firstAid": "no",
    "lat": 37.1476725224713,
    "long": 22.4367068024868,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description": "VOUTIANOI. SHELL gas station on the left."
  },
  {
    "id": 73,
    "name": "Kladas",
    "fromStart": 241.3,
    "toNext": 3.1,
    "toFinish": 5.5,
    "openingTime": "05:15:00",
    "closingTime": "18:05:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.1103828605971,
    "long": 22.4331663402706,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Isotonic +Tea + Soup",
    "description":
        "KLADAS. Open space on the left with a tree, opposite restaurant \" OASIS "
  },
  {
    "id": 74,
    "name": "Evrotas Bridge",
    "fromStart": 244.4,
    "toNext": 2.4,
    "toFinish": 2.4,
    "openingTime": "05:30:00",
    "closingTime": "18:30:00",
    "liveTiming": "no",
    "supporterAllowed": "no",
    "firstAid": "no",
    "lat": 37.0859365085067,
    "long": 22.432049255411,
    "alt": 0,
    "supplies":
        "Basics (Water, Coca Cola, Juice, Currants, Sesame, Fruits, Bread, Biscuits, Milk, Coffee, Potato Chips, Rusks, Chocolate, Sugar, Honey, Figs, Nuts) + Tea + Soup",
    "description":
        "AT THE EVROTAS RIVER BRIDGE. 100 m after the bridge on the right."
  },
  {
    "id": 75,
    "name": "Sparta, Statue of Leonidas",
    "fromStart": 246.8,
    "toNext": 0,
    "toFinish": 0,
    "openingTime": "05:35:00",
    "closingTime": "19:00:00",
    "liveTiming": "yes",
    "supporterAllowed": "yes",
    "firstAid": "yes",
    "lat": 37.07786799424,
    "long": 22.4309368406571,
    "alt": 0,
    "supplies": "Trophies!",
    "description": "Sparta, Statue of Leonidas"
  }
];
