import 'dart:async';

import 'package:flutter_cache_manager/flutter_cache_manager.dart';
import 'package:path/path.dart' as p;
import 'package:path_provider/path_provider.dart';

import 'package:spartathlon_app/util/RaceTiming.dart';

const String BASE_URL_API_ISA =
    'https://www.spartathlon.gr/en/?option=com_ajax&plugin=spartathlon&format=json&action=';

/// Cache manager for all athlete data related network requests
class AthleteCacheManager extends BaseCacheManager {
  static const key = 'spartaAthleteCache';

  static AthleteCacheManager _instance;

  factory AthleteCacheManager() {
    if (_instance == null) {
      _instance = AthleteCacheManager._();
    }
    return _instance;
  }

  AthleteCacheManager._() // Private, named constructor
      : super(
          key,
          maxAgeCacheObject: _getAthleteCacheMaxAge(),
        );

  Future<String> getFilePath() async {
    var directory = await getTemporaryDirectory();
    return p.join(directory.path, key);
  }

  /// Shorten maximum cache age during the race when we want more regular updates
  // TODO This only seems to apply for the time the object was created but when it was last touched
  static Duration _getAthleteCacheMaxAge() {
    if (isRaceOn()) {
      return Duration(hours: 1);
    } else {
      return Duration(days: 7);
    }
  }
}

/// Cache manager for all blog data related network requests
class BlogCacheManager extends BaseCacheManager {
  static const key = 'spartaBlogCache';

  static BlogCacheManager _instance;

  factory BlogCacheManager() {
    if (_instance == null) {
      _instance = BlogCacheManager._();
    }
    return _instance;
  }

  BlogCacheManager._() // Private, name constructor
      : super(
          key,
          maxAgeCacheObject: _getBlogCacheMaxAge(),
        );

  Future<String> getFilePath() async {
    var directory = await getTemporaryDirectory();
    return p.join(directory.path, key);
  }

  /// Shorten maximum cache age shortly after the race, when more blog posts are expected
  // TODO This only seems to apply for the time the object was created but when it was last touched
  static Duration _getBlogCacheMaxAge() {
    if (isTwoWeeksAfterRace()) {
      return Duration(hours: 6);
    } else {
      return Duration(days: 7);
    }
  }
}
