import 'package:connectivity/connectivity.dart';
import 'package:url_launcher/url_launcher.dart';

/// Corner radius for cards, dialogs, etc
const double cardCornerRadius = 8.0;

/// Corner radius for Material buttons
const double buttonCornerRadius = 4.0;

/// The height of the bottom navigation bar
const double kBottomNavBarHeight = 136.0;

/// The height of a LicenseTile in the licenses dialog
const double kLicenseTileHeight = 72.0;

/// The height of the yellow notice bar warning about no network connection
const double kNoNetworkBarHeight = 40.0;

/// The default blur radius for shadows
const double kShadowBlurRadius = 4.0;

/// Launches an URL (like http, geo, etc) in any application the device provides
launchUrl(String url) async {
  if (await canLaunch(url)) {
    await launch(url);
  } else {
    throw 'Could not launch $url';
  }
}

/// Returns whether or not the device is connected to a network
Future<bool> hasConnectivity() async {
  var connResult = await Connectivity().checkConnectivity();
  bool hasConn = (connResult == ConnectivityResult.none) ? false : true;
  return hasConn;
}
