import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/material.dart';
import 'package:flutter_html/flutter_html.dart';
import 'package:spartathlon_app/SpartaLocalizations.dart';
import 'package:spartathlon_app/models/BlogEntry.dart';
import 'package:spartathlon_app/util/Utils.dart';

/// Blog Details View
///
/// Displays a blog entry (race report) with the header image at the top, followed by the report itself.

class BlogFullView extends StatefulWidget {
  BlogFullView({Key key, this.item}) : super(key: key);
  final BlogEntry item;

  @override
  _BlogFullViewState createState() => _BlogFullViewState();
}

class _BlogFullViewState extends State<BlogFullView> {
  ScrollController _scrollController;
  double kExpandedHeight;

  @override
  void initState() {
    super.initState();
    _scrollController = ScrollController()..addListener(() => setState(() {}));
    kExpandedHeight = 1;
  }

  bool isCollapsed() {
    return _scrollController.hasClients &&
        _scrollController.offset > kExpandedHeight - 1.7 * kToolbarHeight;
  }

  @override
  Widget build(BuildContext context) {
    kExpandedHeight = MediaQuery.of(context).size.height / 2;
    double width = MediaQuery.of(context).size.width;

    return CustomScrollView(
      controller: _scrollController,
      slivers: [
        SliverAppBar(
          backgroundColor: Theme.of(context).primaryColor,
          expandedHeight: kExpandedHeight,
          floating: false,
          pinned: true,
          actions: [
            PopupMenuButton(
              itemBuilder: (BuildContext context) {
                return [
                  PopupMenuItem(
                    child: Container(
                      child: Text(
                        SpartaLocalizations.of(context).menuActionOpenInBrowser,
                      ),
                    ),
                    value: widget.item.url,
                  )
                ];
              },
              onSelected: (String url) => launchUrl(url),
            )
          ],
          flexibleSpace: FlexibleSpaceBar(
              // TODO align title text to the far left
              // tracked in https://github.com/flutter/flutter/issues/11951
              title: ConstrainedBox(
                constraints:
                    BoxConstraints(maxWidth: width - 190, maxHeight: 36.0),
                child: Text(
                  widget.item.headline,
                  overflow: TextOverflow.visible,
                ),
              ),
              titlePadding: isCollapsed() // align to the far left if expanded
                  ? EdgeInsets.only(bottom: 16.0, left: 56.0)
                  : EdgeInsets.only(bottom: 16.0, left: 16.0),
              background: Stack(
                fit: StackFit.expand,
                children: [
                  CachedNetworkImage(
                    imageUrl: widget.item.imageUrl,
                    fit: BoxFit.cover,
                    alignment: Alignment(0, 0.5),
                  ),
                ],
              )),
        ),
        SliverToBoxAdapter(
          child: Material(
            child: Container(
              color: Theme.of(context).scaffoldBackgroundColor,
              padding: EdgeInsets.all(12.0),
              child: Html(
                data: widget.item.fullText,
                backgroundColor: Theme.of(context).scaffoldBackgroundColor,
              ),
            ),
          ),
        ),
      ],
    );
  }
}
