import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:outline_material_icons/outline_material_icons.dart';
import 'package:spartathlon_app/AppStateContainer.dart';
import 'package:spartathlon_app/SpartaLocalizations.dart';
import 'package:spartathlon_app/util/Themes.dart';
import 'package:spartathlon_app/util/Utils.dart';
import 'package:spartathlon_app/views/AthletesView.dart';
import 'package:spartathlon_app/views/CourseView.dart';
import 'package:spartathlon_app/views/ResultsView.dart';
import 'package:spartathlon_app/views/SettingsView.dart';
import 'package:spartathlon_app/views/dashboard/DashboardView.dart';

/// Main view for Spartathlon app
///
/// 'Main' contains the broad frame the app is set it: the top and bottom app bar.
/// It enables switching between the four major screens.

class MainPage extends StatefulWidget {
  MainPage({Key key}) : super(key: key);

  @override
  MainPageState createState() => MainPageState();
}

class MainPageState extends State<MainPage> {
  int _currentIndex = 0;

  @override
  Widget build(BuildContext context) {
    List<BottomNavigationBarItem> navBarIcons = List(4);

    navBarIcons[0] = BottomNavigationBarItem(
      icon: Icon(OMIcons.dashboard),
      title: Text(SpartaLocalizations.of(context).sectionDashboard),
      backgroundColor: Theme.of(context).primaryColor,
    );
    navBarIcons[1] = BottomNavigationBarItem(
      icon: Icon(OMIcons.nearMe),
      title: Text(SpartaLocalizations.of(context).sectionCourse),
      backgroundColor: Theme.of(context).primaryColor,
    );
    navBarIcons[2] = BottomNavigationBarItem(
      icon: Icon(OMIcons.insertChart),
      title: Text(SpartaLocalizations.of(context).sectionResults),
      backgroundColor: Theme.of(context).primaryColor,
    );
    navBarIcons[3] = BottomNavigationBarItem(
      icon: Icon(OMIcons.directionsRun),
      title: Text(SpartaLocalizations.of(context).sectionAthletes),
      backgroundColor: Theme.of(context).primaryColor,
    );

    return Scaffold(
      appBar: AppBar(
        title: Text('Spartathlon'),
        backgroundColor: Theme.of(context).primaryColor,
        actions: [
          IconButton(
              icon: Icon(OMIcons.settings),
              tooltip: SpartaLocalizations.of(context).tooltipSettings,
              onPressed: () {
                Navigator.push(context,
                    CupertinoPageRoute(builder: (context) => SettingsView()));
              }),
        ],
      ),
      bottomNavigationBar: BottomNavigationBar(
        items: navBarIcons,
        currentIndex: _currentIndex,
        onTap: _onTabTapped,
      ),
      body: _getBody(AppStateContainer.of(context).data.hasConnection),
    );
  }

  _onTabTapped(int index) {
    setState(() {
      _currentIndex = index;
    });
  }

  Widget _getBody(bool hasConnection) {
    if (hasConnection) {
      return _getCentralPage(_currentIndex);
    } else {
      return Stack(
        children: [
          Container(
            padding: EdgeInsets.only(top: kNoNetworkBarHeight),
            height: MediaQuery.of(context).size.height - kBottomNavBarHeight,
            child: _getCentralPage(_currentIndex),
          ),
          Container(
            padding: EdgeInsets.only(left: 16.0, right: 2.0),
            height: kNoNetworkBarHeight,
            decoration: BoxDecoration(
              color: spartaYellowDark,
              boxShadow: [
                BoxShadow(blurRadius: kShadowBlurRadius, color: Colors.black45)
              ],
            ),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Text(
                  SpartaLocalizations.of(context)
                      .titleInfoBarNoNetworkConnection,
                  style: TextStyle(color: Colors.black),
                ),
                InkWell(
                  child: FlatButton(
                    shape: RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(cardCornerRadius)),
                    onPressed: () =>
                        AppStateContainer.of(context).loadData(false),
                    child: Text(
                      SpartaLocalizations.of(context)
                          .labelButtonInfoBarNoNetworkConnection
                          .toUpperCase(),
                      style: TextStyle(color: Colors.black),
                    ),
                  ),
                ),
              ],
            ),
          ),
        ],
      );
    }
  }

  Widget _getCentralPage(int i) {
    switch (i) {
      case 0:
        return DashboardView();
      case 1:
        return CourseView();
      case 2:
        return ResultsView();
      case 3:
        return AthletesView();
      default:
        return DashboardView();
    }
  }
}
