import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

import 'package:spartathlon_app/util/Utils.dart';

/// Results view
///
/// Once completed, this view displays the live results of the race and - if the
/// API is improved - also the results from past years' races.

class ResultsView extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    // TODO use webview
    return Column(
      crossAxisAlignment: CrossAxisAlignment.center,
      children: [
        Spacer(),
        Flex(
          direction: Axis.vertical,
          children: [
            Container(
              padding: EdgeInsets.only(bottom: 4.0, right: 12.0, left: 12.0),
              child: Text(
                'Unfortunately, browsing old results is not yet available.\n\n\n'
                'BUT: live results will be shown for each athlete during the race.\n',
                textAlign: TextAlign.center,
              ),
            ),
            RaisedButton.icon(
              icon: Icon(Icons.launch),
              label: Text('Open Results in Browser'),
              color: Theme.of(context).primaryColor,
              textColor: Colors.white,
              shape: RoundedRectangleBorder(
                borderRadius: BorderRadius.circular(buttonCornerRadius),
              ),
              onPressed: () => launchUrl(
                  'https://spartathlon.gr/en/races/race-results-en.html'),
            ),
          ],
        ),
        Spacer(),
        Stack(
          children: [
            Container(
              width: MediaQuery.of(context).size.width,
              padding: EdgeInsets.all(8.0),
              decoration: BoxDecoration(
                  border: Border(
                top: BorderSide(
                    width: 1.0, color: Theme.of(context).dividerColor),
              )),
              child: GestureDetector(
                onTap: () =>
                    launchUrl('https://gitlab.com/thgoebel/spartathlon'),
                child: Text(
                    'If you know how to code and want to help us with bringing the race results to this app, tap here to reach out.'),
              ),
            ),
            Positioned.fill(
              child: Material(
                type: MaterialType.transparency,
                child: InkWell(
                  onTap: () => launchUrl(
                      'https://gitlab.com/thgoebel/spartathlon/issues/4'),
                ),
              ),
            ),
          ],
        ),
      ],
    );
  }
}
