import 'package:flutter/material.dart';

import 'package:flutter_sticky_header/flutter_sticky_header.dart';
import 'package:outline_material_icons/outline_material_icons.dart';

import 'package:spartathlon_app/models/BlogEntry.dart';
import 'package:spartathlon_app/widgets/BlogEntryCard.dart';
import 'package:spartathlon_app/widgets/IconListDivider.dart';

class BlogList extends StatelessWidget {
  final List<BlogEntry> blogEntries;

  const BlogList({Key key, this.blogEntries}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    if (blogEntries.isEmpty) return SliverToBoxAdapter(child: Container());

    return SliverStickyHeaderBuilder(
      builder: (_, state) => IconListDivider(state, Icon(OMIcons.message)),
      sliver: SliverList(
        delegate: SliverChildBuilderDelegate(
          (_, index) => BlogEntryCard(blogEntries[index]),
          childCount: blogEntries.length,
        ),
      ),
    );
  }
}
