import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:spartathlon_app/SpartaLocalizations.dart';
import 'package:spartathlon_app/util/Utils.dart';

class ErrorView extends StatelessWidget {
  final Function onRetry;
  final String text;

  const ErrorView({Key key, this.onRetry, this.text}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        backgroundColor: Theme.of(context).scaffoldBackgroundColor,
        body: Center(
          child: Container(
            constraints: BoxConstraints.tight(Size.fromHeight(120.0)),
            padding: EdgeInsets.all(8.0),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.spaceEvenly,
              children: [
                Text(text),
                MaterialButton(
                  color: Theme.of(context).primaryColor,
                  textColor: Colors.white,
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(buttonCornerRadius),
                  ),
                  onPressed: onRetry,
                  child: Text(SpartaLocalizations.of(context).labelButtonRetry),
                ),
              ],
            ),
          ),
        ));
  }
}
