import 'package:flutter/material.dart';
import 'package:test/test.dart';

import 'package:spartathlon_app/util/Themes.dart';

void main(){
  // The order is important because the index values are used for storage
  // in SharedPreferences.
  // Thus if the order is changed across versions, it will mess up users' settings
  group('enum order', (){
    test('light theme', (){
      expect(AppTheme.values[0], AppTheme.THEME_LIGHT);
    });
    test('dark theme', (){
      expect(AppTheme.values[1], AppTheme.THEME_DARK);
    });
  });

  group('function_getThemeData', (){
    test('light theme has light brightness', (){
      ThemeData themeData = getThemeData(AppTheme.THEME_LIGHT);
      expect(themeData.brightness, Brightness.light);
    });
    test('dark theme has dark brightness', (){
      ThemeData themeData = getThemeData(AppTheme.THEME_DARK);
      expect(themeData.brightness, Brightness.dark);
    });
  });
}