var aFunction = require('../internals/a-function');
var toObject = require('../internals/to-object');
var IndexedObject = require('../internals/indexed-object');
var toLength = require('../internals/to-length');

// `Array.prototype.{ reduce, reduceRight }` methods implementation
// https://tc39.github.io/ecma262/#sec-array.prototype.reduce
// https://tc39.github.io/ecma262/#sec-array.prototype.reduceright
module.exports = function (that, callbackfn, argumentsLength, memo, isRight) {
  aFunction(callbackfn);
  var O = toObject(that);
  var self = IndexedObject(O);
  var length = toLength(O.length);
  var index = isRight ? length - 1 : 0;
  var i = isRight ? -1 : 1;
  if (argumentsLength < 2) while (true) {
    if (index in self) {
      memo = self[index];
      index += i;
      break;
    }
    index += i;
    if (isRight ? index < 0 : length <= index) {
      throw TypeError('Reduce of empty array with no initial value');
    }
  }
  for (;isRight ? index >= 0 : length > index; index += i) if (index in self) {
    memo = callbackfn(memo, self[index], index, O);
  }
  return memo;
};
