'use strict';
var fails = require('../internals/fails');

var prototype = Date.prototype;
var getTime = prototype.getTime;
var nativeDateToISOString = prototype.toISOString;

var leadingZero = function (number) {
  return number > 9 ? number : '0' + number;
};

// `Date.prototype.toISOString` method implementation
// https://tc39.github.io/ecma262/#sec-date.prototype.toisostring
// PhantomJS / old WebKit fails here:
module.exports = (fails(function () {
  return nativeDateToISOString.call(new Date(-5e13 - 1)) != '0385-07-25T07:06:39.999Z';
}) || !fails(function () {
  nativeDateToISOString.call(new Date(NaN));
})) ? function toISOString() {
  if (!isFinite(getTime.call(this))) throw RangeError('Invalid time value');
  var date = this;
  var year = date.getUTCFullYear();
  var milliseconds = date.getUTCMilliseconds();
  var sign = year < 0 ? '-' : year > 9999 ? '+' : '';
  return sign + ('00000' + Math.abs(year)).slice(sign ? -6 : -4) +
    '-' + leadingZero(date.getUTCMonth() + 1) +
    '-' + leadingZero(date.getUTCDate()) +
    'T' + leadingZero(date.getUTCHours()) +
    ':' + leadingZero(date.getUTCMinutes()) +
    ':' + leadingZero(date.getUTCSeconds()) +
    '.' + (milliseconds > 99 ? milliseconds : '0' + leadingZero(milliseconds)) +
    'Z';
} : nativeDateToISOString;
