var DESCRIPTORS = require('../internals/descriptors');
var objectKeys = require('../internals/object-keys');
var toIndexedObject = require('../internals/to-indexed-object');
var propertyIsEnumerable = require('../internals/object-property-is-enumerable').f;

// TO_ENTRIES: true  -> Object.entries
// TO_ENTRIES: false -> Object.values
module.exports = function (it, TO_ENTRIES) {
  var O = toIndexedObject(it);
  var keys = objectKeys(O);
  var length = keys.length;
  var i = 0;
  var result = [];
  var key;
  while (length > i) {
    key = keys[i++];
    if (!DESCRIPTORS || propertyIsEnumerable.call(O, key)) {
      result.push(TO_ENTRIES ? [key, O[key]] : O[key]);
    }
  }
  return result;
};
