'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function() {
  function sliceIterator(arr, i) {
    var _arr = [];
    var _n = true;
    var _d = false;
    var _e = undefined;
    try {
      for (
        var _i = arr[Symbol.iterator](), _s;
        !(_n = (_s = _i.next()).done);
        _n = true
      ) {
        _arr.push(_s.value);
        if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;
      _e = err;
    } finally {
      try {
        if (!_n && _i['return']) _i['return']();
      } finally {
        if (_d) throw _e;
      }
    }
    return _arr;
  }
  return function(arr, i) {
    if (Array.isArray(arr)) {
      return arr;
    } else if (Symbol.iterator in Object(arr)) {
      return sliceIterator(arr, i);
    } else {
      throw new TypeError(
        'Invalid attempt to destructure non-iterable instance'
      );
    }
  };
})();
/**
 * Copyright (c) 2014-present, Facebook, Inc. All rights reserved.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 */

var _fast_path;

function _load_fast_path() {
  return (_fast_path = _interopRequireWildcard(require('./lib/fast_path')));
}

var _constants;

function _load_constants() {
  return (_constants = _interopRequireDefault(require('./constants')));
}

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {default: obj};
}

function _interopRequireWildcard(obj) {
  if (obj && obj.__esModule) {
    return obj;
  } else {
    var newObj = {};
    if (obj != null) {
      for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key))
          newObj[key] = obj[key];
      }
    }
    newObj.default = obj;
    return newObj;
  }
}

const EMPTY_OBJ = {};
const EMPTY_MAP = new Map();

class ModuleMap {
  constructor(raw) {
    this._raw = raw;
  }

  getModule(name, platform, supportsNativePlatform, type) {
    if (!type) {
      type = (_constants || _load_constants()).default.MODULE;
    }
    const module = this._getModuleMetadata(
      name,
      platform,
      !!supportsNativePlatform
    );
    if (
      module &&
      module[(_constants || _load_constants()).default.TYPE] === type
    ) {
      const modulePath = module[(_constants || _load_constants()).default.PATH];
      return (
        modulePath &&
        (_fast_path || _load_fast_path()).resolve(this._raw.rootDir, modulePath)
      );
    }
    return null;
  }

  getPackage(name, platform, supportsNativePlatform) {
    return this.getModule(
      name,
      platform,
      null,
      (_constants || _load_constants()).default.PACKAGE
    );
  }

  getMockModule(name) {
    const mockPath =
      this._raw.mocks.get(name) || this._raw.mocks.get(name + '/index');
    return (
      mockPath &&
      (_fast_path || _load_fast_path()).resolve(this._raw.rootDir, mockPath)
    );
  }

  getRawModuleMap() {
    return {
      duplicates: this._raw.duplicates,
      map: this._raw.map,
      mocks: this._raw.mocks,
      rootDir: this._raw.rootDir
    };
  }

  toJSON() {
    return {
      duplicates: Array.from(this._raw.duplicates),
      map: Array.from(this._raw.map),
      mocks: Array.from(this._raw.mocks),
      rootDir: this._raw.rootDir
    };
  }

  static fromJSON(serializableModuleMap) {
    return new ModuleMap({
      duplicates: new Map(serializableModuleMap.duplicates),
      map: new Map(serializableModuleMap.map),
      mocks: new Map(serializableModuleMap.mocks),
      rootDir: serializableModuleMap.rootDir
    });
  }

  /**
   * When looking up a module's data, we walk through each eligible platform for
   * the query. For each platform, we want to check if there are known
   * duplicates for that name+platform pair. The duplication logic normally
   * removes elements from the `map` object, but we want to check upfront to be
   * extra sure. If metadata exists both in the `duplicates` object and the
   * `map`, this would be a bug.
   */
  _getModuleMetadata(name, platform, supportsNativePlatform) {
    const map = this._raw.map.get(name) || EMPTY_OBJ;
    const dupMap = this._raw.duplicates.get(name) || EMPTY_MAP;
    if (platform != null) {
      this._assertNoDuplicates(
        name,
        platform,
        supportsNativePlatform,
        dupMap.get(platform)
      );
      if (map[platform] != null) {
        return map[platform];
      }
    }
    if (supportsNativePlatform) {
      this._assertNoDuplicates(
        name,
        (_constants || _load_constants()).default.NATIVE_PLATFORM,
        supportsNativePlatform,
        dupMap.get((_constants || _load_constants()).default.NATIVE_PLATFORM)
      );
      if (map[(_constants || _load_constants()).default.NATIVE_PLATFORM]) {
        return map[(_constants || _load_constants()).default.NATIVE_PLATFORM];
      }
    }
    this._assertNoDuplicates(
      name,
      (_constants || _load_constants()).default.GENERIC_PLATFORM,
      supportsNativePlatform,
      dupMap.get((_constants || _load_constants()).default.GENERIC_PLATFORM)
    );
    if (map[(_constants || _load_constants()).default.GENERIC_PLATFORM]) {
      return map[(_constants || _load_constants()).default.GENERIC_PLATFORM];
    }
    return null;
  }

  _assertNoDuplicates(name, platform, supportsNativePlatform, relativePathSet) {
    if (relativePathSet == null) {
      return;
    }
    // Force flow refinement
    const previousSet = relativePathSet;
    const duplicates = new Map();

    for (const _ref of previousSet) {
      var _ref2 = _slicedToArray(_ref, 2);

      const relativePath = _ref2[0];
      const type = _ref2[1];

      const duplicatePath = (_fast_path || _load_fast_path()).resolve(
        this._raw.rootDir,
        relativePath
      );
      duplicates.set(duplicatePath, type);
    }

    throw new DuplicateHasteCandidatesError(
      name,
      platform,
      supportsNativePlatform,
      duplicates
    );
  }

  static create(rootDir) {
    return new ModuleMap({
      duplicates: new Map(),
      map: new Map(),
      mocks: new Map(),
      rootDir: rootDir
    });
  }
}

exports.default = ModuleMap;
class DuplicateHasteCandidatesError extends Error {
  constructor(name, platform, supportsNativePlatform, duplicatesSet) {
    const platformMessage = getPlatformMessage(platform);
    super(
      `The name \`${name}\` was looked up in the Haste module map. It ` +
        `cannot be resolved, because there exists several different ` +
        `files, or packages, that provide a module for ` +
        `that particular name and platform. ${platformMessage} You must ` +
        `delete or blacklist files until there remains only one of these:\n\n` +
        Array.from(duplicatesSet)
          .map(_ref3 => {
            var _ref4 = _slicedToArray(_ref3, 2);

            let dupFilePath = _ref4[0],
              dupFileType = _ref4[1];
            return `  * \`${dupFilePath}\` (${getTypeMessage(dupFileType)})\n`;
          })
          .sort()
          .join('')
    );
    this.hasteName = name;
    this.platform = platform;
    this.supportsNativePlatform = supportsNativePlatform;
    this.duplicatesSet = duplicatesSet;
  }
}

function getPlatformMessage(platform) {
  if (platform === (_constants || _load_constants()).default.GENERIC_PLATFORM) {
    return 'The platform is generic (no extension).';
  }
  return `The platform extension is \`${platform}\`.`;
}

function getTypeMessage(type) {
  switch (type) {
    case (_constants || _load_constants()).default.MODULE:
      return 'module';
    case (_constants || _load_constants()).default.PACKAGE:
      return 'package';
  }
  return 'unknown';
}

ModuleMap.DuplicateHasteCandidatesError = DuplicateHasteCandidatesError;
