var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

import * as React from 'react';
import { BottomNavigation } from 'react-native-paper';
import { createTabNavigator } from 'react-navigation-tabs';

class BottomNavigationView extends React.Component {
  constructor(...args) {
    var _temp;

    return _temp = super(...args), this._getColor = ({ route }) => {
      var { descriptors } = this.props;
      var descriptor = descriptors[route.key];
      var options = descriptor.options;

      return options.tabBarColor;
    }, this._renderIcon = ({ route, focused, color }) => {
      return this.props.renderIcon({ route, focused, tintColor: color });
    }, _temp;
  }

  _isVisible() {
    var { navigation, descriptors } = this.props;
    var { state } = navigation;
    var route = state.routes[state.index];
    var options = descriptors[route.key].options;
    return options.tabBarVisible;
  }

  render() {
    var _props = this.props,
        {
      activeTintColor,
      inactiveTintColor,
      navigation,
      // eslint-disable-next-line no-unused-vars
      descriptors,
      barStyle
    } = _props,
        rest = _objectWithoutProperties(_props, ['activeTintColor', 'inactiveTintColor', 'navigation', 'descriptors', 'barStyle']);

    var isVisible = this._isVisible();
    var extraStyle = typeof isVisible === 'boolean' ? { display: isVisible ? null : 'none' } : null;

    return React.createElement(BottomNavigation
    // Pass these for backward compaibility
    , _extends({ activeColor: activeTintColor,
      inactiveColor: inactiveTintColor
    }, rest, {
      renderIcon: this._renderIcon,
      barStyle: [barStyle, extraStyle],
      navigationState: navigation.state,
      getColor: this._getColor
    }));
  }
}

export default createTabNavigator(BottomNavigationView);