import _objectSpread from"@babel/runtime/helpers/objectSpread";import shallowEqual from'../utils/shallowEqual';var SCENE_KEY_PREFIX='scene_';function compareKey(one,two){var delta=one.length-two.length;if(delta>0){return 1;}if(delta<0){return-1;}return one>two?1:-1;}function compareScenes(one,two){if(one.index>two.index){return 1;}if(one.index<two.index){return-1;}return compareKey(one.key,two.key);}function areScenesShallowEqual(one,two){return one.key===two.key&&one.index===two.index&&one.isStale===two.isStale&&one.isActive===two.isActive&&areRoutesShallowEqual(one.route,two.route);}function areRoutesShallowEqual(one,two){if(!one||!two){return one===two;}if(one.key!==two.key){return false;}return shallowEqual(one,two);}export default function ScenesReducer(scenes,nextState,prevState,descriptors){scenes.forEach(function(scene){var route=scene.route;if(descriptors&&descriptors[route.key]){scene.descriptor=descriptors[route.key];}});if(prevState===nextState){return scenes;}var prevScenes=new Map();var freshScenes=new Map();var staleScenes=new Map();scenes.forEach(function(scene){var key=scene.key;if(scene.isStale){staleScenes.set(key,scene);}prevScenes.set(key,scene);});var nextKeys=new Set();var nextRoutes=nextState.routes;if(nextRoutes.length>nextState.index+1){console.warn('StackRouter provided invalid state, index should always be the top route');nextRoutes=nextState.routes.slice(0,nextState.index+1);}nextRoutes.forEach(function(route,index){var key=SCENE_KEY_PREFIX+route.key;var descriptor=descriptors&&descriptors[route.key];var scene={index:index,isActive:false,isStale:false,key:key,route:route,descriptor:descriptor};if(nextKeys.has(key)){throw new Error("navigation.state.routes["+index+"].key \""+key+"\" conflicts with "+'another route!');}nextKeys.add(key);if(staleScenes.has(key)){staleScenes.delete(key);}freshScenes.set(key,scene);});if(prevState){var prevRoutes=prevState.routes;if(prevRoutes.length>prevState.index+1){console.warn('StackRouter provided invalid state, index should always be the top route');prevRoutes=prevRoutes.slice(0,prevState.index+1);}prevRoutes.forEach(function(route,index){var key=SCENE_KEY_PREFIX+route.key;if(freshScenes.has(key)){return;}var lastScene=scenes.find(function(scene){return scene.route.key===route.key;});var descriptor=lastScene?lastScene.descriptor:descriptors[route.key];if(descriptor){staleScenes.set(key,{index:index,isActive:false,isStale:true,key:key,route:route,descriptor:descriptor});}});}var nextScenes=[];var mergeScene=function mergeScene(nextScene){var key=nextScene.key;var prevScene=prevScenes.has(key)?prevScenes.get(key):null;if(prevScene&&areScenesShallowEqual(prevScene,nextScene)){nextScenes.push(prevScene);}else{nextScenes.push(nextScene);}};staleScenes.forEach(mergeScene);freshScenes.forEach(mergeScene);nextScenes.sort(compareScenes);var activeScenesCount=0;nextScenes.forEach(function(scene,ii){var isActive=!scene.isStale&&scene.index===nextState.index;if(isActive!==scene.isActive){nextScenes[ii]=_objectSpread({},scene,{isActive:isActive});}if(isActive){activeScenesCount++;}});if(activeScenesCount!==1){throw new Error("There should always be only one scene active, not "+activeScenesCount+".");}if(nextScenes.length!==scenes.length){return nextScenes;}if(nextScenes.some(function(scene,index){return!areScenesShallowEqual(scenes[index],scene);})){return nextScenes;}return scenes;}
//# sourceMappingURL=ScenesReducer.js.map