/*
 * Copyright 2019 Uriah Shaul Mandel
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.bald.uriah.baldphone.views;

import android.content.Context;
import android.inputmethodservice.Keyboard;
import android.inputmethodservice.KeyboardView;
import android.os.Build;
import android.util.AttributeSet;

import androidx.annotation.RequiresApi;

public class BaldKeyboardView extends KeyboardView {

    public invokePressListener invokePressListener;

    public BaldKeyboardView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BaldKeyboardView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    public BaldKeyboardView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected boolean onLongPress(Keyboard.Key popupKey) {
        if (invokePressListener != null) {
            invokePressListener.onKey(popupKey.codes[popupKey.codes.length - 1], popupKey.codes);

            return true;
        }
        return false;

    }

    interface invokePressListener {
        void onKey(int primaryCode, int[] keyCodes);
    }
}