package com.drhoffmannsoftware;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.Date;

import android.content.Intent;
import android.os.Bundle;
import android.os.Environment;
import android.webkit.WebView;
import android.widget.TextView;
import android.text.Editable;
import android.text.Html;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RadioGroup.OnCheckedChangeListener;
import android.widget.Toast;
//import android.widget.ScrollView;
import android.widget.Button;


public class TBProgrammActivity extends MyActivity {
	private static final String TAG = "TSCH_BYL";
	public static int level=0;
	private static double al=-1;  /*Luftaktivitaet*/
	private static double dschmrem=-1;
	private static double dinh=-1;  /*Inhalierte Dosis*/
	private static double dinhsch=-1;  /*Inhalierte SchilddruesenDosis*/
	private static double tage=-1;  /*Tage bis Regen*/
	private static double bl=-1;  /*Bodenbelastung*/
	private static double milch=-1;  /*Belastung Nahrung*/
	private static double salat=-1;
	private static double dess,s5,dlmrem;
	private static double dbjahr=-1;
	private static double dbjahrw=-1;
	private static double dges,d50,dges650,dges65050;
	private static double faktor=-1;
	private static double auto,flug,zig,krp,gen,dfilter,d10f,rhein;
	private static double nbel=-1; /*Nahrungsbelastung */
	private static int qs=0,dys=0; /*mit niedrigeren Werten rechnen*/
    private static String Ergebnistabelle;
	private TextView btitel;
	private TextView btext1,btext1b,btext2,btext3;
	private String[] text1,titel;
	private Button weiterbutton,fertig,next;
	private EditText eingabe,eingabe2;
	private RadioGroup radio;
	private RadioButton radio0,radio1;
	private WebView webview;
	//private ScrollView scrollview;
	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.beispiel1);
        weiterbutton=(Button) findViewById(R.id.weiterbutton);
        fertig=      (Button) findViewById(R.id.fertig); 
        next=        (Button) findViewById(R.id.next);
        weiterbutton.setEnabled(false);
        
        
        eingabe=  (EditText) findViewById(R.id.editText1);
        eingabe2= (EditText) findViewById(R.id.editText2);
        radio=    (RadioGroup)findViewById(R.id.radioGroup1);
        radio0=   (RadioButton) findViewById(R.id.radio0);
        radio1=   (RadioButton) findViewById(R.id.radio1);
        btitel=   (TextView) findViewById(R.id.btitel);
        webview=  (WebView) findViewById(R.id.webView1);
//        scrollview=(ScrollView) findViewById(R.id.scroll);
        btext1=(TextView) findViewById(R.id.btext1);
        btext1b=(TextView) findViewById(R.id.btext1b);
        btext2=(TextView) findViewById(R.id.btext2);
        btext3=(TextView) findViewById(R.id.btext3);
        btext2.setVisibility(View.INVISIBLE);
        btext3.setVisibility(View.INVISIBLE);
        titel = getResources().getStringArray(R.array.programmtitel);
        text1 = getResources().getStringArray(R.array.programmtext1);
        

        /*Titel der Seite setzen*/
        btitel.setText(titel[level]); 
        
        /*Themen-Info der Seite setzen*/
        if(level==0 || level==9) btext1.setText(Html.fromHtml(text1[level]));
        else if(level==1) btext1.setText(Html.fromHtml("Die Luftbelastung für Ihr Gebiet beträgt "+al+" Bq/Kubikmeter. <p/>"+text1[level]));
        else if(level==2) btext1.setText(Html.fromHtml("Nach dem Regen sollte die Bodenbelastung ca. "+bl+" Bq/Quadratmeter sein.<p/>"+text1[level]));
        	
        /*Vorbereitungen je nach level*/

        if(level==2 || level==5 || level==6|| level==9) {
        	radio0.setText("Ja");radio1.setText("Nein");
        	if(level==2) radio.check(R.id.radio0);
        	else radio.check(R.id.radio1);
        	if(level==2) {
        		radio.setOnCheckedChangeListener(new OnCheckedChangeListener(){
        			public void onCheckedChanged(RadioGroup group, int checkedId) {
        				if(checkedId==R.id.radio1) {
        					weiterbutton.setEnabled(true);
        					eingabe.setEnabled(false);
        				} else eingabe.setEnabled(true);
        			}
        		});
        	} else if(level==5) {
        		radio.setOnCheckedChangeListener(new OnCheckedChangeListener(){
 				public void onCheckedChanged(RadioGroup group, int checkedId) {	
					if(checkedId==R.id.radio1) {
						weiterbutton.setEnabled(true);
						eingabe2.setEnabled(false);
						btext1b.setText("");
						qs=0;
					} else {
						eingabe2.setEnabled(true);
						eingabe2.setVisibility(View.VISIBLE);
						btext1b.setText(getResources().getString(R.string.fragenahrungbelastet));
						qs=1;
					}
				}	
        	});
        	} else if(level==9) {
        		/* TODO */
        		radio.setOnCheckedChangeListener(new OnCheckedChangeListener(){
     				public void onCheckedChanged(RadioGroup group, int checkedId) {	
    					if(checkedId==R.id.radio1) {
    						
    						btext1b.setText("");
    					} else {
    						savedata(Ergebnistabelle);
    						btext1b.setText("gespeichert. Sie finden die Datei im Ordner Android/TSCH_BYL/.");
/* Direkt als email verschicken .....
    						Intent i = new Intent(Intent.ACTION_SEND);
    						i.putExtra(android.content.Intent.EXTRA_EMAIL, new String[]{ "a","b" });
    						i.putExtra(android.content.Intent.EXTRA_SUBJECT, "Ergebnisse von TSCH_BYL");
    						i.putExtra(android.content.Intent.EXTRA_TEXT, Ergebnistabelle);
    						
    						startActivity(Intent.createChooser(i, "Send email"));
    					*/
    					
    					
    					
    					}
    				}	
            	});
        		
        	}
        } else radio.setVisibility(View.GONE);
        
        
        if(level!=5 && level!=9) btext1b.setVisibility(View.GONE);
        
        if(level!=5) eingabe2.setVisibility(View.GONE);
        if(level!=0 && level!=1 && level!=2) eingabe.setVisibility(View.GONE);
        if(level!=0 && level!=1 && level!=2 &&  level!=5 && level!=6) weiterbutton.setVisibility(View.GONE);
        
        if(level!=8) webview.setVisibility(View.GONE);
        
        if(level!=3 && level!=4 && level!=7 && level!=8) next.setEnabled(false);
        if(level>=9) next.setVisibility(View.GONE);
        
        if(level==3)  {
        	String t;
        	double db;
        	
        	db=java.lang.Math.floor(bl/10000.0/1000.0*1000.0)/1000.0;
        	dbjahr=java.lang.Math.floor(bl/1000.0*1000.0)/1000.0;
        	dbjahrw=java.lang.Math.floor(dbjahr/30.0*10)/10.0;
        	t="Wenn Sie ständig auf einer Wiese liegen würden, ergäbe sich für "+
        	  "Sie eine Dosisleistung durch die Bodenstrahlung von ca. "+displaydosis_flexible(db)+
        	  " pro Stunde bzw. von "+displaydosis_flexible(dbjahr)+" pro Jahr.<p/>"+
        	  "Vergleichen  Sie das  mit der natürlichen Strahlenbelastung von "+
        	  "ca. "+displaydosis_flexible(110)+" pro Jahr.<p/>"+
        	  "Ihre tatsächliche  Strahlenbelastung ist  sicher 10 bis 100 mal "+
        	  "geringer, da Sie  sich ja  aufrecht und meist in Gebäuden bewegen. Außerdem klingt die "+
        	  "Bodenaktivität  in den ersten 8 Wochen um mehr als 70% ab, sodaß Ihre Jahresdosis von der "+
        	  "Bodenstrahlung  eher bei "+displaydosis_flexible(dbjahrw)+" liegt,  selbst  wenn  Sie  im Freien "+
        	  "arbeiten müssen.<p/>";
        	if(db>600) {
        		t=t+getResources().getString(R.string.umsiedelung1);
        	} else if(dbjahr*30/4>250000) {
        		t=t+getResources().getString(R.string.umsiedelung2);
        	} else if(dbjahr*30/4>25000) {
        		t=t+getResources().getString(R.string.dekontaminiert);
        	} else if(bl>200000) {
        		t=t+getResources().getString(R.string.zelten);
        	}

        	btext1.setText(Html.fromHtml(t));
        	
        	
        } else if(level==4)  {
        	String t;
        
        	milch=java.lang.Math.floor(bl/1000)*10;
        	salat=java.lang.Math.floor(bl/300)*10;
        	t="In der nächsten Zeit werden Ihre Lebensmittel radioaktiv belastet "+
        	  "sein. Vor allem wird  Milch in den ersten Wochen nach dem Unglück "+
        	  "durch Jod-131 belastet sein mit maximal "+roundSignificant(milch,2)+" Bq/Liter und Salat, "+
        	  "Spinat, Stielmus,...etc. mit max. "+roundSignificant(salat,2)+" Bq/kg. Diese Belastung "+
        	  "nimmt innerhalb von 6 Wochen auf ca. 20% der Anfangsbelastung ab "+
        	  "und rührt dann hauptsächlich von Cs-137 her.<p/>";
        	if(milch>250) t=t+getResources().getString(R.string.milchsalatverbot);
        	
        	btext1.setText(Html.fromHtml(t));
        	
        
        	
        } else if(level==5)  {
        	String t;
        	
        	dess=bl/500*1.5;
        	s5=milch/5;
        	t="Auch nach 8 Wochen Abklingzeit für J-131 wird Ihre Nahrung noch durch Cs-137 belastet sein "+
        	  "mit max. "+roundSignificant(s5,2)+" Bq/kg. Der EG-Grenzwert wurde 1986 zu 650 Bq/kg festgesetzt. Wenn Sie Ihre "+
        	  "Eßgewohnheiten nicht  ändern  und sich  weiter wie ein  Durchschnittsbürger ernähren "+
        	  "(960 kg pro Jahr), dann würde Ihre Zusatzdosis durch die Jod-, Cäsium- und Strontiumbelastung "+
        	  "unter Berücksichtigung der physikalischen und  biologischen Halbwertzeiten nach einem Jahr "+
        	  displaydosis_flexible(dess)+" sein, wenn Sie sich etwa vom eigenen Land ernähren oder die Behörden keine "+
        	  "Beschränkungen erlassen.<p/>";
        	if(dess>950) t=t+getResources().getString(R.string.nahrungnurgrenzwert);
        	
        	if(dess>30000) {
        	  t=t+getResources().getString(R.string.frageanderenahrung);
        	  
          	  
          	  eingabe2.setEnabled(false);
          	  weiterbutton.setEnabled(true);
          	} else {
            	radio.setVisibility(View.GONE);
            	weiterbutton.setVisibility(View.GONE);
            	eingabe2.setVisibility(View.GONE);
            	next.setEnabled(true);
         	}
        	btext1b.setText("");
        	btext1.setText(Html.fromHtml(t));
        	
        	
       	} else if(level==6)  {
        	String t;
        	if(dess>975) {
              faktor=java.lang.Math.floor((dess+dbjahr/10+dlmrem)/(975+dbjahr/10+dlmrem)*10)/10;
        	}
            dges=java.lang.Math.floor(dess+dbjahr/10+dlmrem);
            d50=java.lang.Math.floor(4*dess+dbjahr/10+dlmrem);
            t="Ihre gesamte Zusatzdosis aufgrund des Unglücks würde im nächsten "+
              "Jahr ca. <b>"+displaydosis_flexible(dges)+"</b> betragen. (Natürliche Dosis ca. "+displaydosis_flexible(110)+"). "+
              "Für die nächsten 50 Folgejahre ist die Zusatzdosis ca. "+displaydosis_flexible(d50)+", "+
              "vergleichsweise  ist  die natürliche  Dosis  in diesem  Zeitraum "+
              "ca. "+displaydosis_flexible(5000)+".<p/> ";

            if(dges>600000)      t=t+getResources().getString(R.string.tod1);
            else if(dges>200000) t=t+getResources().getString(R.string.gesundschaden1);
            
            if(s5>650) {
            	
                dges650=975+dbjahr/10+dlmrem;
                dges65050=4*975+dbjahr/10+dlmrem;
                t=t+"Haben Sie sich mit  der Nahrung jedoch an den EG-Grenzwert "+
                	"gehalten, so  wird Ihre  Jahresdosis nur "+displaydosis_flexible(dges650)+" "+
                	"betragen und die 50-Jahre Folgedosis nur "+displaydosis_flexible(dges65050)+". <p/>";
                if(dges650>600000)      t=t+getResources().getString(R.string.tod2);
                else if(dges650>200000) t=t+getResources().getString(R.string.gesundschaden2);
                t=t+getResources().getString(R.string.frageniedrigewerte);
                
            	weiterbutton.setEnabled(true);
            } else {
            	radio.setVisibility(View.GONE);
            	weiterbutton.setVisibility(View.GONE);
            	next.setEnabled(true);
            }
        	
        	
        	btext1.setText(Html.fromHtml(t));
        	
        	
        	
       	} else if(level==7)  {
       		String t;
       	    krp=java.lang.Math.floor(dges/10);
       		double kr=dges/10/1000000*100;
       		auto=java.lang.Math.floor(dges/10*100);
       		flug=java.lang.Math.floor(dges*650/900)/10;
       		zig=java.lang.Math.floor(dges*0.75)/10;
       		double wein=java.lang.Math.floor(dges*0.5)/10;
       		double alpin=java.lang.Math.floor(dges*1.5)/10;
       		double lebensr=java.lang.Math.floor(dges*0.3)/10;
       		gen=java.lang.Math.floor(dges/10*0.2);
       		
       		t="Die Zusatzdosis im nächsten Jahr erhöht Ihr Krebsrisiko um "+kr+" "+
       		  "Prozent d.h. von 1 Million Einwohnern werden "+krp+" Menschen "+
       		  "zusätzlich erkranken neben den 2300 Menschen, die ohnehin jedes Jahr "+
       		  "an Krebs erkranken. Aufgrund von Versicherungsstatistiken entspricht "+
       		  "dieses Risiko dem von:<p/>"+
       		  "&nbsp;"+(int)roundSignificant(auto,2)+" km Autofahrt<br/>"+
       		  "&nbsp;&nbsp;"+roundSignificant(flug,2)+" Flugstunden<br/>"+
       		  "&nbsp;&nbsp;&nbsp;"+roundSignificant(zig,2)+" Zigaretten rauchen<br/>"+
       		  "&nbsp;&nbsp;&nbsp;&nbsp;"+roundSignificant(wein,2)+" Flaschen Wein trinken<br/>"+
       		  "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+roundSignificant(alpin,2)+" Minuten Bergsteigen in den Alpen<br/>";
       		if(lebensr>0) {
       		  t=t+"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+roundSignificant(lebensr,2)+" Stunden leben im Alter > 60 Jahre<br/>";
       		}
       		t=t+"<p/>Das genetische Risiko läßt sich größenordnungsmäßig abschätzen zu "+
       	        roundSignificant(gen,2)+" Erbkrankheiten in der 1. Generation auf 1 Million Geburten.<p/>";
       		if(dess<=975 || dys>0) {
       			t=t+"Denken Sie daran, daß das die pessimistischste aller möglichen Abschätzungen ist, "+
       				"da eine lineare Dosis-Wirkung Beziehung angenommen worden ist.<p/>";
       		}
       		if(dys==0 && dess>975) {
       			t=t+"Die Risken sind "+roundSignificant(faktor,2)+" mal geringer, sofern Sie sich bei der Nahrung an "+
       			    "den EG-Grenzwert halten.<p/>";
       		}
       		t=t+"Anschließend sehen Sie eine Zusammenfassung der Ergebnisse in Tabellenform.";
       		btext1.setText(Html.fromHtml(t));
       	} else if(level==8)  {
       		String t;
       		double s5a=s5;
       		double s50a=s5a/10;
       	    dfilter=java.lang.Math.floor(al*tage/60*1000)/1000;
       		d10f=java.lang.Math.floor(dfilter/10*1000)/1000;
       		double d103=java.lang.Math.floor(d10f/3*1000)/1000;
       		double df3=java.lang.Math.floor(dfilter/3*1000)/1000;
       		
       		t="<b>Luftaktivit&auml;t</b> "+al+" Bq/m³ f&uuml;r "+tage+" Tage. <b>Bodenaktivit&auml;t</b> "+bl+" Bq/m²<br/>";
       		if(dys>0) {
       			t=t+"Nahrungsaufnahme gem&auml;&szlig; EG-Grenzwert (1986): 650 Bq/kg Cs<br/>";
       		} else if (qs>0) {
       			t=t+"Nahrungsaufnahme mit "+nbel+" Bq/kg<br/>";
       		}
       		t=t+"<table border=1 cellspacing=0><tr><td><b>Belastung</b></td><td><b>Maximalwerte</b></td></tr>";
       		t=t+"<tr><td>K&ouml;rperdosis durch Luftaktivit&auml;t </td><td>"+displaydosis_flexible(dlmrem)+"</td></tr>";
       	    t=t+"<tr><td>Schilddr&uuml;sendosis Kleinkind durch Inhalation</td><td>"+displaydosis_flexible(dschmrem)+"</td></tr>";
       	    t=t+"<tr><td>Vergleich: Radon-Aktivit&auml;t</td></tr>";
       	    t=t+"<tr><td>* im Wohnzimmer 40 Bq/m³</td><td>"+displaydosis_flexible(120)+"/Jahr</td></tr>";
       	    t=t+"<tr><td>* im Freien     15 Bq/m³ </td><td>"+displaydosis_flexible(45)+"/Jahr</td></tr>";
       	    t=t+"<tr><td>K&ouml;rperdosis aus Bodenstrahlung im Folgejahr</td></tr>";
       	    t=t+"<tr><td>a) 24 Std pro Tag liegen auf Wiese</td><td>"+displaydosis_flexible(dbjahr)+"</td></tr>";
       	    t=t+"<tr><td>b) bei normaler Lebensweise</td><td>"+displaydosis_flexible(dbjahrw)+"</td></tr>";
       	    t=t+"<tr><td>Vergleich: Nat&uuml;rliche Jahresdosis</td><td>"+displaydosis_flexible(110)+"</td></tr>";
       	    t=t+"<tr><td>Max. J-131 Kontamination von</td></tr>";
       	    t=t+"<tr><td>* Milch      </td><td>"+roundSignificant(milch,2)+" Bq/l</td></tr>";
       	    t=t+"<tr><td>* Salat/Spinat/Stielmus</td><td>"+roundSignificant(salat,2)+" Bq/kg</td></tr>";
       	    t=t+"<tr><td>Max. Cs-137 Kontamination der Nahrung</td><td>"+roundSignificant(s5a,2)+" Bq/kg</td></tr>";
       	    t=t+"<tr><td>Max. Sr-90 Kontamination der Nahrung</td><td>"+roundSignificant(s50a,2)+" Bq/kg</td></tr>";
       	    t=t+"<tr><td>Vergleich: Nat&uuml;rliche K-40 Aufnahme</td><td>90 Bq pro Tag</td></tr>";
       	    t=t+"<tr><td>Erlaubte J-131 Aufnahme f&uuml;r Kat. A Personen</td><td>700000 Bq/Jahr</td></tr>";
       	    t=t+"<tr><td>f&uuml;r Bev&ouml;lkerung </td><td>12600 Bq/Jahr</td></tr>";
       	    t=t+"<tr><td>Zusatzdosis durch Nahrung im Folgejahr </td><td>"+displaydosis_flexible(dess)+"</td></tr>";
       	    t=t+"<tr><td>Vergleich: Dosis durch nat&uuml;rliche K-40 Aufnahme</td><td>"+displaydosis_flexible(20)+"</td></tr>";
       	    t=t+"<tr><td>Gesamtdosis durch das Ungl&uuml;ck im Folgejahr</td><td>"+displaydosis_flexible(dges)+"</td></tr>";
       	    t=t+"<tr><td>50 Jahre Folgedosis</td><td>"+displaydosis_flexible(d50)+"</td></tr>";
t=t+"</table><p/>";
t=t+"<b>&Auml;quivalentes Risiko:</b><br/>";
t=t+"<table border=1 cellspacing=0><tr><td><b>Vergleich</b></td><td><b>Maximalwerte</b></td></tr>";
       	    t=t+"<tr><td>Autofahrt</td><td>"+(int)roundSignificant(auto,2)+" km (im Jahr)</td></tr>";
       	    t=t+"<tr><td>Flugstunden</td><td>"+roundSignificant(flug,2)+" Std.</td></tr>";
       	    t=t+"<tr><td>Zigaretten</td><td>"+roundSignificant(zig,2)+" St&uuml;ck</td></tr>";
       	    t=t+"<tr><td>Zus&auml;tzliche Krebserkrankungen auf 1 Million Einwohner  max.  </td><td>"+roundSignificant(krp,2)+"</td></tr>";
       	    t=t+"<tr><td>Vergleich: In Westeuropa erkranken pro Jahr</td><td>2300/1 Mio. Einw.</td></tr>";
       	    t=t+"<tr><td>Genetisches Risiko: Erbkrankheiten pro  1 Million Geburten </td><td>"+roundSignificant(gen,2)+"</td></tr>";
       	 t=t+"</table><p/>";
       	t=t+"<b>Weitere Sonderf&auml;lle:</b><br/>";
       	t=t+"<table border=1 cellspacing=0><tr><td><b>Belastung</b></td><td><b>Maximalwerte</b></td></tr>";
       	    t=t+"<tr><td>Oberfl&auml;chendosisleistung an Luftfiltern anf&auml;nglich</td><td>"+displaydosis_nounit(d10f)+" bis "+displaydosis(dfilter)+"/h</td></tr>";
       	    t=t+"<tr><td>nach 8 Wochen</td><td>"+displaydosis_nounit(d103)+" bis "+displaydosis(df3)+"/h</td></tr>";
       		t=t+"</table>";
       		t=t.replace("µ", "&micro;");
       		t=t.replace("²", "&sup2;");
       		t=t.replace("³", "&sup3;");
       		Ergebnistabelle=t;
       		webview.loadDataWithBaseURL(null, t, "text/html", "utf-8", null);
       		btext1.setText("");
       	} else if(level==9)  {
       		
       		
       		
       		
       		
       		
        		btext1b.setText("Durch \"Neustart\" können Sie die Berechnungen mit anderen Werten erneut durchführen.");
      	} else if(level==10)  {
      		String t;
      		 t="Die Luftfilter haben "+tage+" Tage lang die radioaktiv belastete Luft "+
      			"angesaugt. Daher ist es nicht verwunderlich, wenn Sie jetzt an der "+
      			"Oberfläche der Filter Dosisleistungen zwischen "+displaydosis(d10f)+"/Stunde "+
      			"und "+displaydosis(dfilter)+"/Std. messen können je nach Dicke der Filter und der "+
      			"Lage der Ansaugrichtung. Schwerpunktmäßig werden die Werte näher an "+
      			"dem niedrigeren Wert liegen. In einem Meter Abstand vom Filter fällt "+
      			"die Dosis auf 10% des Oberflächenwertes ab; halten Sie also Abstand! "+
      			"Lassen Sie die Filter auf jeden Fall in den ersten 8 Wochen eingebaut "+
      			"und fahren Sie die Anlage auf kleine Leistung. Vermeiden Sie Ein- und "+
      			"Ausschalten wegen der Druckstöße, die Staub aufwirbeln können.<p/>"+
      			"Nach 8 Wochen ist das Jod abgeklungen  und die Dosisleistung auf 30% "+
      			"des Ausgangswertes reduziert.<p/>"+
      			"Trommelfilter können Sie sofort weiter durchrollen bis zur nächsten "+
      			"sauberen Fläche.<p/>";
      			if(dfilter<0.05) {
      				t=t+"Ansonsten brauchen Sie nichts zu unternehmen. Nach 8 Wochen "+
      					"kann normal entsorgt werden.";
      			} else {
      				if(dfilter>100) {
      					t=t+"Das Betreten der Filteranlagen ist wegen der hohen Dosisleistung "+
      					"nur im Beisein des Strahlenschutzbeauftragten erlaubt. Tragen Sie "+
      					"eine Filmplakette und kontrollieren Sie die Dosisleistung mit "+
      					"einem Meßgerät. Beachten Sie die Dosis-Grenze für "+
      					"strahlenüberwachtes Personal von 5 rem/Jahr (3 rem in 13 Wochen).<p/>"+
      					"Warten Sie sicherheitshalber die Anweisungen des "+
      					"Regierungspräsidenten ab.";
      				} else if(dfilter>=10) {
      					t=t+"Die Filteranlagen dürfen nur von strahlenüberwachtem Personal "+
      					"betreten werden. Allerdings kann mindestens 50 Stunden 'gefahrlos' "+
      					"gearbeitet werden.<p/>"+
      					"** Trotzdem gilt immer der Grundsatz: <b>** So wenig Dosis wie möglich!! **</b><p/>"+
      					"Lassen Sie die Dosisleistung auf jeden Fall vom Strahlenschutzbeauftragten messen!!!";
      				}
      				t=t+"<p/>Wenn Sie nach 8 Wochen oder später die Filter auswechseln, dann bitte "+
      					"nur mit Atemschutzkappe und Plastikkittel. Schweißen Sie die Filter "+
      				    "in billige Plastiktüten ein, da  Gefahr hauptsächlich vom Einatmen "+
      				    "des aufgewirbelten Staubes droht.<p/>";
      				if(dfilter>1) {
      					t=t+"Vor Beginn der Arbeiten lassen Sie aber auf jeden Fall die Dosisleistung kontrollieren! "+
      						"Halten Sie die Filter möglichst weit vom Körper weg!";
      				}
      			}	  
      		
      		btext1.setText(Html.fromHtml(t));
      	} else if(level==11)  {
      		String t;
      		double fisch=rhein/10*2;
      		
      		if(bl<10000) {
      			t="<font color=#00ff00><b>Sie können alle Tätigkeiten im Garten normal weiter ausführen "+
      			    "und ganz normal ernten.</b></font>";
      		} else if(bl<200000) {
      	        t="Bitte beachten Sie die folgenden <font color=#ffff00><b>Verhaltensregeln</b></font>:<p/>"+
      	        	"Schütten Sie das Zisternenwasser aus.<br/> "+
      	        	"Erntereifen Salat graben Sie bitte um, er hat im Regen auf den Blättern "+
      	        	"zuviel radioaktives Jod angereichert. Kleine Pflänzchen können Sie "+
      	        	"stehen lassen, da diese erst nach 8 Wochen zum Verzehr gelangen.<br/>"+
      	        	"Rhabarber schneiden Sie 5 cm  oberhalb des Bodens ab, schälen ihn, "+
      	        	"kochen ihn ein und verzehren ihn erst nach 8 Wochen.<br/>"+
      	        	"Tomaten, Radieschen, Spargel können Sie nach gründlichem Waschen essen.<p/>"+
      	        	"Haustiere können Sie ins Freie lassen.<br/>"+
      	        	"Fische aus stehendem Gewässer (Baggersee) sollten Sie nicht angeln, "+
      	        	"da sich Cäsium im Fischfleisch anreichert. Sie müssen beim Verzehr "+
      	        	"von 10 kg dieses Fisches mit "+displaydosis(fisch)+" Zusatzdosis rechnen.<p/>"+
      	        	"Schnittlauch und Petersilie werfen Sie besser weg oder Sie frieren es "+
      	        	"ein und verzehren es erst nach 8 Wochen.<p/>"+
      	        	"Der Rasenschnitt kann auf den Komposthaufen.<br/>"+
      	        	"Der Einsaat steht nichts entgegen.";
      		} else {
      			t="Arbeiten Sie in der nächsten Zeit <font color=#ff0000><b>nicht</b></font> im Garten und ernten Sie auch "+
      				"nichts. Warten Sie die Anweisungen des Regierungspräsidenten ab.<p/>"+
      				"Zur Not können Sie reife Früchte wie Tomaten, Kartoffeln,..., die eine "+
      				"feste Schale und eine relativ kleine Oberfläche haben, nach Schälen "+
      				"und gründlichem Waschen verzehren. Auf keinen Fall jedoch Blattgemüse "+
      				"oder Rhabarber oder Salat wegen des vielen radioaktiven Jods auf den "+
      				"großen Blattoberflächen.";
      		}

      		btext1.setText(Html.fromHtml(t));
       	} else if(level==12)  {
      		String t;
      		double schwimmen=0.004*rhein/10;
      		if(bl<10000) {
      			t="<font color=#00ff00><b>Für Ihre Kinder besteht keine Gefahr, lassen Sie sie ruhig "+
      			  "draußen spielen.</b></font>";
      		} else if(bl<200000) {
      			t="Achten Sie beim Spielen im Sandkasten oder am Strand darauf, daß die "+
      			  "Kinder nicht den Sand in den Mund stecken. Auch sollten sie nicht "+
      			  "längere Zeit auf der Wiese liegen. Auf jeden Fall müssen die Hände "+
      			  "beim Hereinkommen immer gründlich gewaschen werden. Duschen Sie das "+
      			  "Kind öfter. Schwimmen im Freibad ist ungefährlich. Fragen Sie aber zur "+
      			  "Kontrolle den Bademeister. Hundert Stunden schwimmen im Freibad sollte "+
      			  "zu nicht mehr als "+displaydosis(schwimmen)+" führen. Sportplätze sind benutzbar, "+
      			  "wenn sie nicht zu staubig sind.<p/> "+
      			  "Im Kindergarten wird die Frage diskutiert werden, ob der Sand in den "+
      			  "Sandkästen ausgetauscht werden soll. Schlagen Sie vor, damit 6 Wochen "+
      			  "zu warten und dann den Sand analysieren zu lassen. In der Zwischenzeit "+
      			  "sollen die Kinder verstärkt beim Spielen beobachtet werden. Falls Sie "+
      			  "beschließen, den Sand auszutauschen, fragen Sie genau, woher der neue "+
      			  "Sand kommt. Denn wer lagert schon Sand in einer Halle oder unter "+
      			  "Regenplanen. Lassen Sie im Zweifel eine Analyse anfertigen. ";
      	} else {
      	    t="<b>Lassen Sie Ihre Kinder in der nächsten Zeit möglichst <font color=#ff0000>nicht</font> "+
      	        "draußen spielen !!</b><p/>";
      	}

      		btext1.setText(Html.fromHtml(t));
       	} else if(level==13)  {
      		String t;
      		if(rhein<100) {
      			t="<font color=#00ff00><b>Das Trinkwasser ist  n i c h t  gefährdet.</b></font><p/>";
      		} else if(rhein>1000) {
      			t="Sofern Sie Wasser aus Uferfiltraten erhalten,  wird Ihr Wasser "+
      			  "in Kürze radioaktiv belastet sein. Besorgen Sie sich Talsperren- "+
      			  "oder Mineralwasser. Bedenken Sie, daß  die Talsperren im Spät- "+
      			  "herbst ihre stabile Wasserschichtung aufgeben und Oberflächenwasser "+
      			  "nach unten zu den Ansaugrohren gelangt. Danach ist auch Talsperren- "+
      			  "wasser belastet.";
      		} else {
      			t="Es besteht die Möglichkeit, daß, wenn Sie Wasser aus Uferfiltraten "+
      			  "erhalten, dieses nach einiger Zeit leicht radioaktiv belastet ist, "+
      			  "sofern es nicht mit Talsperrenwasser gemischt wird. Zur Sorge besteht "+
      			  "kein Anlaß, jedoch sollten Sie die Entwicklung im Auge behalten.<p/>"+
      			  "Erkundigen Sie sich bei den Wasserwerken.";
      		}

      		btext1.setText(Html.fromHtml(t));
       	} 
        eingabe.addTextChangedListener(new TextWatcher(){
        	public void onTextChanged(CharSequence s, int start, int before, int count) {}
           	public void beforeTextChanged(CharSequence s, int start, int count, int after) {}
        	public void afterTextChanged(Editable s) {
        		weiterbutton.setEnabled(s.length()>0);
        	}
        });
        weiterbutton.setOnClickListener(new OnClickListener() {
        	public void onClick(View v) {
        	
        		weiterbutton.setEnabled(false);
        		eingabe.setEnabled(false);
        		eingabe2.setEnabled(false);
        		
        		if(level==0) {
        			String t;
        			al=Double.parseDouble(eingabe.getText().toString());
        			
         			btext2.setText("");
        			if(al<0.5) {
        				t="Bei einer  so  geringen  Belastung  brauchen  Sie sich überhaupt "+
        			      "keine Gedanken  zu machen.  Eine Beschäftigung mit dem  Programm "+
        			      "wäre Zeitverschwendung.  Spielen Sie lieber den Fall einer zehn"+
        			      "mal höheren Belastung durch.";
        			} else if(al>10000000) {
        				t="Ein  so  unrealistisch  hoher  Wert  würde bedeuten,  daß Sie in "+
        			      "spätestens 5 Stunden alleine  von der Luftaktivität mehr als die "+
        			      "tödliche  Dosis  erhalten  hätten.  In  diesem  Falle hätten Sie "+
        			      "andere Sorgen als am Computer zu sitzen."+
        			      "<h2>Nehmen Sie realistischere Werte!</h2>";
        			} else {
        				
        				double ddir=java.lang.Math.floor(2*al/1000.0*1000.0)/1000.0;
        				dinh=java.lang.Math.floor(al/100.0*1000.0)/1000.0;
        				dinhsch=java.lang.Math.floor(al*1.7/24*1000.0)/1000.0;
        				  t="Die Dosisleistung  im Freien,  wie Sie sie etwa mit einem Geigerzähler "+
        				    "messen  könnten, ist  dann  "+displaydosis(ddir)+" pro  Stunde. <br/>"+
        				    "Ihre  persönliche  Dosis  wird  durch  Inhalation  etwas  größer, "+
        				    "nämlich  "+displaydosis(dinh)+" pro  Stunde und  die  Schildrüsendosis  für "+
        				    "ein Kleinkind "+displaydosis(dinhsch)+" pro Stunde.<p/>";
        				  if(dinh>0.01) {
        				    t=t+"<font color=#ffff00><b>Vermeiden Sie bitte den Aufenthalt im Freien.</b><p/>"+
        				        "<b>Schließen Sie die Fenster!</b></font><p/>";
        				    if(dinh>10000) {
        				      t=t+"<font color=#ff0000><b>Ihr Leben ist akut gefährdet, suchen Sie sofort "+
        				          "einen Atombunker mit Luftfiltern auf!</b></font><p/>";
        				    } else if(dinh>150) {
        				      double tkrit1=java.lang.Math.round(30000/dinh/24*10)/10.0;
        				      double tkrit2=java.lang.Math.round(300000/dinh/24*10)/10.0;
        				      t=t+"Nach  "+tkrit1+" Tagen  wird  Ihre  Dosis  so  hoch (>25 rem) sein, "+
        				          "daß Sie gesundheitliche Schäden davontragen. Versuchen Sie, das "+
        				          "Gebiet  zu verlassen. Sie haben dazu maximal "+tkrit2+" Tage Zeit zum "+
        				          "Überleben. Falls es vorher regnet, haben Sie Glück gehabt, denn "+
        				          "dann wird die Radioaktivität aus der Luft ausgewaschen.<p/>"+
        				          "<b>Bleiben Sie dann im Haus. Auf keinen Fall in den Regen stellen!</b><p/>";
        				    } else if(dinh>0.1) {
        				    	t=t+"Falls Sie ein  Außenschwimmbad besitzen, decken  Sie vor dem "+
        				            "Regen eine Plane darüber. Schützen Sie ebenso Salat, Spinat, "+
        				            "Petersilie, Rhabarber und sonstige  Gartenfrüchte  mit einer "+
        				            "regenundurchlässigen  Plastikfolie, falls  Sie  das Obst und "+
        				            "Gemüse später noch essen wollen.<p/>";
        				  	}
        				  } 
        				  next.setEnabled(true);       			  
        			} 
        			
        			btext3.setText(Html.fromHtml(t));
        		} else if(level==1) {
        			String t;
  
        			double hoe;
        			tage=Double.parseDouble(eingabe.getText().toString());
        			btext2.setText("");
        			
        			dlmrem=java.lang.Math.floor(dinh*tage*24.0*1000)/1000.0;
        			dschmrem=java.lang.Math.floor(tage*24.0*dinhsch*1000)/1000.0;
        			hoe=java.lang.Math.floor(tage*110.0/365*1000)/1000.0;
        			t="Ihre Dosis durch die Radioaktivität der Luft war "+displaydosis_flexible(dlmrem)+", "+
        			  "sofern Sie sich die ganze Zeit im Freien aufgehalten haben.<p/>"+
        		      "Die Schilddrüsendosis für ein Kleinkind war dann "+displaydosis_flexible(dschmrem)+".<p/>";
        			if(dlmrem>1000000) {
        				t=t+"<font color=#ff0000><b>Das können Sie schwerlich überleben,</b></font>"+
        			        " alle weiteren Berechnungen wären sinnlos!<p/><b>Fangen Sie nochmal neu an.</b><p/>";
        			} else {
        			   t=t+"Zum  Vergleich:  In  der gleichen  Zeit war die Dosis durch die "+
        				"natürliche Strahlung "+displaydosis(hoe)+".<p/>";
        			   if(dschmrem>30000) {
        				   t=t+"<font color=#ffff00><b>***** Deshalb hat die Regierung Schutzmaßnahmen "+
        			           "angeordnet.*****</b></font><br/>";
        			   }	 
        				if(dschmrem>100000) {
        					    t=t+"u.a. werden Jodtabletten verteilt werden.  <b>VORSICHT: Essen Sie "+
        					    "Jodtabletten nur nach Aufforderung durch die Behörden und nach "+
        					    "Rücksprache mit ihrem Hausarzt !!!!</b><p/>";
        				}
        				if(dschmrem<10000) {
        					    t=t+"Essen Sie auf keinen Fall Jodtabletten nur aus Angst vor Radioaktivität. "+
        				            "Sie werden erst erforderlich ab einer Schilddrüsendosis von "+displaydosis(100000)+", "+
        					    	"also ab 1 Sievert oder Hunderttausend Millirem!<p/>";
        				}
        				bl=java.lang.Math.floor(al*100.0)*10.0;
        					  
        			  next.setEnabled(true); 
        			}
        			btext3.setText(Html.fromHtml(t));
        		} else if(level==2){
        			String t;
        			double gmz;
        			btext2.setText("");
        			if(radio.getCheckedRadioButtonId()==R.id.radio0) {
        				bl=Double.parseDouble(eingabe.getText().toString());
        				btext2.setText("Der Wert wurde auf "+bl+" Bq/Quadratmeter korrigiert.");
        			}
        			radio.setEnabled(false);
        			rhein=java.lang.Math.floor(bl/1000.0);
        			gmz=java.lang.Math.floor((bl/40000.0+1.0)*10.0)/10.0;
        			t="Zur Kontrolle prüfen Sie bitte, ob die gemeldeten Werte für das "+
        			  "Wasser Ihres nächstgelegenen Flusses ca. "+roundSignificant(rhein,2)+" Bq/Liter betragen.<p/>";
        			if(gmz>1.09) {
        			  t=t+"Sollten Sie einen  kleinen Geigerzähler verfügbar haben, so sollte "+
        				  "der, wenn Sie ihn auf eine Wiese legen, "+roundSignificant(gmz,2)+" - mal so schnell zählen "+
        				  "wie auf Ihrem Schreibtisch im Haus.<p/>";
        			}

        			next.setEnabled(true); 
        			btext3.setText(Html.fromHtml(t));
        		} else if(level==5){
        			String t="Im folgenden Erfahren Sie, wie sich das auf Ihre Gesamtdosis auswirkt.";
        			
        			radio.setEnabled(false);
        		
        			if(radio.getCheckedRadioButtonId()==R.id.radio0) {
        				nbel=Double.parseDouble(eingabe2.getText().toString());
        				dess=nbel/100*150;
        				s5=nbel;
        				btext2.setText("Ihre Zusatzdosis aus der Nahrung ist dann nur "+displaydosis(dess)+"/Jahr");
        			} else btext2.setText("Ihre Zusatzdosis konnte also nicht verringert werden.");
        			next.setEnabled(true); 
        			btext3.setText(Html.fromHtml(t));
        		} else if(level==6){
        			String t="Es folgt die Risikobetrachtung.";
        			radio.setEnabled(false);
        			if(radio.getCheckedRadioButtonId()==R.id.radio0) {
        				dges=dges650;
        				d50=dges65050;
        				dess=975;
        				dys=1;
        				btext2.setText("Es wird mit niedrigeren Werten weitergerechnet.");
        			} else {
        				dys=0;
        				btext2.setText("");
        			}
        			next.setEnabled(true); 
        			btext3.setText(Html.fromHtml(t));
         		} else btext2.setText("Test: "+level+" ");
                btext2.setVisibility(View.VISIBLE);
                btext3.setVisibility(View.VISIBLE);
                fertig.setVisibility(View.VISIBLE);
        	}
        });
        fertig.setOnClickListener(new OnClickListener() {
        	
        	public void onClick(View v) {
        		finish();
        	}
        });	
        next.setOnClickListener(new OnClickListener() {
        	
        	public void onClick(View v) {
        		level++;
        		Intent viewIntent = new Intent(TBProgrammActivity.this, TBProgrammActivity.class);
        		startActivity(viewIntent);	
        		finish();
        	}
        });	
        
    }
    
	public static void setlevel(int i) {
		level=i;
    }
	
	private void savedata(String content) {
    	FileOutputStream fos=null;
    	OutputStreamWriter osw=null;
    	
    	String filename="TSCH_BYL-out-"+(int)al+"-"+(int)tage+".html";
    	 /* Hier jetzt ein externe von aussen lesbares verzeichnis*/
		File dirdata=Environment.getExternalStorageDirectory();
		File dir=new File (dirdata, "Android/TSCH_BYL");
    	
    	try {
           
    		dir.mkdirs();
    	
    	
    		
    		File file=new File(dir,filename);
    		
    		
 		
       		fos=new FileOutputStream(file);
    		osw=new OutputStreamWriter(fos);
		     
    		osw.write("<html>\n");
    		osw.write("<head><TITLE>TSCH_BYL Ergebnisse</TITLE>\n");
    		osw.write("</head>\n");
    		osw.write("<body>\n");
    	   		
    	   		osw.write(content);
    	   		osw.write("<HR><br>"+
    	   		"<I> generated by TSCH_BYL for Android V.1.16 (c) W. + M. Hoffmann 1987-2016"+
    	   		".</I><P>\n");
    	   		osw.write("<FONT FACE=ARIAL,HELVETICA SIZE=1>"+
    	   		"Erzeugt am "+DateFormat.getDateInstance().format(new Date())+
    	   		"</FONT>");
    	   		osw.write("</body>\n");
    	   		osw.write("</html>\n");
    		
    		
    	} catch (Throwable t) {
    		// FilenotFound oder IOException
    		Log.e(TAG,"open/save. ",t);
    		Toast.makeText(getApplicationContext(), "ERROR: could not save file "+dir.toString()+"/"+filename, Toast.LENGTH_LONG).show();
    	} finally {
    		if(osw!=null) {
    			try {
    				osw.close();
    			} catch (IOException e) {
    				Log.e(TAG,"osw.close ",e);
    			}
    		}
    		if(fos!=null) {
    			try {
    				fos.close();
    			} catch (IOException e) {
    				Log.e(TAG,"fos.close ",e);
    			}
    		}
    		Toast.makeText(getApplicationContext(), "File "+dir.toString()+"/"+filename+" saved.", Toast.LENGTH_LONG).show();
    	}
        
    }
	
}
