package com.droidwave.offlinecalendar;

import static pl.magot.vetch.ancal.agenda.AbstractAgendaView.viewMode.DAY;
import static pl.magot.vetch.ancal.agenda.AbstractAgendaView.viewMode.MONTH;
import static pl.magot.vetch.ancal.agenda.AbstractAgendaView.viewMode.TODAY;
import static pl.magot.vetch.ancal.agenda.AbstractAgendaView.viewMode.WEEK;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

import pl.magot.vetch.ancal.AbstractCommonActivity;
import pl.magot.vetch.ancal.Prefs;
import pl.magot.vetch.ancal.Utils;
import pl.magot.vetch.ancal.agenda.AbstractAgendaView;
import pl.magot.vetch.ancal.agenda.AgendaViewDay;
import pl.magot.vetch.ancal.agenda.AgendaViewMonth;
import pl.magot.vetch.ancal.agenda.AgendaViewToday;
import pl.magot.vetch.ancal.agenda.AgendaViewWeek;
import pl.magot.vetch.ancal.database.Database;
import pl.magot.vetch.ancal.dataview.DataViewAppointment;
import pl.magot.vetch.ancal.dataview.DataViewNote;
import pl.magot.vetch.ancal.dataview.DataViewTask;
import pl.magot.vetch.ancal.reminder.AlarmService;
import pl.magot.vetch.ancal.views.ViewImgButton;
import pl.magot.vetch.ancal.views.ViewTodayItemHeader;
import pl.magot.vetch.widgets.DateWidget;
import pl.magot.vetch.widgets.TimeWidget;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Handler;
import android.provider.Settings;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup.MarginLayoutParams;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.LinearLayout.LayoutParams;
import static android.widget.LinearLayout.LayoutParams.FILL_PARENT;

//Main activity
public class OfflineCalendar extends AbstractCommonActivity {
	private static final int HANDLER_UPDATE_TIME = 1000 * 5;// every 5s
	private Calendar dateToday = Calendar.getInstance();
	private SimpleDateFormat dateFormatFull = new SimpleDateFormat(
			"EE, dd-MM-yyyy");
	private SimpleDateFormat dateFormatMonth = new SimpleDateFormat("MMMM yyyy");

	// fields
	private int iCurrentAgendaViewType;

	// menu items
	private final int miNewAppt = Menu.FIRST;
	private final int miNewTask = Menu.FIRST + 1;
	private final int miNewNote = Menu.FIRST + 2;
	private final int miShowAllTasks = Menu.FIRST + 3;
	private final int miOptions = Menu.FIRST + 4;
	private final int mTimeZone = Menu.FIRST + 5;
	private final int miAbout = Menu.FIRST + 6;

	// views
	private ScrollView scrollViewAgenda = null;
	private RelativeLayout rlayAgendaTop = null;

	private RelativeLayout rlayAgenda = null;

	private RelativeLayout rlayAgendaView = null;
	private LinearLayout llayAgendaData = null;

	// views
	private AbstractAgendaView currentAgendaView = null;
	private AgendaViewToday agendaViewToday = null;
	private AgendaViewDay agendaViewDay = null;
	private AgendaViewWeek agendaViewWeek = null;
	private AgendaViewMonth agendaViewMonth = null;

	// fields
	protected DataViewAppointment dataViewAppt = null;
	protected DataViewTask dataViewTask = null;
	protected DataViewNote dataViewNote = null;

	// fields
	private Handler handlerUpdateDate = new Handler();
	private Handler handlerUpdateView = new Handler();
	private int iUpdateDate_minute = 0;

	// views
	protected TextView labWeekStr = null;
	protected TextView labWeekNr = null;

	private TextView labSelectViewItem = null;
	private ViewImgButton btnSelectViewItemPrev = null;
	private Button btnSelectViewItemToday = null;
	private ViewImgButton btnSelectViewItemNext = null;

	// bottom buttons
	private Button btnSetViewToday = null;
	private Button btnSetViewDay = null;
	private Button btnSetViewWeek = null;
	private Button btnSetViewMonth = null;

	@Override
	public void onCreate(Bundle icicle) {
		super.onCreate(icicle);
		setContentView(R.layout.agenda);

		initViews();
		initStateOnce();
		startReminderService();
	}

	@Override
	public void onDestroy() {
		super.onDestroy();
		handlerUpdateDate.removeCallbacks(handlerUpdateDateTask);
	}

	@Override
	protected void onRestoreInstanceState(Bundle savedInstanceState) {
		super.onRestoreInstanceState(savedInstanceState);
		if (savedInstanceState != null) {
			int lastAgendaViewType = savedInstanceState
					.getInt("iCurrentAgendaViewType",
							AbstractAgendaView.viewMode.TODAY);
			setAgendaView(lastAgendaViewType, latestDateToday());
		}
	}

	@Override
	protected void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);
		outState.putInt("iCurrentAgendaViewType", iCurrentAgendaViewType);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		super.onCreateOptionsMenu(menu);

		// build menu
		MenuItem mi = menu.add(0, miNewAppt, 0, R.string.actionNewAppointment);
		mi.setShortcut('1', 'a');
		mi.setIcon(R.drawable.menuiconappt);

		mi = menu.add(0, miNewTask, 1, R.string.actionNewTask);
		mi.setShortcut('2', 't');
		mi.setIcon(R.drawable.menuicontask);

		mi = menu.add(0, miNewNote, 2, R.string.actionNewNote);
		mi.setShortcut('3', 'n');
		mi.setIcon(R.drawable.menuiconnote);

		mi = menu.add(2, miShowAllTasks, 3, R.string.actionShowAllTasks);
		mi.setCheckable(true);
		mi.setChecked(prefs.bShowAllTasks);
		menuItemUpdateIcons(mi);

		mi = menu.add(4, miOptions, 4, R.string.actionOptions);
		mi.setShortcut('5', 'o');
		mi.setIcon(R.drawable.menuiconprefs);

		mi = menu.add(4, mTimeZone, 5, R.string.TimeZone);
		mi.setIcon(R.drawable.menuiconabout);

		mi = menu.add(4, miAbout, 6, R.string.actionAbout);
		mi.setIcon(R.drawable.menuiconabout);

		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {
		case miNewAppt:
			openActAppointment(-1, -1, -1);
			break;
		case miNewTask:
			openActTask(-1);
			break;
		case miNewNote:
			openActNote(-1);
			break;
		case miShowAllTasks: {
			item.setChecked(!item.isChecked());
			prefs.bShowAllTasks = item.isChecked();
			prefs.Save();
			refreshData();
			menuItemUpdateIcons(item);
			break;
		}
		case miOptions:
			openActOptions();
			break;
		case mTimeZone:
			showTimeZone();
			break;
		case miAbout:
			openActViewAbout();
			break;
		}
		return super.onOptionsItemSelected(item);
	}

	private void menuItemUpdateIcons(MenuItem item) {
		if (item.getItemId() == miShowAllTasks)
			if (item.isChecked()) {
				item.setIcon(R.drawable.menuiconshowtasksdue);
			} else {
				item.setIcon(R.drawable.menuiconshowtasks);
			}
	}

	private void initViews() {
		// localize DateWidget
		DateWidget.setStrings(utils.GetResStr(R.string.strDateWidgetSelect),
				utils.GetResStr(R.string.strDateWidgetSelected), utils
						.GetResStr(R.string.strDateWidgetNone));

		// localize TimeWidget
		TimeWidget.setStrings(utils.GetResStr(R.string.strTimeWidgetSelect),
				utils.GetResStr(R.string.strTimeWidgetNone), utils
						.GetResStr(R.string.strTimeWidgetSet));

		rlayAgendaTop = (RelativeLayout) findViewById(R.id.rlayAgendaTop);
		rlayAgenda = (RelativeLayout) findViewById(R.id.rlayAgenda);
		rlayAgendaView = (RelativeLayout) findViewById(R.id.rlayAgendaView);

		llayAgendaData = (LinearLayout) findViewById(R.id.llayAgendaData);

		btnSelectViewItemPrev = (ViewImgButton) findViewById(R.id.btnSelectViewItemPrev);
		btnSelectViewItemPrev.SetButtonIcon(R.drawable.btnprev, -1);
		btnSelectViewItemPrev.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				currentAgendaView.SetPrevViewItem();
				RefreshAgendaAfterViewItemChange();
			}
		});

		btnSelectViewItemToday = (Button) findViewById(R.id.btnSelectViewItemToday);
		btnSelectViewItemToday.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				currentAgendaView.SetTodayViewItem();
				RefreshAgendaAfterViewItemChange();
			}
		});

		btnSelectViewItemNext = (ViewImgButton) findViewById(R.id.btnSelectViewItemNext);
		btnSelectViewItemNext.SetButtonIcon(R.drawable.btnnext, 0);
		btnSelectViewItemNext.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				currentAgendaView.SetNextViewItem();
				RefreshAgendaAfterViewItemChange();
			}
		});

		labWeekStr = (TextView) findViewById(R.id.labWeekStr);
		labWeekNr = (TextView) findViewById(R.id.labWeekNr);

		labSelectViewItem = (TextView) findViewById(R.id.labSelectViewItem);

		// initialize change view bottom buttons
		btnSetViewToday = (Button) findViewById(R.id.btnSetViewToday);
		btnSetViewToday.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				// ToggleBottomButtonsState(btnSetViewToday);
				setAgendaView(AbstractAgendaView.viewMode.TODAY,
						latestDateToday());
			}
		});

		btnSetViewDay = (Button) findViewById(R.id.btnSetViewDay);
		btnSetViewDay.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				// ToggleBottomButtonsState(btnSetViewDay);
				setAgendaView(AbstractAgendaView.viewMode.DAY,
						latestDateToday());
			}
		});

		btnSetViewWeek = (Button) findViewById(R.id.btnSetViewWeek);
		btnSetViewWeek.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				// ToggleBottomButtonsState(btnSetViewWeek);
				setAgendaView(AbstractAgendaView.viewMode.WEEK,
						latestDateToday());
			}
		});

		btnSetViewMonth = (Button) findViewById(R.id.btnSetViewMonth);
		btnSetViewMonth.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				// ToggleBottomButtonsState(btnSetViewMonth);
				setAgendaView(AbstractAgendaView.viewMode.MONTH,
						latestDateToday());
			}
		});

		// initialize data views
		dataViewAppt = new DataViewAppointment(userdb, prefs);
		dataViewTask = new DataViewTask(userdb, prefs);
		dataViewNote = new DataViewNote(userdb, prefs);

		initAgendaViewToday();
	}

	public void ToggleBottomButtonsState(CompoundButton btnClicked) {
		btnClicked.setEnabled(false);
		btnClicked.requestFocus();

		if (btnClicked != btnSetViewToday)
			btnSetViewToday.setEnabled(true);
		if (btnClicked != btnSetViewDay)
			btnSetViewDay.setEnabled(true);
		if (btnClicked != btnSetViewWeek)
			btnSetViewWeek.setEnabled(true);
		if (btnClicked != btnSetViewMonth)
			btnSetViewMonth.setEnabled(true);
	}

	public void updateBottomButtonsStateByCurrentView() {
		/*
		 * if (iCurrentAgendaViewType == AbstractAgendaView.viewMode.TODAY)
		 * ToggleBottomButtonsState(btnSetViewToday); if (iCurrentAgendaViewType
		 * == AbstractAgendaView.viewMode.DAY)
		 * ToggleBottomButtonsState(btnSetViewDay); if (iCurrentAgendaViewType
		 * == AbstractAgendaView.viewMode.WEEK)
		 * ToggleBottomButtonsState(btnSetViewWeek); if (iCurrentAgendaViewType
		 * == AbstractAgendaView.viewMode.MONTH)
		 * ToggleBottomButtonsState(btnSetViewMonth);
		 */
	}

	public void initAgendaViewToday() {
		// initialize today agenda view
		agendaViewToday = new AgendaViewToday(this);
		agendaViewToday.rebuild();

		// set click event for all agenda views
		AbstractAgendaView
				.SetItemClick(new AbstractAgendaView.OnViewItemClick() {
					public void OnClick(View v, Bundle extras) {
						long lRowId = extras
								.getLong(AbstractCommonActivity.bundleRowId);
						if (extras.getString("type").equals(
								ViewTodayItemHeader.ViewType.Appointments
										.toString())) {
							if (extras
									.containsKey(AbstractCommonActivity.bundleHourOfDay)) {
								openActAppointment(
										lRowId,
										extras
												.getInt(AbstractCommonActivity.bundleHourOfDay),
										extras
												.getInt(AbstractCommonActivity.bundleMinutes));
							} else {
								openActAppointment(lRowId, -1, -1);
							}
						}
						if (extras.getString("type").equals(
								ViewTodayItemHeader.ViewType.Tasks.toString()))
							openActTask(lRowId);
						if (extras.getString("type").equals(
								ViewTodayItemHeader.ViewType.Notes.toString()))
							openActNote(lRowId);
					}
				});

		// initialize all other agenda views
		agendaViewDay = new AgendaViewDay(OfflineCalendar.this);
		agendaViewDay.rebuild();

		agendaViewWeek = new AgendaViewWeek(OfflineCalendar.this);
		agendaViewWeek.rebuild();

		agendaViewMonth = new AgendaViewMonth(OfflineCalendar.this);
		agendaViewMonth.rebuild();

		// initialize scrollable content
		scrollViewAgenda = new ScrollView(this);
		LayoutParams layParams = new LayoutParams(FILL_PARENT,
				FILL_PARENT);
		scrollViewAgenda.setLayoutParams(layParams);
	}

	private void initStateOnce() {
		reloadAllDataTables();
		// ToggleBottomButtonsState(btnSetViewToday);
		setAgendaView(AbstractAgendaView.viewMode.TODAY, latestDateToday());

		// refresh view (relayout bug)
		forceUpdateLayout();

		// schedule handler update date task
		handlerUpdateDate.removeCallbacks(handlerUpdateDateTask);
		handlerUpdateDate.postDelayed(handlerUpdateDateTask,
				HANDLER_UPDATE_TIME);

		// focus default button
		btnSetViewToday.requestFocus();
	}

	private void forceUpdateLayout() {
		handlerUpdateView.removeCallbacks(handlerUpdateViewTask);
		handlerUpdateView.postDelayed(handlerUpdateViewTask, 100);
	}

	private Runnable handlerUpdateViewTask = new Runnable() {
		public void run() {
			rlayAgenda.postInvalidate();
			rlayAgenda.requestLayout();
			rlayAgendaView.postInvalidate();
			rlayAgendaView.requestLayout();
		}
	};

	private Runnable handlerUpdateDateTask = new Runnable() {
		public void run() {
			try {
				updateTodayDate();

				// refresh data, if system timer minute changed
				if (iUpdateDate_minute != dateToday.get(Calendar.MINUTE)) {
					iUpdateDate_minute = dateToday.get(Calendar.MINUTE);

					// autorefresh only today view
					if (iCurrentAgendaViewType == AbstractAgendaView.viewMode.TODAY) {
						if (currentAgendaView != null)
							currentAgendaView
									.SetViewStartDate(latestDateToday());
						refreshData();
					}
				}
			} finally {
				handlerUpdateDate.postDelayed(this, HANDLER_UPDATE_TIME);
			}
		}
	};

	// refresh start view date
	public synchronized void updateTodayDate() {
		dateToday.setTimeInMillis(System.currentTimeMillis());
		dateToday.setFirstDayOfWeek(prefs.iFirstDayOfWeek);
	}

	public synchronized void refreshData() {
		// set title
		SetActivityTitle(utils.GetLongDate(dateToday));

		// set week nr label
		setWeekNrText(currentAgendaView.GetViewStartDate());

		// update weeknr view
		updateWeekNrInfoVisibility();

		// update view info view
		updateSelectViewText(iCurrentAgendaViewType);

		// update button text date
		updateCurrentViewItemDate();

		// reload data
		if (userdb.DatabaseReady()) {
			// filter data
			dataViewAppt.FilterData(currentAgendaView.GetViewStartDate(),
					currentAgendaView.getViewType());
			if (iCurrentAgendaViewType == AbstractAgendaView.viewMode.TODAY) {
				dataViewTask.FilterData(currentAgendaView.GetViewStartDate(),
						currentAgendaView.getViewType());
				dataViewNote.FilterData(currentAgendaView.GetViewStartDate(),
						currentAgendaView.getViewType());
			}
			// rebuild views
			currentAgendaView.RebuildViewAppointments(dataViewAppt);
			if (iCurrentAgendaViewType == AbstractAgendaView.viewMode.TODAY) {
				currentAgendaView.rebuildViewTasks(dataViewTask);
				currentAgendaView.rebuildViewNotes(dataViewNote);
			}
		}

		// set scroll view top position
		scrollViewAgenda.scrollTo(0, 0);
	}

	public void RefreshAgendaAfterViewItemChange() {
		btnSelectViewItemToday.setText("...");
		setWeekNrText(currentAgendaView.GetViewStartDate());
		updateWeekNrInfoVisibility();

		// filter data
		dataViewAppt.FilterData(currentAgendaView.GetViewStartDate(),
				currentAgendaView.getViewType());

		// rebuild view
		currentAgendaView.RebuildViewAppointments(dataViewAppt);

		updateCurrentViewItemDate();
	}

	public void updateCurrentViewItemDate() {
		String s = "";
		if (iCurrentAgendaViewType == AbstractAgendaView.viewMode.DAY)
			s = dateFormatFull.format(
					currentAgendaView.GetViewStartDate().getTime()).toString();
		if (iCurrentAgendaViewType == AbstractAgendaView.viewMode.WEEK)
			s = dateFormatFull.format(
					currentAgendaView.GetViewStartDate().getTime()).toString();
		if (iCurrentAgendaViewType == AbstractAgendaView.viewMode.MONTH)
			s = dateFormatMonth.format(
					currentAgendaView.GetCurrentSelectedMonthAsCalendar()
							.getTime()).toString();
		btnSelectViewItemToday.setText(s);
	}

	// main program date holder
	public Calendar getDateToday() {
		dateToday.setFirstDayOfWeek(prefs.iFirstDayOfWeek);
		return dateToday;
	}

	private Calendar latestDateToday() {
		updateTodayDate();
		return getDateToday();
	}

	private void setWeekNrText(Calendar date) {
		int iNr = date.get(Calendar.WEEK_OF_YEAR);
		labWeekNr.setText(Integer.toString(iNr));
	}

	private void updateWeekNrInfoVisibility() {
		if (iCurrentAgendaViewType == AbstractAgendaView.viewMode.MONTH) {
			labWeekStr.setVisibility(View.INVISIBLE);
			labWeekNr.setVisibility(View.INVISIBLE);
		} else {
			labWeekStr.setVisibility(View.VISIBLE);
			labWeekNr.setVisibility(View.VISIBLE);
		}
	}

	private void reloadDataTable(String sTableNameToReload) {
		if (userdb.DatabaseReady()) {
			if (sTableNameToReload.equals(Database.sTableNameAppointments))
				dataViewAppt.ReloadTable();
			if (sTableNameToReload.equals(Database.sTableNameTasks))
				dataViewTask.ReloadTable();
			if (sTableNameToReload.equals(Database.sTableNameNotes))
				dataViewNote.ReloadTable();
		}
	}

	private void reloadAllDataTables() {
		if (userdb.DatabaseReady()) {
			dataViewAppt.ReloadTable();
			dataViewTask.ReloadTable();
			dataViewNote.ReloadTable();
		}
	}

	private void updateSelectViewText(int viewType) {
		String s = "";
		if (iCurrentAgendaViewType == AbstractAgendaView.viewMode.DAY)
			s = utils.GetResStr(R.string.labSelectViewDay);
		if (iCurrentAgendaViewType == AbstractAgendaView.viewMode.WEEK)
			s = utils.GetResStr(R.string.labSelectViewWeek);
		if (iCurrentAgendaViewType == AbstractAgendaView.viewMode.MONTH)
			s = utils.GetResStr(R.string.labSelectViewMonth);
		labSelectViewItem.setText(s);
	}

	public synchronized void setAgendaView(int viewType, Calendar calViewDate) {
		if (userdb.DatabaseReady()) {
			// init view
			iCurrentAgendaViewType = viewType;

			showTopControls(iCurrentAgendaViewType != AbstractAgendaView.viewMode.TODAY);

			// change type
			if (iCurrentAgendaViewType == AbstractAgendaView.viewMode.TODAY)
				currentAgendaView = agendaViewToday;
			if (iCurrentAgendaViewType == AbstractAgendaView.viewMode.DAY)
				currentAgendaView = agendaViewDay;
			if (iCurrentAgendaViewType == AbstractAgendaView.viewMode.WEEK)
				currentAgendaView = agendaViewWeek;
			if (iCurrentAgendaViewType == AbstractAgendaView.viewMode.MONTH)
				currentAgendaView = agendaViewMonth;

			if (currentAgendaView != null)
				currentAgendaView.SetViewStartDate(calViewDate);

			// reload data
			refreshData();

			// set view change buttons
			updateBottomButtonsStateByCurrentView();

			visibleLayoutContentRemove();
			visibleLayoutContentAdd();

		} else {
			utils.ShowMsgResStr(Database.getErrDesc(userdb
					.tablesCreationResult()), Utils.MSGTYPE_ERROR);
		}
	}

	private void visibleLayoutContentRemove() {
		llayAgendaData.removeAllViews();
		scrollViewAgenda.removeAllViews();
	}

	private void visibleLayoutContentAdd() {
		switch (iCurrentAgendaViewType) {
		case TODAY:
			scrollViewAgenda.addView(currentAgendaView.GetParentLayout());
			llayAgendaData.addView(scrollViewAgenda);
			break;
		case DAY:
			scrollViewAgenda.addView(currentAgendaView.GetParentLayout());
			llayAgendaData.addView(scrollViewAgenda);
			break;
		case WEEK:
			llayAgendaData.addView(currentAgendaView.GetParentLayout());
			break;
		case MONTH:
			llayAgendaData.addView(currentAgendaView.GetParentLayout());
			break;
		}
	}

	private void showTopControls(boolean bEnable) {
		// enable
		btnSelectViewItemPrev.setEnabled(bEnable);
		btnSelectViewItemToday.setEnabled(bEnable);
		btnSelectViewItemNext.setEnabled(bEnable);
		rlayAgendaTop.setEnabled(bEnable);

		// focus
		btnSelectViewItemPrev.setFocusable(bEnable);
		btnSelectViewItemToday.setFocusable(bEnable);
		btnSelectViewItemNext.setFocusable(bEnable);
		rlayAgendaTop.setFocusable(bEnable);

		// visibility
		btnSelectViewItemPrev.setVisibility((bEnable) ? View.VISIBLE
				: View.INVISIBLE);
		btnSelectViewItemToday.setVisibility((bEnable) ? View.VISIBLE
				: View.INVISIBLE);
		btnSelectViewItemNext.setVisibility((bEnable) ? View.VISIBLE
				: View.INVISIBLE);

		// resize layout
		MarginLayoutParams mlp = (MarginLayoutParams) rlayAgendaTop
				.getLayoutParams();
		mlp.setMargins(0, 0, 0, 0);
		rlayAgendaTop.getLayoutParams().height = 0;
		if (bEnable) {
			rlayAgendaTop.getLayoutParams().height = android.view.ViewGroup.LayoutParams.WRAP_CONTENT;
			mlp.setMargins(0, 0, 0, 6);
		}

		// refresh view (relayout bug)
		forceUpdateLayout();
	}

	private void openActAppointment(long lRowId, int iHourOfDay, int iMinutes) {
		bundleOtherDataStartup.clear();
		if (lRowId == -1) {
			bundleOtherDataStartup.putInt(
					AbstractCommonActivity.bundleAgendaView, currentAgendaView
							.getViewIndex());
			bundleOtherDataStartup.putLong(
					AbstractCommonActivity.bundleAgendaViewStartDate,
					currentAgendaView.GetViewStartDate().getTimeInMillis());

			if (iHourOfDay != -1)
				bundleOtherDataStartup.putInt(
						AbstractCommonActivity.bundleHourOfDay, iHourOfDay);
			if (iMinutes != -1)
				bundleOtherDataStartup.putInt(
						AbstractCommonActivity.bundleMinutes, iMinutes);

			OpenActivity(0,
					"android.intent.action.AnCal.ACTION_MODE_NEW_APPOINTMENT");
		} else {
			OpenActivity(0,
					"android.intent.action.AnCal.ACTION_MODE_EDIT_APPOINTMENT",
					lRowId);
		}
	}

	private void openActTask(long lRowId) {
		bundleOtherDataStartup.clear();
		if (lRowId == -1)
			OpenActivity(0, "android.intent.action.AnCal.ACTION_MODE_NEW_TASK");
		else
			OpenActivity(0,
					"android.intent.action.AnCal.ACTION_MODE_EDIT_TASK", lRowId);
	}

	private void openActNote(long lRowId) {
		bundleOtherDataStartup.clear();
		if (lRowId == -1)
			OpenActivity(0, "android.intent.action.AnCal.ACTION_MODE_NEW_NOTE");
		else
			OpenActivity(0,
					"android.intent.action.AnCal.ACTION_MODE_EDIT_NOTE", lRowId);
	}

	private void openActOptions() {
		bundleOtherDataStartup.clear();
		OpenActivity(0, "android.intent.action.AnCal.ACTION_MODE_EDIT_OPTIONS");
	}

	private void openActViewAbout() {
		bundleOtherDataStartup.clear();
		OpenActivity(0, "android.intent.action.AnCal.ACTION_MODE_VIEW_ABOUT");
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		super.onActivityResult(requestCode, resultCode, data);

		Bundle extras = AbstractCommonActivity.getIntentExtras(data);
		if (extras != null) {
			if (resultCode == RESULT_OK) {
				// state refresh, because of table updated
				if (extras
						.containsKey(AbstractCommonActivity.bundleTableUpdated)) {
					String sTableNameToReload = extras
							.getString(AbstractCommonActivity.bundleTableUpdated);
					reloadDataTable(sTableNameToReload);
					refreshData();
					updateReminderService(this, prefs,
							AbstractCommonActivity.bundleTableUpdated);
				}
				// state refresh, because of options updated
				if (extras
						.containsKey(AbstractCommonActivity.bundleOptionsUpdated)) {
					prefs.Load();
					if (currentAgendaView.TimeFormatChanged())
						currentAgendaView.updateTimeFormat();
					currentAgendaView.SetTodayViewItem();
					refreshData();
					updateReminderService(this, prefs,
							AbstractCommonActivity.bundleOptionsUpdated);
				}
			}
		}
	}

	public int getViewSpaceWidth() {
		// return rlayAgendaView.getWidth();
		return 320 - 8;
	}

	public int getViewSpaceHeight() {
		// return rlayAgendaView.getHeight();
		return 340;
	}

	/*
	 * public int getViewSpaceWidth() { // TODO: WTF??? // return
	 * rlayAgendaView.getWidth(); Display display =
	 * getWindowManager().getDefaultDisplay(); int width = display.getWidth();
	 * return (int) (width * .9); // return 320- 8; }
	 * 
	 * public int getViewSpaceHeight() { // TODO: WTF??? // return
	 * getWindow().getW Display display =
	 * getWindowManager().getDefaultDisplay(); int height = display.getHeight();
	 * Log .d(OfflineCalendar.class.getName(), "getting the  height: " +
	 * height); return (int) (height * .8); // return
	 * rlayAgendaView.getHeight(); // return height; }
	 */

	public boolean startReminderService() {
		ComponentName cpn = startService(new Intent(OfflineCalendar.this,
				AlarmService.class));
		return (cpn != null);
	}

	// TODO: isn't this something important? Why is it not used?
	/*
	 * public void StopReminderService() { stopService(new
	 * Intent(OfflineCalendar.this, AlarmService.class)); }
	 */

	public static boolean updateReminderService(Context context, Prefs prefs,
			String sKey) {
		Bundle args = new Bundle();
		args.putBoolean(sKey, true);
		// put additional prefs
		args.putBoolean("b24HourMode", prefs.b24HourMode);
		args.putInt("iFirstDayOfWeek", prefs.iFirstDayOfWeek);
		args.putInt("iSnoozeCount", prefs.iSnoozeCount);
		args.putInt("iSnoozeMinutesOverdue", prefs.iSnoozeMinutesOverdue);
		// update service
		Intent intent = new Intent(context, AlarmService.class);
		intent.putExtras(args);
		ComponentName cpn = context.startService(intent);
		return (cpn != null);
	}

	@Override
	protected void restoreStateFromFreeze() {
	}

	public void showTimeZone() {
		// bundleOtherDataStartup.clear();
		// OpenActivity(0,
		// "android.intent.action.AnCal.ACTION_MODE_VIEW_TIME_ZONE");
		Configuration userConfig = new Configuration();
		Settings.System.getConfiguration(getContentResolver(), userConfig);
		Calendar cal = Calendar.getInstance(userConfig.locale);
		TimeZone tz = cal.getTimeZone();
		Toast.makeText(
				this,
				tz.getDisplayName(true, TimeZone.LONG) + " ("
						+ tz.getDisplayName(true, TimeZone.SHORT) + ")",
				Toast.LENGTH_LONG).show();
	}
}
