package pl.magot.vetch.ancal.activities;

import java.util.Calendar;

import pl.magot.vetch.ancal.AbstractCommonActivity;
import pl.magot.vetch.ancal.Prefs;
import pl.magot.vetch.ancal.Utils;
import pl.magot.vetch.widgets.DateWidget;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.TextView;

import com.droidwave.offlinecalendar.R;

public class ActivityAppointmentRepeat extends Activity {
	// fields
	private static final int SELECT_REPEAT_REQUEST = 201;

	private static final String DATAKEY_TYPE = "RepeatType";
	private static final String DATAKEY_EVERY = "Every";
	private static final String DATAKEY_ENDONDATE = "EndOnDate";

	// fields
	public Prefs prefs = null;
	public Utils utils = null;

	// repeat data
	private int iRepeatType = -1;
	private int iRepeatEvery = 0;
	private Calendar calRepeatEnd = Calendar.getInstance();

	// layouts
	private LinearLayout llayAppointmentRepeatEvery = null;
	private LinearLayout llayAppointmentRepeatEndOnDateLabel = null;
	private LinearLayout llayAppointmentRepeatEndOnDate = null;

	// views
	private Spinner repeatSpinner;
	private TextView labRepeatEveryValue = null;
	private Button btnEndOnDate = null;
	private Button btnRepeatDone = null;

	// every value buttons
	private ImageButton btnRepeatEveryDown = null;
	private ImageButton btnRepeatEveryUp = null;

	// methods
	@Override
	public void onCreate(Bundle icicle) {
		super.onCreate(icicle);
		setContentView(R.layout.appointmentrepeat);

		GetExtrasData();

		// restore data from freeze state
		if (icicle != null) {
			iRepeatType = icicle.getInt("repeat");
			iRepeatEvery = icicle.getInt("every");
			calRepeatEnd.setTimeInMillis(icicle.getLong("dateEndOn"));
		}

		// initialize base objects
		prefs = new Prefs(this);
		utils = new Utils(this);

		// initialize views
		InitViews();
		InitState();
	}

	public void GetExtrasData() {
		Bundle bundle = getIntent().getExtras();
		if ((bundle != null) && (bundle.containsKey("EditRepeat"))) {
			iRepeatType = bundle.getInt(DATAKEY_TYPE);
			iRepeatEvery = bundle.getInt(DATAKEY_EVERY);
			calRepeatEnd.setTimeInMillis(bundle.getLong(DATAKEY_ENDONDATE));
		}
	}

	@Override
	protected void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);
		// save controls state
		outState.putInt("repeat", iRepeatType);
		outState.putInt("every", iRepeatEvery);
		outState.putLong("dateEndOn", calRepeatEnd.getTimeInMillis());
	}

	private void InitViews() {
		llayAppointmentRepeatEvery = (LinearLayout) findViewById(R.id.llayAppointmentRepeatEvery);
		llayAppointmentRepeatEndOnDate = (LinearLayout) findViewById(R.id.llayAppointmentRepeatEndOnDate);
		llayAppointmentRepeatEndOnDateLabel = (LinearLayout) findViewById(R.id.llayAppointmentRepeatEndOnDateLabel);

		// repeat spinner
		repeatSpinner = (Spinner) findViewById(R.id.repeatSpinner);
		ArrayAdapter<CharSequence> adapter = ArrayAdapter.createFromResource(
				this, R.array.repeatType, android.R.layout.simple_spinner_item);
		adapter
				.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
		repeatSpinner.setAdapter(adapter);
		repeatSpinner
				.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {

					@Override
					public void onItemSelected(AdapterView<?> parent,
							View view, int position, long id) {
						SetRepeatType(position);
					}

					@Override
					public void onNothingSelected(AdapterView<?> arg0) {
						SetRepeatType(0);
					}
				});

		btnEndOnDate = (Button) findViewById(R.id.btnAppointmentEndOnDate);

		btnRepeatDone = (Button) findViewById(R.id.btnRepeatDone);
		btnRepeatDone.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				EditDone();
			}
		});

		btnEndOnDate.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {

				DateWidget.Open(ActivityAppointmentRepeat.this, true,
						calRepeatEnd, prefs.iFirstDayOfWeek);

			}
		});

		labRepeatEveryValue = (TextView) findViewById(R.id.labRepeatEveryValue);

		btnRepeatEveryDown = (ImageButton) findViewById(R.id.btnRepeatEveryDown);
		btnRepeatEveryDown.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				iRepeatEvery--;
				if (iRepeatEvery < 1)
					iRepeatEvery = 1;
				UpdateEveryValueView();
			}
		});

		btnRepeatEveryUp = (ImageButton) findViewById(R.id.btnRepeatEveryUp);
		btnRepeatEveryUp.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				iRepeatEvery++;
				if (iRepeatEvery > 30)
					iRepeatEvery = 30;
				UpdateEveryValueView();
			}
		});
	}

	public void SetRepeatType(int iRepeatType) {
		// update global value
		this.iRepeatType = iRepeatType;
		// 0: None
		// update title info
		SetActivityTitle("");
		// update controls state
		UpdateRepeatViewsState(iRepeatType);
	}

	public void SetActivityTitle(String sSubTitle) {
		String sTitle = utils.GetResStr(R.string.titleDefaultRepeat);
		if (sSubTitle.length() > 0)
			sTitle += ": " + sSubTitle;
		setTitle(sTitle);
	}

	private void InitState() {
		SetActivityTitle("");

		SetRepeatType(iRepeatType);

		UpdateEveryValueView();
		UpdateEndOnDateView();
	}

	private void UpdateEveryValueView() {
		labRepeatEveryValue.setText(Integer.toString(iRepeatEvery));
	}

	private void UpdateRepeatViewsState(int iRepeatType) {
		// change visibility of repeat views
		if (iRepeatType == 0) // none
		{
			llayAppointmentRepeatEvery.setVisibility(View.GONE);
			llayAppointmentRepeatEndOnDate.setVisibility(View.GONE);
			llayAppointmentRepeatEndOnDateLabel.setVisibility(View.GONE);
		} else {
			// yearly
			if (iRepeatType == 4) {
				llayAppointmentRepeatEvery.setVisibility(View.GONE);
			} else {
				llayAppointmentRepeatEvery.setVisibility(View.VISIBLE);
				llayAppointmentRepeatEndOnDate.setVisibility(View.VISIBLE);
				llayAppointmentRepeatEndOnDateLabel.setVisibility(View.VISIBLE);
			}
		}
		// SetActivityTitle(the repeat type ...);
	}

	private void UpdateEndOnDateView() {
		if (calRepeatEnd.getTimeInMillis() != 0) {
			btnEndOnDate.setText(utils.GetLongDate(calRepeatEnd));
		} else {
			btnEndOnDate.setText(utils.GetResStr(R.string.labNoEndDate));
		}
	}

	public static int getExtraRepeatType(Bundle extras) {
		return extras.getInt(DATAKEY_TYPE);
	}

	public static int getExtraRepeatEvery(Bundle extras) {
		return extras.getInt(DATAKEY_EVERY);
	}

	public static long getExtraRepeatEndOnDate(Bundle extras) {
		return extras.getLong(DATAKEY_ENDONDATE);
	}

	public static void OpenRepeatForEdit(AbstractCommonActivity parent,
			Bundle extras, int iRepeatType, int iEvery, long lEndOnDate) {
		extras.clear();
		extras.putBoolean("EditRepeat", true);
		extras.putInt(DATAKEY_TYPE, iRepeatType);
		extras.putInt(DATAKEY_EVERY, iEvery);
		extras.putLong(DATAKEY_ENDONDATE, lEndOnDate);
		parent
				.OpenActivity(SELECT_REPEAT_REQUEST,
						"android.intent.action.AnCal.ACTION_MODE_EDIT_APPOINTMENTREPEAT");
	}

	public static boolean GetActivityResult(int requestCode, int resultCode,
			Bundle extras) {
		if ((requestCode == SELECT_REPEAT_REQUEST) && (resultCode == RESULT_OK)) {
			if ((extras != null) && (extras.containsKey("EditRepeat"))) {
				return true;
			}
		}
		return false;
	}

	private void EditDone() {
		Bundle bundleResult = new Bundle();
		bundleResult.putBoolean("EditRepeat", true);
		bundleResult.putInt(DATAKEY_TYPE, iRepeatType);
		bundleResult.putInt(DATAKEY_EVERY, iRepeatEvery);
		bundleResult.putLong(DATAKEY_ENDONDATE, calRepeatEnd.getTimeInMillis());

		Intent intentData = new Intent("");
		intentData.putExtras(bundleResult);
		this.setResult(RESULT_OK, intentData);

		finish();
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		super.onActivityResult(requestCode, resultCode, data);

		Bundle extras = AbstractCommonActivity.getIntentExtras(data);
		if (extras != null) {
			// check for date widget edit request code
			if (requestCode == DateWidget.SELECT_DATE_REQUEST) {
				final long lDate = DateWidget.GetSelectedDateOnActivityResult(
						requestCode, resultCode, extras, calRepeatEnd);
				if (lDate != -1) {
					UpdateEndOnDateView();
				}
			}
		}
	}
}
