package pl.magot.vetch.ancal.activities;

import pl.magot.vetch.ancal.AbstractCommonActivity;
import pl.magot.vetch.ancal.database.DataRowNote;
import pl.magot.vetch.ancal.database.DataTable;
import android.os.Bundle;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageButton;

import com.droidwave.offlinecalendar.R;

//New Note activity
public class ActivityNote extends AbstractCommonActivity {
	// private fields
	private DataRowNote dataRow = null;
	private DataTable dataTable = null;

	// views
	private EditText edSubject = null;
	private ImageButton btnDelete = null;
	private ImageButton btnSave = null;

	// methods
	@Override
	public void onCreate(Bundle icicle) {
		super.onCreate(icicle);
		setContentView(R.layout.note);

		// initialize objects
		dataRow = new DataRowNote(userdb);
		dataTable = new DataTable(dataRow);

		// check startup mode and open data
		if (GetStartMode() == StartMode.EDIT)
			if (!OpenDataForEdit(dataTable))
				finish();

		// initialize views
		InitViews();
		InitState();
	}

	private void InitViews() {
		edSubject = (EditText) findViewById(R.id.edNoteSubject);

		btnSave = (ImageButton) findViewById(R.id.btnNoteSave);
		btnSave.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				SaveData();
			}
		});

		btnDelete = (ImageButton) findViewById(R.id.btnNoteDelete);
		btnDelete.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				DeleteData();
			}
		});
	}

	private void InitState() {
		// title
		String sSubTitle = utils.GetResStr(R.string.titleDefaultNote);

		// INSERT MODE
		if (GetStartMode() == StartMode.NEW) {
			sSubTitle = utils.GetResStr(R.string.titleNewNote);
			btnDelete.setVisibility(View.INVISIBLE);
		}

		// EDIT MODE
		if (GetStartMode() == StartMode.EDIT) {
			sSubTitle = utils.GetResStr(R.string.titleEditNote);
			edSubject.setText(dataRow.GetSubject());
			btnDelete.setVisibility(View.VISIBLE);
		}

		restoreStateFromFreezeIfRequired();

		SetActivityTitle(sSubTitle);

		// set focus to subject
		edSubject.requestFocus();
		if (GetStartMode() == StartMode.EDIT)
			edSubject.setSelection(edSubject.length());
	}

	public void SaveData() {
		dataRow.SetSubject(edSubject.getText().toString());

		if (SaveDataToTable(dataTable))
			CloseActivity(dataTable);
	}

	public void DeleteData() {
		if (DeleteDataFromTable(dataTable))
			CloseActivity(dataTable);
	}

	@Override
	protected void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);

		// save controls state
		outState.putString("subject", edSubject.getText().toString());
	}

	@Override
	protected void restoreStateFromFreeze() {
		edSubject.setText(freeze.getString("subject"));
	}
}
