package pl.magot.vetch.ancal.agenda;

import java.util.ArrayList;

import pl.magot.vetch.ancal.dataview.AbstractDataView;
import pl.magot.vetch.ancal.dataview.DataViewItem;
import pl.magot.vetch.ancal.views.ViewDayHourItem;
import pl.magot.vetch.ancal.views.ViewTodayItemAppointment;
import pl.magot.vetch.ancal.views.ViewTodayItemHeader;
import android.graphics.Paint;
import android.widget.LinearLayout;

import com.droidwave.offlinecalendar.OfflineCalendar;

public class AgendaViewDay extends AbstractAgendaView {
	private ArrayList<LinearLayout> vecHourItems = new ArrayList<LinearLayout>();

	// appointment click listener
	public ViewDayHourItem.onItemClick onNewApptItemClick = new ViewDayHourItem.onItemClick() {
		public void onClick(ViewDayHourItem item) {
			doHourOfDayClick(item, ViewTodayItemHeader.ViewType.Appointments,
					item.GetHour(), item.GetMinutes());
		}
	};

	private int iTextHeight = 0;
	private int iHourWidth = 0;
	private int iTimeWidth = 0;
	private int iUSTimeMarkWidth = 0;
	private int iSpaceWidthTime = 0;
	private int iSpaceWidthMinutes = 0;
	private int iSpaceWidthUSTimeMark = 0;

	private Paint mpt = new Paint();

	public AgendaViewDay(OfflineCalendar main) {
		super(main);
		iTextHeight = ViewDayHourItem.GetTextHeight(mpt);
		iHourWidth = ViewDayHourItem.GetSpaceWidthHour(mpt);
		iTimeWidth = ViewDayHourItem.GetSpaceWidthTime(mpt);
		iUSTimeMarkWidth = ViewDayHourItem.GetSpaceWidthUSTimeMark(mpt);
		iSpaceWidthTime = ViewTodayItemAppointment.GetSpaceWidthTime(mpt);
		iSpaceWidthMinutes = ViewTodayItemAppointment.GetSpaceWidthMinutes(mpt);
		iSpaceWidthUSTimeMark = ViewTodayItemAppointment
				.GetSpaceWidthUSTimeMark(mpt);
	}

	@Override
	public int getViewType() {
		return viewMode.DAY;
	}

	@Override
	public int getViewIndex() {
		return 1;
	}

	@Override
	public void rebuild() {
		llayParent.removeAllViews();

		vecHourItems.clear();

		// build 24 hour day view
		for (int iHour = 0; iHour < 24; iHour++) {
			ViewDayHourItem item = new ViewDayHourItem(main, iHour, iTextHeight);
			item.SetItemData(main.prefs.b24HourMode, iHourWidth, iTimeWidth,
					iUSTimeMarkWidth);
			llayParent.addView(item);
			vecHourItems.add(iHour, item);
		}
	}

	private void removeChildViewsFromAllHourItems() {
		for (int iHour = 0; iHour < vecHourItems.size(); iHour++) {
			LinearLayout item = vecHourItems.get(iHour);
			if (item != null)
				item.removeAllViewsInLayout();
		}
		llayParent.invalidate();
	}

	@Override
	public void RebuildViewAppointments(AbstractDataView dataView) {
		final boolean bIsViewToday = IsViewToday();
		final int iCurrentHour = getTodayCurrentHour();

		removeChildViewsFromAllHourItems();

		// update time format
		for (int iHour = 0; iHour < vecHourItems.size(); iHour++) {
			ViewDayHourItem item = (ViewDayHourItem) vecHourItems.get(iHour);
			item.SetItemData(main.prefs.b24HourMode, iHourWidth, iTimeWidth,
					iUSTimeMarkWidth);
			item.SetCurrentHour((bIsViewToday) ? iCurrentHour : -1);
			item.requestLayout();
		}

		// rebuild view
		for (int i = 0; i < dataView.GetRowsCountTotal(); i++) {
			DataViewItem row = dataView.GetRow(i, this.getViewType());
			if (row != null) {
				int iHour = row.GetStartHour();
				ViewTodayItemAppointment item = new ViewTodayItemAppointment(
						main);
				item.SetRowId(row.lID);
				item.SetItemTime(row.GetStartHour(), row.GetStartMinute(),
						true, main.prefs.b24HourMode, iSpaceWidthTime,
						iSpaceWidthMinutes, iSpaceWidthUSTimeMark);
				item.SetItemData(row.sSubject, row.bAlarm, row.IsRepeat());
				item.SetItemClick(onApptItemClick);

				ViewDayHourItem hourItem = (ViewDayHourItem) vecHourItems
						.get(iHour);
				if (hourItem != null) {
					hourItem.addView(item, lparams);
				}
			}
		}

		// update heights
		for (int iHour = 0; iHour < 24; iHour++) {
			ViewDayHourItem item = (ViewDayHourItem) vecHourItems.get(iHour);
			item.UpdateHeight();
			item.SetItemClick(onNewApptItemClick);
		}
	}

	public void rebuildViewNotes(AbstractDataView dataView) {
		// implement abstract method
	}

	public void rebuildViewTasks(AbstractDataView dataView) {
		// implement abstract method
	}

	@Override
	public void updateTimeFormat() {
		for (int iHour = 0; iHour < vecHourItems.size(); iHour++) {
			ViewDayHourItem item = (ViewDayHourItem) vecHourItems.get(iHour);
			if (item != null)
				item.updateTimeFormat(main.prefs.b24HourMode, iHourWidth,
						iTimeWidth, iUSTimeMarkWidth);
		}
	}
}
